/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.aimp.cmapp.sdk.ext.CosmicCommonUtils;
import kd.aimp.cmapp.sdk.ext.CosmicComposite;
import kd.aimp.cmapp.sdk.ext.CosmicSingle;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CosmicMustacheAction
implements IGPTAction {
    private static final Log logger = LogFactory.getLog(CosmicMustacheAction.class);
    private static final int INIT_CAP = 16;

    public static String indicatorProcessTemplate(String text, List<Map<String, Object>> modelValues) {
        JSONObject jsonObject = JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject main = jsonObject.getJSONObject("main");
        JSONObject sub = jsonObject.getJSONObject("sub");
        JSONObject rateJson = jsonObject.getJSONObject("rate");
        String mainKey = (String)main.keySet().iterator().next();
        String subKey = (String)sub.keySet().iterator().next();
        String rateKey = (String)rateJson.keySet().iterator().next();
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        String template = "{\"title\":\"{{title}}\",\"value\":\"{{value}}\",\"rate\":{\"value\":\"{{rate.value}}\",\"baseValue\":\"{{rate.baseValue}}\"},\"sub\":[{{#subItems}}{\"title\":\"{{title}}\",\"value\":\"{{value}}\"}{{/subItems}}]}";
        try {
            Mustache mustache = mf.compile((Reader)new StringReader(template), "indicatorTemplate");
            for (Map<String, Object> model : modelValues) {
                if (model.get(mainKey) == null) continue;
                HashMap<String, Object> dataModel = new HashMap<String, Object>(16);
                dataModel.put("title", main.get((Object)mainKey));
                dataModel.put("value", model.get(mainKey));
                HashMap<String, String> rate = new HashMap<String, String>(16);
                String value = String.valueOf(model.get(rateKey));
                if (!value.contains("%")) {
                    value = String.format("%s%s", new BigDecimal(value).multiply(BigDecimal.valueOf(100L)), "%");
                }
                rate.put("value", value);
                rate.put("baseValue", "100%");
                dataModel.put("rate", rate);
                ArrayList subItems = new ArrayList(16);
                HashMap<String, String> subItem = new HashMap<String, String>(16);
                subItem.put("title", sub.getString(subKey));
                subItem.put("value", String.valueOf(model.get(subKey)));
                subItems.add(subItem);
                dataModel.put("subItems", subItems);
                StringWriter writer = new StringWriter();
                mustache.execute((Writer)writer, dataModel).flush();
                return writer.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public Map<String, String> invokeAction(String action, Map<String, String> map) {
        logger.info("\u4ece\u4e0a\u6e38\u63a5\u6536\u5230\u7684\u53c2\u6570\u4e3a:{}", (Object)map.toString());
        try {
            String table;
            HashMap<String, String> rtn = new HashMap<String, String>(16);
            String businessStr = CosmicCommonUtils.query("businessType");
            Map businessType = (Map)JSONObject.parseObject((String)businessStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            String filedData = map.get("fieldData");
            String type = map.get("type");
            String title = map.get("title");
            String total = map.get("total");
            String order = map.get("order");
            String targetTitle = map.get("targetTitle");
            JSONObject dataObj = JSONObject.parseObject((String)filedData);
            Set keys = dataObj.keySet();
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(16);
            for (String key : keys) {
                JSONObject keyJo = dataObj.getJSONObject(key);
                List fieldNames = keyJo.getJSONArray("fieldNames").toJavaList(String.class);
                JSONArray valuesArray = keyJo.getJSONArray("values");
                for (int i = 0; i < valuesArray.size(); ++i) {
                    JSONArray rowArray = valuesArray.getJSONArray(i);
                    LinkedHashMap<Object, Object> rowMap = new LinkedHashMap<Object, Object>(16);
                    for (int j = 0; j < rowArray.size(); ++j) {
                        if (type.equalsIgnoreCase("textboard")) {
                            rowMap.put(fieldNames.get(j), rowArray.get(j));
                            continue;
                        }
                        rowMap.put(key + "." + (String)fieldNames.get(j), rowArray.get(j));
                    }
                    values.add(rowMap);
                }
            }
            String text = "";
            String[] types = null;
            if (type.equalsIgnoreCase("single")) {
                String single = CosmicSingle.single(keys, title, type, values);
                rtn.put("data", single);
            } else if (type.equalsIgnoreCase("bar") || type.equalsIgnoreCase("table") || type.equalsIgnoreCase("pie") || type.equalsIgnoreCase("line")) {
                table = CosmicSingle.tableProcessTemplate(keys, title, type, values, "", "");
                rtn.put("data", table);
            } else if (type.equalsIgnoreCase("rank")) {
                table = CosmicSingle.tableProcessTemplate(keys, title, type, values, order, total);
                rtn.put("data", table);
            } else {
                String mode = (String)businessType.get(type);
                types = mode.split(",").length == 1 ? new String[]{type} : mode.split(",");
                JSONObject root = new JSONObject();
                JSONArray data = new JSONArray();
                for (String ty : types) {
                    Map<String, Object> textboard;
                    JSONObject jsonObject;
                    text = CosmicCommonUtils.query(ty);
                    String mod = (String)businessType.get(ty);
                    if (mod.equals("indiboard")) {
                        Map<String, Object> indicator = CosmicComposite.indicatorProcess(text, values);
                        JSONObject indiboard = new JSONObject();
                        indiboard.put("type", (Object)"indiboard");
                        indiboard.put("numberFormat", (Object)"{0}#,##0\u5343");
                        indiboard.put("data", indicator);
                        indiboard.put("title", (Object)targetTitle);
                        data.add((Object)indiboard);
                    } else if (mod.equals("panel")) {
                        List<Object> textPanel = CosmicComposite.panelProcessTemplate(text, values);
                        jsonObject = JSONObject.parseObject((String)text);
                        JSONObject panel = new JSONObject();
                        panel.put("type", (Object)"panel");
                        panel.put("title", (Object)jsonObject.getString("title"));
                        panel.put("numberFormat", (Object)"{0}#,##0\u5343");
                        panel.put("data", textPanel);
                        data.add((Object)panel);
                    } else if (mod.equalsIgnoreCase("textboard")) {
                        textboard = CosmicComposite.textBoardProcess(text, (Map)values.get(0));
                        JSONObject textJson = new JSONObject();
                        textJson.put("type", (Object)"textboard");
                        textJson.put("data", textboard);
                        textJson.put("title", (Object)targetTitle);
                        data.add((Object)textJson);
                    } else if (mod.equalsIgnoreCase("listboard")) {
                        textboard = CosmicComposite.listBoardProcess(title, total, text, values);
                        jsonObject = JSONObject.parseObject((String)text);
                        JSONObject textJson = new JSONObject();
                        textJson.put("numberFormat", (Object)jsonObject.getString("numberFormat"));
                        textJson.put("type", (Object)"listboard");
                        textJson.put("data", textboard);
                        textJson.put("title", (Object)targetTitle);
                        data.add((Object)textJson);
                    }
                    root.put("data", (Object)data);
                }
                rtn.put("data", root.toJSONString());
            }
            return rtn;
        }
        catch (Exception e) {
            logger.error("Exception:{}", (Object)e.getMessage());
            return new HashMap<String, String>(16);
        }
    }
}

