/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.util.List;
import java.util.Optional;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.BaseData;
import kd.aimp.cmapp.sdk.dto.chart.in.FieldData;
import kd.bos.util.StringUtils;

public abstract class AbstractCosmicChartHandler<T extends BaseData>
implements CosmicChartHandler<T> {
    protected static final String TITLE = "title";
    protected static final String URL = "url";
    protected static final String UNIT = "unit";
    protected static final String CURRENCY = "currency";

    @Override
    public String buildChart(T t) {
        if (null == t) {
            return null;
        }
        return this.doBuildChart(t);
    }

    protected abstract String doBuildChart(T var1);

    protected String getOrDefaultNumberFormat(String numberFormat) {
        return Optional.ofNullable(numberFormat).filter(StringUtils::isNotEmpty).orElse("#,##0.00");
    }

    protected Integer[] getNameAndValueIdx(List<FieldData> fieldDatas) {
        Integer nameIdx = null;
        Integer valueIdx = null;
        for (int i = 0; i < fieldDatas.size(); ++i) {
            FieldData fieldData = fieldDatas.get(i);
            if (null == valueIdx && fieldData.isNumerical()) {
                valueIdx = i;
            }
            if (null != nameIdx || fieldData.isNumerical()) continue;
            nameIdx = i;
        }
        if (null == nameIdx || null == valueIdx) {
            return null;
        }
        return new Integer[]{nameIdx, valueIdx};
    }
}

