/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicBi;
import kd.aimp.cmapp.sdk.dto.chart.out.OutBaseData;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class BiChartHandler
extends AbstractCosmicChartHandler<TableData> {
    @Override
    protected String doBuildChart(TableData tableData) {
        CosmicBi bi = new CosmicBi();
        bi.setChartType(tableData.getChartType());
        List<CosmicBi.BiField> fields = tableData.getFields().stream().map(fieldData -> {
            CosmicBi.BiField biField = new CosmicBi.BiField();
            biField.setType(this.getType(fieldData.getFieldType()));
            biField.setRole(fieldData.isNumerical() ? "measure" : "dimension");
            biField.setAlias(fieldData.getFieldName());
            String format = fieldData.getNumberFormat();
            if (fieldData.isNumerical() && StringUtils.isNotEmpty((String)format)) {
                CosmicBi.BiFormat biFormat = new CosmicBi.BiFormat();
                NumberFormater numberFormater = new NumberFormater(fieldData.getNumberFormat());
                NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
                biFormat.setPrecision(String.valueOf(rich.getDecimalPure().length() - 2));
                biFormat.setSeparator(rich.getSeparator());
                biFormat.setPrefix(rich.getPrefix());
                biFormat.setSuffix(rich.getSuffix());
                biFormat.setPow(String.valueOf(rich.getUnitPower()));
                biFormat.setPrecisionType("round");
                biField.setFormat(biFormat);
            } else if ("DATE".equals(fieldData.getFieldType()) && StringUtils.isNotEmpty((String)format)) {
                String regex = "(?>([\\u4e00-\\u9fa5\\w]+))?\\{(.+)}(?>([\\u4e00-\\u9fa5\\w]+))?";
                Pattern pattern = Pattern.compile(regex, 2);
                Matcher matcher = pattern.matcher(format);
                CosmicBi.BiFormat biFormat = new CosmicBi.BiFormat();
                if (matcher.find()) {
                    biFormat.setPrefix(matcher.group(1));
                    biFormat.setDateFormat(matcher.group(2));
                    biFormat.setSuffix(matcher.group(3));
                }
                biField.setFormat(biFormat);
            }
            return biField;
        }).collect(Collectors.toList());
        bi.setFields(fields);
        bi.setRows(tableData.getFieldValues());
        if (CollectionUtils.isNotEmpty(tableData.getSql())) {
            bi.setSql(tableData.getSql().stream().map(OutBaseData.Sql::new).collect(Collectors.toList()));
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("title", tableData.getTitle());
        attrs.put("url", tableData.getUrl());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_BI, attrs, bi.toJsonStr());
    }

    private String getType(String type) {
        if ("DATE".equals(type)) {
            return "date";
        }
        if ("NUM".equals(type)) {
            return "float";
        }
        return "text";
    }
}

