/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.CompareData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicCompare;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;

public class CompareChartHandler
extends AbstractCosmicChartHandler<CompareData> {
    @Override
    protected String doBuildChart(CompareData compareData) {
        CosmicCompare compare = new CosmicCompare();
        NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(compareData.getNumberFormat()));
        NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
        NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
        ArrayList<CosmicCompare.CompareData> data = new ArrayList<CosmicCompare.CompareData>(10);
        CosmicCompare.CompareData compareData1 = new CosmicCompare.CompareData();
        compareData1.setUnit(rich.getSuffix());
        compareData1.setCurrency(rich.getPrefix());
        compareData1.setTitle(compareData.getCompareMetricName());
        BigDecimal compareValue = Optional.ofNullable(compareData.getCompareMetricValue()).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
        compareData1.setValue(dataNumberFormater.format(compareValue));
        data.add(compareData1);
        CosmicCompare.CompareData compareData2 = new CosmicCompare.CompareData();
        compareData2.setUnit(rich.getSuffix());
        compareData2.setCurrency(rich.getPrefix());
        compareData2.setTitle(compareData.getBaseMetricName());
        BigDecimal baseValue = Optional.ofNullable(compareData.getBaseMetricValue()).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
        compareData2.setValue(dataNumberFormater.format(baseValue));
        data.add(compareData2);
        compare.setData(data);
        compare.setType(compareData.getType());
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("title", compareData.getTitle());
        attrs.put("url", compareData.getUrl());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_COMPARE, attrs, compare.toJsonStr());
    }
}

