/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.aimp.cmapp.sdk.chart.handler.CosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.BaseData;
import kd.aimp.cmapp.sdk.enums.ChartType;
import kd.bos.dataentity.TypesContainer;
import kd.bos.util.StringUtils;

public class CosmicChartHandlerFactory {
    private static final Map<String, String> CHART_HANDLER_MAP = new ConcurrentHashMap<String, String>();

    private CosmicChartHandlerFactory() {
    }

    public static CosmicChartHandler<BaseData> getHandler(String chartType) {
        if (StringUtils.isEmpty((String)chartType)) {
            return null;
        }
        return CosmicChartHandlerFactory.getHandler(ChartType.valueOf(chartType.toLowerCase()));
    }

    public static CosmicChartHandler<BaseData> getHandler(ChartType chartType) {
        if (null == chartType || !CHART_HANDLER_MAP.containsKey(chartType.name())) {
            return null;
        }
        return (CosmicChartHandler)TypesContainer.getOrRegisterSingletonInstance((String)CHART_HANDLER_MAP.get(chartType.name()));
    }

    static {
        for (ChartType chartType : ChartType.values()) {
            CHART_HANDLER_MAP.put(chartType.name(), chartType.getHandler().getTypeName());
        }
    }
}

