/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicCharts;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.enums.ChartType;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;

public class LineChartHandler
extends AbstractCosmicChartHandler<TableData> {
    @Override
    protected String doBuildChart(TableData tableData) {
        List<List<Object>> fieldValues = tableData.getFieldValues();
        if (null == fieldValues || fieldValues.isEmpty()) {
            return null;
        }
        Integer[] idxs = this.getNameAndValueIdx(tableData.getFields());
        if (null == idxs) {
            return null;
        }
        Integer nameIdx = idxs[0];
        Integer valueIdx = idxs[1];
        List xData = fieldValues.stream().map(m -> m.get(nameIdx)).collect(Collectors.toList());
        List data = fieldValues.stream().map(m -> m.get(valueIdx)).collect(Collectors.toList());
        NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(tableData.getNumberFormat()));
        NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
        String unit = rich.getSuffix();
        NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
        data = data.stream().map(d -> null == d ? BigDecimal.ZERO : NumberFormater.revert(String.valueOf(d))).map(dataNumberFormater::format).collect(Collectors.toList());
        CosmicCharts cosmicCharts = new CosmicCharts();
        LinkedHashMap<String, Object> xAxis = new LinkedHashMap<String, Object>();
        xAxis.put("type", "category");
        xAxis.put("data", xData);
        cosmicCharts.setXAxis(xAxis);
        LinkedHashMap<String, Object> yAxis = new LinkedHashMap<String, Object>();
        cosmicCharts.setYAxis(yAxis);
        yAxis.put("type", "value");
        if (null != unit && unit.length() > 0) {
            yAxis.put("name", unit);
        }
        LinkedHashMap<String, Object> series = new LinkedHashMap<String, Object>();
        series.put("type", ChartType.line.name());
        series.put("data", data);
        cosmicCharts.setSeries(series);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("title", tableData.getTitle());
        attrs.put("url", tableData.getUrl());
        attrs.put("unit", rich.getSuffix());
        attrs.put("currency", rich.getPrefix());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_CHARTS, attrs, cosmicCharts.toJsonStr());
    }
}

