/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.FieldData;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.StringUtils;

public class MarkdownChartHandler
extends AbstractCosmicChartHandler<TableData> {
    @Override
    protected String doBuildChart(TableData tableData) {
        List<FieldData> fieldDatas = tableData.getFields();
        List<List<Object>> fieldValues = tableData.getFieldValues();
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        for (FieldData fieldData : fieldDatas) {
            NumberFormater numberFormater;
            NumberFormater.RichFormatString rich;
            String suffix;
            sb.append(fieldData.getFieldName());
            if (fieldData.isNumerical() && StringUtils.isNotEmpty((String)(suffix = (rich = (numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(fieldData.getNumberFormat()))).getFirstRichFormatString()).getSuffix()))) {
                sb.append("\uff08").append(suffix).append("\uff09");
            }
            sb.append("|");
        }
        sb.append("\n|");
        for (int i = 0; i < fieldDatas.size(); ++i) {
            sb.append("---").append("|");
        }
        for (List<Object> fieldValue : fieldValues) {
            sb.append("\n|");
            for (int j = 0; j < fieldDatas.size(); ++j) {
                FieldData fieldData = fieldDatas.get(j);
                if (fieldData.isNumerical()) {
                    NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(fieldData.getNumberFormat()));
                    NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
                    NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
                    BigDecimal value = Optional.ofNullable(fieldValue.get(j)).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
                    sb.append(dataNumberFormater.format(value));
                } else {
                    sb.append(fieldValue.get(j));
                }
                sb.append("|");
            }
        }
        return sb.toString();
    }
}

