/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicCharts;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.enums.ChartType;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;

public class PieChartHandler
extends AbstractCosmicChartHandler<TableData> {
    @Override
    protected String doBuildChart(TableData tableData) {
        List<List<Object>> fieldValues = tableData.getFieldValues();
        if (null == fieldValues || fieldValues.isEmpty()) {
            return null;
        }
        Integer[] idxs = this.getNameAndValueIdx(tableData.getFields());
        if (null == idxs) {
            return null;
        }
        Integer nameIdx = idxs[0];
        Integer valueIdx = idxs[1];
        NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(tableData.getNumberFormat()));
        NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
        NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
        ArrayList<JSONObject> data = new ArrayList<JSONObject>(fieldValues.size());
        for (int i = 0; i < fieldValues.size(); ++i) {
            Object name = fieldValues.get(i).get(nameIdx);
            Object value = fieldValues.get(i).get(valueIdx);
            JSONObject obj = new JSONObject();
            obj.put("name", name);
            BigDecimal val = Optional.ofNullable(value).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
            obj.put("value", (Object)dataNumberFormater.format(val));
            data.add(obj);
        }
        CosmicCharts cosmicCharts = new CosmicCharts();
        LinkedHashMap<String, Object> series = new LinkedHashMap<String, Object>();
        series.put("type", ChartType.pie.name());
        series.put("data", data);
        cosmicCharts.setSeries(series);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("title", tableData.getTitle());
        attrs.put("url", tableData.getUrl());
        attrs.put("unit", rich.getSuffix());
        attrs.put("currency", rich.getPrefix());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_CHARTS, attrs, cosmicCharts.toJsonStr());
    }
}

