/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.RankData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicRank;
import kd.aimp.cmapp.sdk.dto.chart.out.OutBaseData;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.CollectionUtils;

public class RankChartHandler
extends AbstractCosmicChartHandler<RankData> {
    @Override
    protected String doBuildChart(RankData rankData) {
        List<List<Object>> fieldValues = rankData.getFieldValues();
        List<Object> baseValues = rankData.getBaseValues();
        if (null == fieldValues || fieldValues.isEmpty()) {
            return null;
        }
        Integer[] idxs = this.getNameAndValueIdx(rankData.getFields());
        if (null == idxs) {
            return null;
        }
        Integer nameIdx = idxs[0];
        Integer valueIdx = idxs[1];
        CosmicRank rank = new CosmicRank();
        NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(rankData.getNumberFormat()));
        NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
        NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
        ArrayList<CosmicRank.RankData> data = new ArrayList<CosmicRank.RankData>(10);
        for (int i = 0; i < fieldValues.size(); ++i) {
            CosmicRank.RankData crRankData = new CosmicRank.RankData();
            Object name = fieldValues.get(i).get(nameIdx);
            Object val = fieldValues.get(i).get(valueIdx);
            crRankData.setTitle(String.valueOf(name));
            BigDecimal value = Optional.ofNullable(val).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
            crRankData.setValue(dataNumberFormater.format(value));
            if (CollectionUtils.isNotEmpty(baseValues) && baseValues.size() > i) {
                BigDecimal baseValue = Optional.ofNullable(baseValues.get(i)).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
                crRankData.setBaseValue(dataNumberFormater.format(baseValue));
            }
            crRankData.setUnit(rich.getSuffix());
            crRankData.setCurrency(rich.getPrefix());
            data.add(crRankData);
        }
        rank.setData(data);
        if (CollectionUtils.isNotEmpty(rankData.getSql())) {
            rank.setSql(rankData.getSql().stream().map(OutBaseData.Sql::new).collect(Collectors.toList()));
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("title", rankData.getTitle());
        attrs.put("url", rankData.getUrl());
        attrs.put("order", rankData.getOrder());
        attrs.put("total", rankData.getTotal());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_RANK, attrs, rank.toJsonStr());
    }
}

