/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.SingleData;
import kd.aimp.cmapp.sdk.dto.chart.out.OutBaseData;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.CollectionUtils;

public class SingleChartHandler
extends AbstractCosmicChartHandler<SingleData> {
    @Override
    protected String doBuildChart(SingleData singleData) {
        BigDecimal value = Optional.ofNullable(singleData.getMetricValue()).map(String::valueOf).map(BigDecimal::new).orElse(BigDecimal.ZERO);
        NumberFormater numberFormater = new NumberFormater(singleData.getNumberFormat());
        HashMap<String, String> attrs = new HashMap<String, String>(4);
        attrs.put("url", singleData.getUrl());
        attrs.put("label", singleData.getMetricName());
        attrs.put("value", numberFormater.format(value));
        OutBaseData outBaseData = new OutBaseData();
        if (CollectionUtils.isNotEmpty(singleData.getSql())) {
            outBaseData.setSql(singleData.getSql().stream().map(OutBaseData.Sql::new).collect(Collectors.toList()));
        }
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_CARD, attrs, JSONObject.toJSONString((Object)outBaseData));
    }
}

