/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.FieldData;
import kd.aimp.cmapp.sdk.dto.chart.in.TableData;
import kd.aimp.cmapp.sdk.dto.chart.out.CosmicTable;
import kd.aimp.cmapp.sdk.dto.chart.out.OutBaseData;
import kd.aimp.cmapp.sdk.enums.ChartAlign;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class TableChartHandler
extends AbstractCosmicChartHandler<TableData> {
    @Override
    protected String doBuildChart(TableData tableData) {
        CosmicTable table = new CosmicTable();
        NumberFormater numberFormater = new NumberFormater(this.getOrDefaultNumberFormat(tableData.getNumberFormat()));
        NumberFormater.RichFormatString rich = numberFormater.getFirstRichFormatString();
        NumberFormater dataNumberFormater = new NumberFormater("{" + rich.getUnitPower() + "}" + rich.getDecimalPure());
        List<FieldData> fieldDatas = tableData.getFields();
        List<List<Object>> fieldValues = tableData.getFieldValues();
        ArrayList<CosmicTable.TableColumn> tableColumns = new ArrayList<CosmicTable.TableColumn>(10);
        for (FieldData fieldData : fieldDatas) {
            CosmicTable.TableColumn tableColumn = new CosmicTable.TableColumn();
            tableColumn.setTitle(fieldData.getFieldName());
            tableColumn.setDataKey(fieldData.getField());
            if (fieldData.isNumerical()) {
                if (StringUtils.isNotEmpty((String)fieldData.getNumberFormat())) {
                    NumberFormater fieldNumberFormater = new NumberFormater(this.getOrDefaultNumberFormat(fieldData.getNumberFormat()));
                    NumberFormater.RichFormatString fieldRich = fieldNumberFormater.getFirstRichFormatString();
                    tableColumn.setAlign(ChartAlign.right.name());
                    tableColumn.setUnit(fieldRich.getSuffix());
                    tableColumn.setCurrency(fieldRich.getPrefix());
                } else {
                    tableColumn.setAlign(ChartAlign.right.name());
                    tableColumn.setUnit(rich.getSuffix());
                    tableColumn.setCurrency(rich.getPrefix());
                }
            }
            tableColumns.add(tableColumn);
        }
        table.setColumns(tableColumns);
        ArrayList<JSONObject> data = new ArrayList<JSONObject>(10);
        for (List<Object> list : fieldValues) {
            JSONObject d = new JSONObject();
            for (int j = 0; j < fieldDatas.size(); ++j) {
                FieldData fieldData = fieldDatas.get(j);
                if (fieldData.isNumerical()) {
                    NumberFormater formater = dataNumberFormater;
                    if (StringUtils.isNotEmpty((String)fieldData.getNumberFormat())) {
                        NumberFormater fieldNumberFormater = new NumberFormater(this.getOrDefaultNumberFormat(fieldData.getNumberFormat()));
                        NumberFormater.RichFormatString fieldRich = fieldNumberFormater.getFirstRichFormatString();
                        formater = new NumberFormater("{" + fieldRich.getUnitPower() + "}" + fieldRich.getDecimalPure());
                    }
                    BigDecimal value = Optional.ofNullable(list.get(j)).map(String::valueOf).map(NumberFormater::revert).orElse(BigDecimal.ZERO);
                    d.put(fieldData.getField(), (Object)formater.format(value));
                    continue;
                }
                d.put(fieldData.getField(), list.get(j));
            }
            data.add(d);
        }
        table.setData(data);
        if (CollectionUtils.isNotEmpty(tableData.getSql())) {
            table.setSql(tableData.getSql().stream().map(OutBaseData.Sql::new).collect(Collectors.toList()));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("title", tableData.getTitle());
        hashMap.put("url", tableData.getUrl());
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_TABLE, hashMap, table.toJsonStr());
    }
}

