/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.chart.handler;

import java.util.HashMap;
import kd.aimp.cmapp.sdk.chart.handler.AbstractCosmicChartHandler;
import kd.aimp.cmapp.sdk.dto.chart.in.CosmicUlData;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.CosmicChartUtils;
import kd.bos.util.StringUtils;

public class UlChartHandler
extends AbstractCosmicChartHandler<CosmicUlData> {
    @Override
    protected String doBuildChart(CosmicUlData cosmicUlData) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)cosmicUlData.getType())) {
            attrs.put("type", cosmicUlData.getType());
        }
        if (cosmicUlData.isMulti()) {
            attrs.put("checkbox", "true");
        }
        if (StringUtils.isNotEmpty((String)cosmicUlData.getField())) {
            attrs.put("field", cosmicUlData.getField());
        }
        if (StringUtils.isNotEmpty((String)cosmicUlData.getFieldName())) {
            attrs.put("fieldName", cosmicUlData.getFieldName());
        }
        attrs.put("question", "{text}");
        return CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_UL, attrs, this.buildCosmicLis(cosmicUlData));
    }

    private String buildCosmicLis(CosmicUlData cosmicUlData) {
        StringBuilder sb = new StringBuilder();
        for (CosmicUlData.SelectValue selectValue : cosmicUlData.getValues()) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            String id = selectValue.getId();
            String number = selectValue.getNumber();
            if (StringUtils.isNotEmpty((String)id)) {
                attrs.put("id", id);
            }
            if (StringUtils.isNotEmpty((String)number)) {
                attrs.put("number", number);
            }
            sb.append(CosmicChartUtils.buildCosmicLabel(ChartLable.COSMIC_LI, attrs, selectValue.getName()));
        }
        return sb.toString();
    }
}

