/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.aimp.cmapp.sdk.cui.base.dto.BaseDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.BaseVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.CUIHandler;
import kd.bos.dataentity.TypesContainer;

public class CUIFactory {
    private static final Map<String, String> serviceMap = new ConcurrentHashMap<String, String>();

    public static CUIHandler<BaseDTO, BaseVO> getService(String type) {
        String className = serviceMap.get(type);
        if (className == null) {
            throw new RuntimeException(String.format("\u627e\u4e0d\u5230%s\u5bf9\u5e94\u7684\u5904\u7406\u5668", type));
        }
        return (CUIHandler)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put(CUIEnum.SingleSelectCard.getCode(), "kd.aimp.cmapp.sdk.cui.clarify.handler.SingleCUIHandler");
        serviceMap.put(CUIEnum.MultiSelectCard.getCode(), "kd.aimp.cmapp.sdk.cui.clarify.handler.MultiCUIHandler");
        serviceMap.put(CUIEnum.RiskCard.getCode(), "kd.aimp.cmapp.sdk.cui.risk.RiskCardCUIHandler");
        serviceMap.put(CUIEnum.AnalyzeCard.getCode(), "kd.aimp.cmapp.sdk.cui.analyse.handler.AnalyseCUIHandler");
        serviceMap.put(CUIEnum.RankCard.getCode(), "kd.aimp.cmapp.sdk.cui.rank.handler.RankHandler");
        serviceMap.put(CUIEnum.OperationCard.getCode(), "kd.aimp.cmapp.sdk.cui.operationBtn.handler.OperationHandler");
        serviceMap.put(CUIEnum.MultiIntentionCard.getCode(), "kd.aimp.cmapp.sdk.cui.multiIntention.handler.MultiIntentionCUIHandler");
        serviceMap.put(CUIEnum.DATA_LIST_CARD.getCode(), "kd.aimp.cmapp.sdk.cui.listcard.ListCardHandler");
        serviceMap.put(CUIEnum.StatusCard.getCode(), "kd.aimp.cmapp.sdk.cui.status.handler.StatusCardCUIHandler");
        serviceMap.put(CUIEnum.IconText.getCode(), "kd.aimp.cmapp.sdk.cui.iconText.handler.IconTextCUIHandler");
        serviceMap.put(CUIEnum.ThinkCARD.getCode(), "kd.aimp.cmapp.sdk.cui.think.handler.ThinkCUIHandler");
        serviceMap.put(CUIEnum.DATA_CARD.getCode(), "kd.aimp.cmapp.sdk.cui.aiquery.handler.QueryCardHandler");
        serviceMap.put(CUIEnum.TASK_CARD.getCode(), "kd.aimp.cmapp.sdk.cui.task.TaskCardHandler");
        serviceMap.put(CUIEnum.DAILY_EXPRESS_CARD.getCode(), "kd.aimp.cmapp.sdk.cui.express.handler.DailyExpressHandler");
        serviceMap.put(CUIEnum.INFORMATION_SUMMARY_CARD.getCode(), "kd.aimp.cmapp.sdk.cui.information.handler.InformationCUIHandler");
    }
}

