/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.aiquery.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.cui.aiquery.dto.QueryCardDTO;
import kd.aimp.cmapp.sdk.cui.aiquery.dto.WarningDTO;
import kd.aimp.cmapp.sdk.cui.aiquery.vo.ProcessBarItemVO;
import kd.aimp.cmapp.sdk.cui.aiquery.vo.QueryCardVO;
import kd.aimp.cmapp.sdk.cui.aiquery.vo.StatCountVO;
import kd.aimp.cmapp.sdk.cui.aiquery.vo.WarningVO;
import kd.aimp.cmapp.sdk.cui.base.dto.CommonCUIVO;
import kd.aimp.cmapp.sdk.cui.base.dto.DataPanelDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.dto.FilterDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.OperationBtnVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.enums.DispatchActionEnum;
import kd.aimp.cmapp.sdk.cui.base.enums.IconTypeEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.base.vo.DataPanelVO;
import kd.aimp.cmapp.sdk.cui.base.vo.FilterCardVO;
import kd.aimp.cmapp.sdk.cui.base.vo.FilterDisplayVO;
import kd.aimp.cmapp.sdk.cui.base.vo.FilterVO;
import kd.aimp.cmapp.sdk.cui.listcard.dto.ListCardItemDTO;
import kd.aimp.cmapp.sdk.cui.listcard.vo.ListCardItemVO;
import kd.aimp.cmapp.sdk.cui.listcard.vo.ListCardVO;
import kd.bos.util.CollectionUtils;

public class QueryCardHandler
extends AbstractCUIHandler<QueryCardDTO, QueryCardVO> {
    private Map<String, Object> commonExtra;

    @Override
    public QueryCardVO buildCard(QueryCardDTO queryCardDTO) {
        this.commonExtra = queryCardDTO.getCommonExtra();
        WarningVO warningVO = this.buildWarningVO(queryCardDTO);
        FilterVO filterVO = this.buildFilterVO(queryCardDTO);
        List<ProcessBarItemVO> processBarItemVOS = this.buildProcessBarVOList(queryCardDTO);
        return QueryCardVO.builder().title(queryCardDTO.getTitle()).alt(queryCardDTO.getAlt()).tip(warningVO).filter(filterVO).des(queryCardDTO.getDesc()).count(StatCountVO.from(queryCardDTO.getCount())).rate(this.convert2DataPanelVO(queryCardDTO.getRate())).percents(processBarItemVOS).echarts(queryCardDTO.getEchartsOption()).build();
    }

    @Override
    public String getType() {
        return CUIEnum.DATA_CARD.getCode();
    }

    private WarningVO buildWarningVO(QueryCardDTO queryCardDTO) {
        if (Objects.isNull(queryCardDTO.getWarning())) {
            return null;
        }
        WarningDTO.WarningIconInfoDTO warningIconInfo = queryCardDTO.getWarning().getWarningIconInfo();
        List<ListCardItemDTO> warningTagInfos = queryCardDTO.getWarning().getWarningTagInfos();
        return WarningVO.builder().src(warningIconInfo.getSrc()).type(warningIconInfo.getType()).number(warningIconInfo.getNumber()).dispatch(this.createDispatchFromWarning(warningTagInfos)).build();
    }

    private FilterVO buildFilterVO(final QueryCardDTO queryCardDTO) {
        FilterDTO filterDto = queryCardDTO.getFilter();
        if (Objects.isNull(filterDto)) {
            return null;
        }
        ArrayList<OperationBtnVO> operationBtnData = new ArrayList<OperationBtnVO>(){
            {
                this.add(OperationBtnVO.builder().btnText("\u53d6\u6d88").type("second").dispatch(Collections.singletonList(DispatchVO.builder().action(DispatchActionEnum.CloseModal.getCode()).payload(new HashMap<String, Object>()).build())).build());
                ArrayList<DispatchVO> primaryDispatch = new ArrayList<DispatchVO>();
                primaryDispatch.add(DispatchVO.builder().action(DispatchActionEnum.CloseModal.getCode()).payload(new HashMap<String, Object>()).build());
                HashMap<String, Object> payload = new HashMap<String, Object>();
                payload.put("extra", QueryCardHandler.this.mergeExtra(queryCardDTO.getFilter().getBtnConfirmExtra(), QueryCardHandler.this.commonExtra));
                primaryDispatch.add(DispatchVO.builder().action(DispatchActionEnum.Refresh.getCode()).payload(payload).build());
                this.add(OperationBtnVO.builder().btnText("\u786e\u8ba4").type("primary").dispatch(primaryDispatch).build());
            }
        };
        ArrayList<DispatchVO> dispatchList = new ArrayList<DispatchVO>();
        dispatchList.add(DispatchVO.builder().action("showModal").payload(FilterDisplayVO.builder().type("Form").title(filterDto.getTitle()).data(FilterCardVO.builder().tabs(filterDto.getTabs()).operations((List<OperationBtnVO>)operationBtnData).build()).build().toMap()).build());
        return FilterVO.builder().iconType(IconTypeEnum.Add.getCode()).dispatch(dispatchList).build();
    }

    private List<ProcessBarItemVO> buildProcessBarVOList(QueryCardDTO queryCardDTO) {
        if (Objects.isNull(queryCardDTO.getPercents())) {
            return null;
        }
        return queryCardDTO.getPercents().stream().map(ProcessBarItemVO::fromDTO).collect(Collectors.toList());
    }

    private List<DispatchVO> createDispatchFromWarning(List<ListCardItemDTO> warningTagInfos) {
        if (CollectionUtils.isEmpty(warningTagInfos)) {
            return new ArrayList<DispatchVO>();
        }
        ListCardVO listCardVO = this.covert2ListCard(warningTagInfos);
        CommonCUIVO commonCUIVO = new CommonCUIVO(CUIEnum.DATA_LIST_CARD.getCode(), Collections.singletonList(listCardVO));
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("slot", Collections.singletonList(commonCUIVO));
        payload.put("title", "\u98ce\u9669\u9884\u8b66");
        DispatchVO dispatchVO = DispatchVO.builder().action("showModal").trigger("onClick").payload(payload).build();
        return Collections.singletonList(dispatchVO);
    }

    private ListCardVO covert2ListCard(List<ListCardItemDTO> warningTagInfos) {
        if (CollectionUtils.isEmpty(warningTagInfos)) {
            return new ListCardVO();
        }
        List<ListCardItemVO> itemVOList = warningTagInfos.stream().map(ListCardItemVO::fromDTO).collect(Collectors.toList());
        return new ListCardVO(itemVOList);
    }

    private List<DataPanelVO> convert2DataPanelVO(List<DataPanelDTO> dataPanelDTOS) {
        if (CollectionUtils.isEmpty(dataPanelDTOS)) {
            return new ArrayList<DataPanelVO>();
        }
        return dataPanelDTOS.stream().map(DataPanelVO::from).collect(Collectors.toList());
    }

    private Map<String, Object> mergeExtra(Map<String, Object> originExtra, Map<String, Object> commonExtra) {
        if (Objects.isNull(originExtra)) {
            return commonExtra;
        }
        if (Objects.isNull(commonExtra)) {
            return null;
        }
        originExtra.putAll(commonExtra);
        return originExtra;
    }
}

