/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.base.convert;

import java.util.ArrayList;
import java.util.List;
import kd.aimp.cmapp.sdk.cui.base.dto.BaseVO;
import kd.aimp.cmapp.sdk.cui.base.dto.CommonCUIVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.think.vo.ThinkVO;
import kd.aimp.cmapp.sdk.util.JacksonUtil;

public class CUIConvert {
    public static String convertToCUIJson(CUIEnum type, BaseVO baseVO, String label) {
        ArrayList<Object> content = new ArrayList<Object>();
        content.add(baseVO);
        CommonCUIVO commonCUIVO = new CommonCUIVO(type.getCode(), content);
        ArrayList<CommonCUIVO> common = new ArrayList<CommonCUIVO>();
        common.add(commonCUIVO);
        return String.format(label, baseVO.getAlt(), baseVO.getDisabledPadding(), JacksonUtil.toJson(common));
    }

    public static String convertToCUIJson(CUIEnum type, BaseVO baseVO, String label, Integer integer, String title) {
        ArrayList<Object> content = new ArrayList<Object>();
        content.add(baseVO);
        CommonCUIVO commonCUIVO = new CommonCUIVO(type.getCode(), content, integer, title);
        ArrayList<CommonCUIVO> common = new ArrayList<CommonCUIVO>();
        common.add(commonCUIVO);
        return String.format(label, baseVO.getAlt(), baseVO.getDisabledPadding(), JacksonUtil.toJson(common));
    }

    public static String convertToCUIJson(CUIEnum type, List<BaseVO> baseVO, String label, Integer integer, String title) {
        BaseVO baseVO1 = baseVO.get(0);
        ArrayList<Object> content = new ArrayList<Object>(baseVO);
        CommonCUIVO commonCUIVO = new CommonCUIVO(type.getCode(), content, integer, title);
        ArrayList<CommonCUIVO> common = new ArrayList<CommonCUIVO>();
        common.add(commonCUIVO);
        return String.format(label, baseVO1.getAlt(), baseVO1.getDisabledPadding(), JacksonUtil.toJson(common));
    }

    public static String convertToCUIJson(CUIEnum type, BaseVO baseVO) {
        return CUIConvert.convertToCUIJson(type, baseVO, "<cosmic-cui alt=\"%s\" disabledPadding=\"%s\">%s</cosmic-cui>");
    }

    public static String convertToThinkCUIJson(ThinkVO thinkVO) {
        return String.format("<cosmic-think id=\"%s\" alt=\"%s\" disabledPadding=\"%s\">%s</cosmic-think>", thinkVO.getId(), thinkVO.getAlt(), thinkVO.getDisabledPadding(), JacksonUtil.toJson(thinkVO));
    }
}

