/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.base.dto;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.Validator;

public class DispatchVO {
    private String action;
    private String trigger;
    private Map<String, Object> payload;
    private Boolean alwaysEnable;
    private List<Validator> validator;

    public DispatchVO() {
    }

    public DispatchVO(String action, String trigger, Map<String, Object> payload, Boolean alwaysEnable, List<Validator> validator) {
        this.action = action;
        this.trigger = trigger;
        this.payload = payload;
        this.alwaysEnable = alwaysEnable;
        this.validator = validator;
    }

    public DispatchVO(String action, String trigger, Map<String, Object> payload, Boolean alwaysEnable) {
        this.action = action;
        this.trigger = trigger;
        this.payload = payload;
        this.alwaysEnable = alwaysEnable;
    }

    public List<Validator> getValidator() {
        return this.validator;
    }

    public void setValidator(List<Validator> validator) {
        this.validator = validator;
    }

    public Boolean getAlwaysEnable() {
        return this.alwaysEnable;
    }

    public void setAlwaysEnable(Boolean alwaysEnable) {
        this.alwaysEnable = alwaysEnable;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public static DispatchVO fromDTO(DispatchDTO dispatchDTO) {
        if (Objects.isNull(dispatchDTO)) {
            return new DispatchVO();
        }
        return DispatchVO.builder().action(dispatchDTO.getAction()).trigger(dispatchDTO.getTrigger()).payload(dispatchDTO.getPayload()).alwaysEnable(dispatchDTO.getAlwaysEnable()).validator(dispatchDTO.getValidator()).build();
    }

    public static DispatchVOBuilder builder() {
        return new DispatchVOBuilder();
    }

    public static class DispatchVOBuilder {
        private String action;
        private String trigger;
        private Map<String, Object> payload;
        private Boolean alwaysEnable;
        private List<Validator> validator;

        DispatchVOBuilder() {
        }

        public DispatchVOBuilder validator(List<Validator> validator) {
            this.validator = validator;
            return this;
        }

        public DispatchVOBuilder alwaysEnable(Boolean alwaysEnable) {
            this.alwaysEnable = alwaysEnable;
            return this;
        }

        public DispatchVOBuilder action(String action) {
            this.action = action;
            return this;
        }

        public DispatchVOBuilder trigger(String trigger) {
            this.trigger = trigger;
            return this;
        }

        public DispatchVOBuilder payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public DispatchVO build() {
            return new DispatchVO(this.action, this.trigger, this.payload, this.alwaysEnable, this.validator);
        }

        public String toString() {
            return "DispatchVO.DispatchVOBuilder(action=" + this.action + ", trigger=" + this.trigger + ", payload=" + this.payload + ")";
        }
    }
}

