/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.clarify.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.dto.OperationBtnVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.clarify.dto.ButtonDTO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.MultiSelectCardDTO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.MultiSelectCardVO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.ShowAllBtnVO;

public class MultiCUIHandler
extends AbstractCUIHandler<MultiSelectCardDTO, MultiSelectCardVO> {
    @Override
    public MultiSelectCardVO buildCard(MultiSelectCardDTO cardData) {
        if (cardData == null) {
            return null;
        }
        MultiSelectCardVO result = this.buildDefault(cardData);
        MultiSelectCardVO multiSelectCardData = this.buildIndividuation(result, cardData);
        return multiSelectCardData;
    }

    private MultiSelectCardVO buildIndividuation(MultiSelectCardVO result, MultiSelectCardDTO cardData) {
        List<ButtonDTO> operationBtn;
        Integer rowType = cardData.getRowType();
        if (rowType != null) {
            result.setRow(rowType);
        }
        ArrayList<DispatchVO> dispatchVOList = new ArrayList<DispatchVO>();
        List<DispatchDTO> dispatch = cardData.getDispatch();
        if (dispatch != null) {
            dispatch.forEach(d -> dispatchVOList.add(DispatchVO.builder().action(d.getAction()).alwaysEnable(d.getAlwaysEnable()).payload(d.getPayload()).trigger(d.getTrigger()).build()));
        }
        result.setDispatch(dispatchVOList);
        ButtonDTO showDataBtn = cardData.getShowDataBtn();
        if (showDataBtn != null) {
            ShowAllBtnVO showAll = result.getShowAll();
            showAll.setBtnText(showDataBtn.getBtnText());
            DispatchVO btnAction = new DispatchVO();
            btnAction.setAction(showDataBtn.getBtnAction());
            JSONObject payload = new JSONObject();
            payload.put("type", (Object)showDataBtn.getBtnPayload());
            btnAction.setPayload((Map<String, Object>)payload);
            showAll.getDispatch().set(0, btnAction);
        }
        if ((operationBtn = cardData.getOperationBtn()) != null) {
            ArrayList<OperationBtnVO> operationList = new ArrayList<OperationBtnVO>(operationBtn.size());
            for (ButtonDTO buttonDto : operationBtn) {
                OperationBtnVO operation = new OperationBtnVO();
                operation.setBtnText(buttonDto.getBtnText());
                operation.setType(buttonDto.getBtnType());
                ArrayList<DispatchVO> dispatchDataList = new ArrayList<DispatchVO>();
                DispatchVO dispatchData = new DispatchVO();
                dispatchData.setAction(buttonDto.getBtnAction());
                if (buttonDto.getBtnType().equals("primary")) {
                    dispatchData.setPayload(cardData.getExtra());
                }
                dispatchDataList.add(dispatchData);
                operation.setDispatch(dispatchDataList);
                operationList.add(operation);
            }
            result.setOperations(operationList);
        }
        return result;
    }

    private MultiSelectCardVO buildDefault(final MultiSelectCardDTO cardData) {
        MultiSelectCardVO result = new MultiSelectCardVO();
        result.setTitle(cardData.getTitle());
        result.setField(cardData.getField());
        result.setAlt(cardData.getAlt());
        result.setLabel(cardData.getFieldName());
        result.setData(cardData.getRowData());
        ShowAllBtnVO showAllBtnVO = new ShowAllBtnVO();
        showAllBtnVO.setBtnText("\u67e5\u770b\u5168\u90e8");
        ArrayList<DispatchVO> dispatchDataList = new ArrayList<DispatchVO>(){
            {
                DispatchVO btnAction = new DispatchVO();
                btnAction.setAction("showModal");
                JSONObject payload = new JSONObject();
                payload.put("type", (Object)"MutiSelect");
                btnAction.setPayload((Map<String, Object>)payload);
                this.add(btnAction);
                DispatchVO btnRequest = new DispatchVO();
                btnRequest.setAction("request");
                btnRequest.setPayload((Map<String, Object>)JSONObject.parseObject((String)JSONObject.toJSONString((Object)cardData.getShowDataRequest())));
                this.add(btnRequest);
            }
        };
        showAllBtnVO.setDispatch((List<DispatchVO>)dispatchDataList);
        result.setShowAll(showAllBtnVO);
        ArrayList<OperationBtnVO> operationBtnData = new ArrayList<OperationBtnVO>(){
            {
                OperationBtnVO primaryBtn = new OperationBtnVO();
                primaryBtn.setBtnText("\u786e\u8ba4");
                primaryBtn.setType("primary");
                ArrayList<DispatchVO> primaryDispatchList = new ArrayList<DispatchVO>();
                DispatchVO primaryDispatch = new DispatchVO();
                primaryDispatch.setAction("submit");
                primaryDispatch.setPayload(cardData.getExtra());
                primaryDispatchList.add(primaryDispatch);
                primaryBtn.setDispatch(primaryDispatchList);
                this.add(primaryBtn);
                OperationBtnVO secondBtn = new OperationBtnVO();
                secondBtn.setBtnText("\u53d6\u6d88");
                secondBtn.setType("second");
                ArrayList<DispatchVO> secondDispatchList = new ArrayList<DispatchVO>();
                DispatchVO secondDispatch = new DispatchVO();
                secondDispatch.setAction("closeModal");
                secondDispatchList.add(secondDispatch);
                secondBtn.setDispatch(secondDispatchList);
                this.add(secondBtn);
            }
        };
        result.setOperations((List<OperationBtnVO>)operationBtnData);
        return result;
    }

    @Override
    public String getType() {
        return CUIEnum.MultiSelectCard.getCode();
    }
}

