/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.clarify.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.dto.RequestDTO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.clarify.dto.ButtonDTO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.SelectCardDTO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.SelectCardVO;
import kd.aimp.cmapp.sdk.cui.clarify.dto.ShowAllBtnVO;

public class SingleCUIHandler
extends AbstractCUIHandler<SelectCardDTO, SelectCardVO> {
    @Override
    public SelectCardVO buildCard(SelectCardDTO cardData) {
        if (cardData == null) {
            return null;
        }
        SelectCardVO result = this.buildDefault(cardData);
        SelectCardVO selectCardVO = this.buildIndividuation(result, cardData);
        return selectCardVO;
    }

    private SelectCardVO buildIndividuation(SelectCardVO result, SelectCardDTO cardData) {
        Integer rowType = cardData.getRowType();
        if (rowType != null) {
            result.setRow(rowType);
        }
        ArrayList<DispatchVO> dispatchVOList = new ArrayList<DispatchVO>();
        List<DispatchDTO> dispatch = cardData.getDispatch();
        if (dispatch != null) {
            dispatch.forEach(d -> dispatchVOList.add(DispatchVO.builder().alwaysEnable(d.getAlwaysEnable()).action(d.getAction()).payload(d.getPayload()).trigger(d.getTrigger()).build()));
        }
        result.setDispatch(dispatchVOList);
        ButtonDTO showDataBtn = cardData.getShowDataBtn();
        if (showDataBtn != null) {
            Map<String, Object> btnPayloadExtra;
            ShowAllBtnVO showAll = result.getShowAll();
            String btnText = showDataBtn.getBtnText();
            if (btnText != null) {
                showAll.setBtnText(btnText);
            }
            DispatchVO btnAction = new DispatchVO();
            String showDataBtnBtnAction = showDataBtn.getBtnAction();
            if (showDataBtnBtnAction != null) {
                btnAction.setAction(showDataBtnBtnAction);
            }
            if ((btnPayloadExtra = showDataBtn.getBtnPayloadExtra()) != null) {
                btnPayloadExtra.put("type", showDataBtn.getBtnPayload());
                btnAction.setPayload(btnPayloadExtra);
            } else {
                HashMap<String, Object> payload = new HashMap<String, Object>();
                payload.put("type", showDataBtn.getBtnPayload());
                btnAction.setPayload(payload);
            }
            showAll.getDispatch().set(0, btnAction);
        }
        return result;
    }

    private SelectCardVO buildDefault(final SelectCardDTO cardData) {
        SelectCardVO result = new SelectCardVO();
        result.setTitle(cardData.getTitle());
        result.setField(cardData.getField());
        result.setAlt(cardData.getAlt());
        result.setLabel(cardData.getFieldName());
        result.setData(cardData.getRowData());
        ShowAllBtnVO showAllBtnVO = new ShowAllBtnVO();
        showAllBtnVO.setBtnText("\u67e5\u770b\u5168\u90e8");
        ArrayList<DispatchVO> dispatchDataList = new ArrayList<DispatchVO>(){
            {
                DispatchVO btnAction = new DispatchVO();
                btnAction.setAction("showModal");
                JSONObject payload = new JSONObject();
                payload.put("type", (Object)"SingleSelect");
                btnAction.setPayload((Map<String, Object>)payload);
                this.add(btnAction);
                RequestDTO showDataRequest = cardData.getShowDataRequest();
                if (showDataRequest != null) {
                    DispatchVO btnRequest = new DispatchVO();
                    btnRequest.setAction("request");
                    btnRequest.setPayload(showDataRequest.toMap());
                    this.add(btnRequest);
                }
            }
        };
        showAllBtnVO.setDispatch((List<DispatchVO>)dispatchDataList);
        result.setShowAll(showAllBtnVO);
        return result;
    }

    @Override
    public String getType() {
        return CUIEnum.SingleSelectCard.getCode();
    }
}

