/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.listcard.vo;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchDTO;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.listcard.dto.ListCardItemDTO;
import kd.bos.util.CollectionUtils;

public class ListCardItemVO {
    private String tagName;
    private String type;
    private String colorType;
    private String text;
    private List<DispatchVO> dispatch;

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getColorType() {
        return this.colorType;
    }

    public void setColorType(String colorType) {
        this.colorType = colorType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<DispatchVO> getDispatch() {
        return this.dispatch;
    }

    public void setDispatch(List<DispatchVO> dispatch) {
        this.dispatch = dispatch;
    }

    public ListCardItemVO() {
    }

    public ListCardItemVO(String tagName, String type, String colorType, String text, List<DispatchVO> dispatch) {
        this.tagName = tagName;
        this.type = type;
        this.colorType = colorType;
        this.text = text;
        this.dispatch = dispatch;
    }

    public String toString() {
        return "WarningTagInfoDTO{tagName='" + this.tagName + '\'' + ", type='" + this.type + '\'' + ", colorType='" + this.colorType + '\'' + ", text='" + this.text + '\'' + ", dispatch='" + this.dispatch + '\'' + '}';
    }

    public static ListCardItemVO fromDTO(ListCardItemDTO itemDTO) {
        if (Objects.isNull(itemDTO)) {
            return new ListCardItemVO();
        }
        List<DispatchDTO> dispatchDTOS = itemDTO.getDispatch();
        List<DispatchVO> dispatchVOS = null;
        if (CollectionUtils.isNotEmpty(dispatchDTOS)) {
            dispatchVOS = dispatchDTOS.stream().map(DispatchVO::fromDTO).collect(Collectors.toList());
        }
        return ListCardItemVO.builder().tagName(itemDTO.getTagName()).type(itemDTO.getType()).colorType(itemDTO.getColorType()).text(itemDTO.getText()).dispatch(dispatchVOS).build();
    }

    public static ItemVOBuilder builder() {
        return new ItemVOBuilder();
    }

    public static class ItemVOBuilder {
        private String tagName;
        private String type;
        private String colorType;
        private String text;
        private List<DispatchVO> dispatch;

        public ItemVOBuilder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public ItemVOBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ItemVOBuilder colorType(String colorType) {
            this.colorType = colorType;
            return this;
        }

        public ItemVOBuilder text(String text) {
            this.text = text;
            return this;
        }

        public ItemVOBuilder dispatch(List<DispatchVO> dispatch) {
            this.dispatch = dispatch;
            return this;
        }

        public ListCardItemVO build() {
            return new ListCardItemVO(this.tagName, this.type, this.colorType, this.text, this.dispatch);
        }
    }
}

