/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.multiIntention.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.dto.OperationBtnVO;
import kd.aimp.cmapp.sdk.cui.base.dto.RequestDTO;
import kd.aimp.cmapp.sdk.cui.base.enums.ButtonTypeEnum;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.clarify.dto.ButtonDTO;
import kd.aimp.cmapp.sdk.cui.multiIntention.dto.FieldDTO;
import kd.aimp.cmapp.sdk.cui.multiIntention.dto.MultiIntentionDTO;
import kd.aimp.cmapp.sdk.cui.multiIntention.vo.FieldVO;
import kd.aimp.cmapp.sdk.cui.multiIntention.vo.MultiIntentionVO;

public class MultiIntentionCUIHandler
extends AbstractCUIHandler<MultiIntentionDTO, MultiIntentionVO> {
    @Override
    public MultiIntentionVO buildCard(MultiIntentionDTO dto) {
        if (dto == null) {
            return null;
        }
        MultiIntentionVO vo = this.buildDefault(dto);
        vo = this.buildIndividuation(vo, dto);
        return vo;
    }

    private MultiIntentionVO buildIndividuation(MultiIntentionVO defaultVO, MultiIntentionDTO dto) {
        Boolean disabled;
        List<ButtonDTO> buttonList = dto.getOperations();
        if (buttonList != null && !buttonList.isEmpty()) {
            ArrayList<OperationBtnVO> operationBtnList = new ArrayList<OperationBtnVO>(buttonList.size());
            buttonList.forEach(b -> operationBtnList.add(OperationBtnVO.builder().btnText(b.getBtnText()).type(b.getBtnType()).dispatch(Collections.singletonList(DispatchVO.builder().action(b.getBtnAction()).trigger(b.getTrigger()).alwaysEnable(b.getAlwaysEnable()).payload(b.getBtnPayloadExtra()).validator(b.getValidator()).build())).build()));
            defaultVO.setOperations(operationBtnList);
        }
        if ((disabled = dto.isDisabled()) != null) {
            defaultVO.setDisabled(disabled);
        }
        return defaultVO;
    }

    private MultiIntentionVO buildDefault(MultiIntentionDTO dto) {
        List<FieldDTO> fieldDTOList = dto.getFields();
        ArrayList<FieldVO> fieldVOS = new ArrayList<FieldVO>(3);
        if (fieldDTOList != null && !fieldDTOList.isEmpty()) {
            fieldDTOList.forEach(field -> {
                RequestDTO request = field.getRequestOptions();
                ArrayList<DispatchVO> dispatchVOList = new ArrayList<DispatchVO>(1);
                if (request != null) {
                    dispatchVOList.add(DispatchVO.builder().action("request").trigger("onClick").payload(request.toMap()).build());
                }
                fieldVOS.add(FieldVO.builder().field(field.getField()).tag(field.getTag()).placeholder(field.getPlaceholder()).type(field.getType()).options(field.getOptions()).value(field.getValue()).valueText(field.getValueText()).dispatch(dispatchVOList).build());
            });
        }
        ArrayList<OperationBtnVO> operationBtnList = new ArrayList<OperationBtnVO>();
        operationBtnList.add(OperationBtnVO.builder().btnText("\u8df3\u8fc7").type(ButtonTypeEnum.Second.getCode()).dispatch(Collections.singletonList(DispatchVO.builder().payload(new HashMap<String, Object>()).trigger("onClick").action("").build())).build());
        operationBtnList.add(OperationBtnVO.builder().btnText("\u786e\u8ba4").type(ButtonTypeEnum.Primary.getCode()).dispatch(Collections.singletonList(DispatchVO.builder().payload(new HashMap<String, Object>()).action("").build())).build());
        return MultiIntentionVO.builder().title(dto.getTitle()).alt(dto.getAlt()).disabled(false).fields(fieldVOS).operations(operationBtnList).build();
    }

    @Override
    public String getType() {
        return CUIEnum.MultiIntentionCard.getCode();
    }
}

