/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.rank.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.aimp.cmapp.sdk.cui.base.dto.CommonCUIVO;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.rank.dto.RankDTO;
import kd.aimp.cmapp.sdk.cui.rank.dto.RankLabelDTO;
import kd.aimp.cmapp.sdk.cui.rank.vo.RankLabelVO;
import kd.aimp.cmapp.sdk.cui.rank.vo.RankVO;
import kd.aimp.cmapp.sdk.cui.status.dto.StatusCardDTO;
import kd.aimp.cmapp.sdk.cui.status.handler.StatusCardCUIHandler;

public class RankHandler
extends AbstractCUIHandler<RankDTO, RankVO> {
    @Override
    public RankVO buildCard(RankDTO rankDTO) {
        List<RankLabelDTO> data = rankDTO.getData();
        ArrayList<RankLabelVO> rankVoList = new ArrayList<RankLabelVO>(2);
        StatusCardCUIHandler statusHandler = new StatusCardCUIHandler();
        for (RankLabelDTO label : data) {
            ArrayList<CommonCUIVO> commonCUIList = new ArrayList<CommonCUIVO>(2);
            List<StatusCardDTO> slot = label.getSlot();
            if (slot != null && !slot.isEmpty()) {
                slot.forEach(s -> commonCUIList.add(CommonCUIVO.builder().type(CUIEnum.StatusCard.getCode()).content(Collections.singletonList(statusHandler.buildCard((StatusCardDTO)s))).build()));
            }
            rankVoList.add(RankLabelVO.builder().des(label.getDes()).list(label.getList()).color(label.getColor()).slot(commonCUIList).build());
        }
        return RankVO.builder().title(rankDTO.getTitle()).alt(rankDTO.getAlt()).dropdown(rankDTO.getDropdown()).tabs(rankDTO.getTabs()).tabsValue(rankDTO.getTabsValue()).dispatch(new ArrayList<DispatchVO>()).dropdownValue(rankDTO.getDropdownValue()).data(rankVoList).build();
    }

    @Override
    public String getType() {
        return CUIEnum.RankCard.getCode();
    }
}

