/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.risk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.aimp.cmapp.sdk.cui.base.dto.DispatchVO;
import kd.aimp.cmapp.sdk.cui.base.dto.OperationBtnVO;
import kd.aimp.cmapp.sdk.cui.base.enums.CUIEnum;
import kd.aimp.cmapp.sdk.cui.base.handler.AbstractCUIHandler;
import kd.aimp.cmapp.sdk.cui.risk.dto.RiskCardBtnDTO;
import kd.aimp.cmapp.sdk.cui.risk.dto.RiskCardDTO;
import kd.aimp.cmapp.sdk.cui.risk.dto.RiskCardDataDTO;
import kd.aimp.cmapp.sdk.cui.risk.dto.RiskCardNoRiskTipDTO;
import kd.aimp.cmapp.sdk.cui.risk.dto.RiskCardSummaryDTO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardBodyVO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardHeaderVO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardNoRiskTipVO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardRiskDataVO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardSummaryVO;
import kd.aimp.cmapp.sdk.cui.risk.vo.RiskCardVO;

public class RiskCardCUIHandler
extends AbstractCUIHandler<RiskCardDTO, RiskCardVO> {
    @Override
    public RiskCardVO buildCard(RiskCardDTO riskCardDto) {
        if (riskCardDto != null) {
            return this.castToVo(riskCardDto);
        }
        return null;
    }

    @Override
    public String getType() {
        return CUIEnum.RiskCard.getCode();
    }

    private RiskCardVO castToVo(RiskCardDTO dto) {
        RiskCardHeaderVO header = RiskCardHeaderVO.builder().title(dto.getTitle()).time(dto.getTime()).imgUrl(dto.getImgUrl()).gradientColor(dto.getGradientColor()).build();
        RiskCardSummaryDTO summaryDto = dto.getSummary();
        RiskCardSummaryVO summary = RiskCardSummaryVO.builder().totalDescription(RiskCardSummaryVO.totalDescVo.builder().total(summaryDto.getTotal()).desc(summaryDto.getDesc()).build()).additionalInfo(summaryDto.getAdditionalInfo()).build();
        RiskCardBodyVO body = RiskCardBodyVO.builder().summary(summary).build();
        List<RiskCardDataDTO> riskDtos = dto.getRisks();
        if (riskDtos != null && riskDtos.size() > 0) {
            ArrayList<RiskCardRiskDataVO> risks = new ArrayList<RiskCardRiskDataVO>();
            riskDtos.forEach(riskDto -> risks.add(RiskCardRiskDataVO.builder().text(riskDto.getText()).type(riskDto.getType()).colorType(riskDto.getColorType()).description(riskDto.getDescription()).build()));
            body.setRisks(risks);
        } else {
            RiskCardNoRiskTipDTO noRiskTipDTO = dto.getNoRiskTip();
            RiskCardNoRiskTipVO riskCardNoRiskTipVO = RiskCardNoRiskTipVO.builder().imgUrl(noRiskTipDTO.getImgUrl()).title(noRiskTipDTO.getTitle()).description(noRiskTipDTO.getDescription()).build();
            body.setNoRiskTip(riskCardNoRiskTipVO);
        }
        RiskCardBtnDTO btnDto = dto.getBtn();
        DispatchVO dispatchVO = new DispatchVO();
        dispatchVO.setAction("openLink");
        dispatchVO.setTrigger("onClick");
        HashMap<String, Object> payLoad = new HashMap<String, Object>();
        payLoad.put("url", btnDto.getPayload());
        dispatchVO.setPayload(payLoad);
        ArrayList<DispatchVO> dispatchVOS = new ArrayList<DispatchVO>();
        dispatchVOS.add(dispatchVO);
        OperationBtnVO btnVO = new OperationBtnVO();
        btnVO.setBtnText(btnDto.getText());
        btnVO.setDispatch(dispatchVOS);
        ArrayList<OperationBtnVO> footer = new ArrayList<OperationBtnVO>();
        footer.add(btnVO);
        return RiskCardVO.builder().disabledPadding(dto.getDisabledPadding()).header(header).body(body).footer(footer).build();
    }
}

