/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.cui.task.vo;

import java.util.Objects;
import kd.aimp.cmapp.sdk.cui.task.dto.TaskItemDTO;

public class TaskItemVO {
    private String text;
    private boolean require;
    private String value;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isRequire() {
        return this.require;
    }

    public void setRequire(boolean require) {
        this.require = require;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TaskItemVO() {
    }

    public TaskItemVO(String text, boolean require, String value) {
        this.text = text;
        this.require = require;
        this.value = value;
    }

    public String toString() {
        return "TaskItemVO{text='" + this.text + '\'' + ", require=" + this.require + ", value='" + this.value + '\'' + '}';
    }

    public static TaskItemVOBuilder builder() {
        return new TaskItemVOBuilder();
    }

    public static TaskItemVO from(TaskItemDTO taskItemDTO) {
        if (Objects.isNull(taskItemDTO)) {
            return null;
        }
        return TaskItemVO.builder().text(taskItemDTO.getText()).require(taskItemDTO.isRequire()).value(taskItemDTO.getValue()).build();
    }

    public static class TaskItemVOBuilder {
        private String text;
        private boolean require;
        private String value;

        public TaskItemVOBuilder text(String text) {
            this.text = text;
            return this;
        }

        public TaskItemVOBuilder require(boolean require) {
            this.require = require;
            return this;
        }

        public TaskItemVOBuilder value(String value) {
            this.value = value;
            return this;
        }

        public TaskItemVO build() {
            return new TaskItemVO(this.text, this.require, this.value);
        }
    }
}

