/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.ext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class CosmicCommonUtils {
    public static String query(String key) {
        QFilter qFilter = new QFilter("name", "=", (Object)key);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"gai_n2a_param_config", (String)"name,value,value_tag", (QFilter[])new QFilter[]{qFilter});
        if (configs.length > 0) {
            String value = configs[0].getString("value");
            String valueTag = configs[0].getString("value_tag");
            return StringUtils.isNotEmpty((String)valueTag) ? valueTag : value;
        }
        return "";
    }

    public static Map<String, String> queryFieldDesc(Set<String> keys) {
        JSONObject textJo = new JSONObject();
        for (String key : keys) {
            String businessStr = CosmicCommonUtils.query(key);
            textJo.put(key, JSONArray.parse((String)businessStr));
        }
        String text = textJo.toJSONString();
        Map resultMap = (Map)JSON.parseObject((String)text, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
        HashMap<String, String> maps = new HashMap<String, String>(16);
        for (Map.Entry entry : resultMap.entrySet()) {
            for (Map subscrib : (List)entry.getValue()) {
                String name = String.valueOf(subscrib.get("name"));
                String desc = String.valueOf(subscrib.get("desc"));
                name = (String)entry.getKey() + "." + name;
                String type = String.valueOf(subscrib.get("type"));
                boolean numberic = "DECIMAL".equalsIgnoreCase(type);
                maps.put(name, desc + ":" + numberic);
            }
        }
        return maps;
    }

    public static String getDiv() {
        String div = CosmicCommonUtils.query("card.numberValue.fixed");
        if (StringUtils.isEmpty((String)div)) {
            div = "1";
        }
        return div;
    }

    public static List<String> getPercentEndswith() {
        String percentEndswith = CosmicCommonUtils.query("card.numberValue.percentEndswith");
        if (StringUtils.isEmpty((String)percentEndswith)) {
            return Arrays.asList("\u7387,\u6bd4".split(","));
        }
        return Arrays.asList(percentEndswith.split(","));
    }

    public static boolean isPercentField(String fieldName, List<String> percentEndswith) {
        for (String s : percentEndswith) {
            if (!fieldName.endsWith(s)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String divide(String val, String div) {
        if (CosmicCommonUtils.isDecimal(val)) {
            return String.valueOf(new BigDecimal(val).divide(new BigDecimal(div), 3, RoundingMode.HALF_UP));
        }
        return "";
    }

    public static String numberFormat(String div) {
        if ("100".equals(div)) {
            return "{0}#,##0\u767e";
        }
        if ("10000".equals(div)) {
            return "{0}#,##0\u4e07";
        }
        return "{0}#,##0\u5343";
    }

    public static boolean isDecimal(String str) {
        try {
            if ("null".equals(str) || StringUtils.isEmpty((String)str)) {
                return false;
            }
            new BigDecimal(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

