/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.ext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.aimp.cmapp.sdk.ext.CosmicCommonUtils;
import kd.aimp.cmapp.sdk.ext.CosmicSingle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CosmicComposite {
    private static final Log logger = LogFactory.getLog(CosmicSingle.class);
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final int INIT_CAP = 16;

    public static List<Object> panelProcessTemplate(String textStr, List<Map<String, Object>> modelValues) {
        HashMap<String, Object> maps = new HashMap<String, Object>(16);
        for (Map<String, Object> map : modelValues) {
            maps.putAll(map);
        }
        JSONObject jsonObject = JSONObject.parseObject((String)textStr);
        JSONArray dataArray = jsonObject.getJSONArray("data");
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        String div = CosmicCommonUtils.getDiv();
        ArrayList<Object> dataModel = new ArrayList<Object>(16);
        for (int i = 0; i < dataArray.size(); ++i) {
            JSONObject itemObj = dataArray.getJSONObject(i);
            JSONObject mainObject = itemObj.getJSONObject("main");
            JSONObject subObject = itemObj.getJSONObject("sub");
            HashMap<String, Object> item = new HashMap<String, Object>(16);
            for (String mainKey : mainObject.keySet()) {
                String val;
                if (mainKey.equals(NUMBER_FORMAT)) {
                    item.put(NUMBER_FORMAT, mainObject.get((Object)mainKey));
                    continue;
                }
                item.put("title", mainObject.get((Object)mainKey));
                Iterator<Object> valObj = maps.get(mainKey);
                String string = val = valObj == null ? "" : String.valueOf(valObj);
                if (CosmicCommonUtils.isDecimal(val)) {
                    val = new BigDecimal(val).toPlainString();
                }
                item.put("value", val);
            }
            ArrayList subList = new ArrayList(16);
            if (!subObject.isEmpty()) {
                HashMap<String, Object> subItem = new HashMap<String, Object>(16);
                for (String subKey : subObject.keySet()) {
                    String val;
                    if (subKey.equals(NUMBER_FORMAT)) {
                        subItem.put(NUMBER_FORMAT, subObject.get((Object)subKey));
                        continue;
                    }
                    subItem.put("title", subObject.get((Object)subKey));
                    Object valObj = maps.get(subKey);
                    String string = val = valObj == null ? "" : String.valueOf(valObj);
                    if (CosmicCommonUtils.isDecimal(val)) {
                        val = new BigDecimal(val).toPlainString();
                    }
                    subItem.put("value", val);
                }
                subList.add(subItem);
            }
            item.put("sub", subList);
            String template = "{\"title\": \"{{title}}\",\"value\":\"{{value}}\",\"numberFormat\":\"{{numberFormat}}\",\"sub\":[{{#sub}}{\"title\": \"{{title}}\",\"numberFormat\":\"{{numberFormat}}\",\"value\": \"{{value}}\"}{{/sub}}]}";
            Mustache mustache = mf.compile((Reader)new StringReader(template), "panelTemplate");
            try (StringWriter writer = new StringWriter();){
                mustache.execute((Writer)writer, item).flush();
                dataModel.add(JSONObject.parse((String)writer.toString()));
                continue;
            }
            catch (IOException e) {
                logger.error("Exception:{}", (Object)e.getMessage());
                return null;
            }
        }
        return dataModel;
    }

    public static Map<String, Object> indicatorProcess(String text, List<Map<String, Object>> modelValues) {
        JSONObject jsonObject = JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject main = jsonObject.getJSONObject("main");
        JSONArray subArray = jsonObject.getJSONArray("sub");
        String mainKey = (String)main.keySet().iterator().next();
        try {
            for (Map<String, Object> model : modelValues) {
                String rateKey;
                if (model.get(mainKey) == null) continue;
                HashMap<String, Object> dataModel = new HashMap<String, Object>(16);
                dataModel.put("title", main.get((Object)mainKey));
                String val = String.valueOf(model.get(mainKey));
                String div = CosmicCommonUtils.getDiv();
                val = CosmicCommonUtils.divide(val, div);
                dataModel.put(NUMBER_FORMAT, CosmicCommonUtils.numberFormat(div));
                dataModel.put("value", val);
                HashMap<String, String> rate = new HashMap<String, String>(16);
                JSONObject rateJson = jsonObject.getJSONObject("rate");
                if (rateJson != null && (model.get(rateKey = (String)rateJson.keySet().iterator().next()) != null || String.valueOf(model.get(rateKey)).length() > 0)) {
                    String value = String.valueOf(model.get(rateKey));
                    if (!value.contains("%")) {
                        value = String.format("%s%s", new BigDecimal(value).multiply(BigDecimal.valueOf(100L)), "%");
                    }
                    rate.put("value", value);
                    rate.put("baseValue", "100%");
                    rate.put(NUMBER_FORMAT, "{0}0.0%");
                    dataModel.put("rate", rate);
                }
                ArrayList subItems = new ArrayList(16);
                for (int i = 0; i < subArray.size(); ++i) {
                    JSONObject sub = subArray.getJSONObject(i);
                    HashMap<String, String> subItem = new HashMap<String, String>(16);
                    for (String subKey : sub.keySet()) {
                        String valObj;
                        if (subKey.equals(NUMBER_FORMAT)) {
                            subItem.put(NUMBER_FORMAT, sub.getString(subKey));
                            continue;
                        }
                        subItem.put("title", sub.getString(subKey));
                        String string = valObj = model.get(subKey) == null ? "" : String.valueOf(model.get(subKey));
                        if (CosmicCommonUtils.isDecimal(valObj)) {
                            valObj = new BigDecimal(valObj).toPlainString();
                        }
                        subItem.put("value", valObj);
                        subItems.add(subItem);
                    }
                }
                dataModel.put("sub", subItems);
                logger.info("dataModel:{}", (Object)((Object)dataModel).toString());
                return dataModel;
            }
        }
        catch (Exception e) {
            logger.error("Exception:{}", (Object)e.getMessage());
        }
        return null;
    }

    public static String textBoardProcessTemplate(String text, Map<String, Object> modelValues) {
        String template = "{\"title\":\"{{title}}\",\"mobile\":\"{{mobile}}\",\"content\":\"{{content}}\",\"info\":\"{{info}}\",\"sub\":[{{#sub}}{\"title\":\"{{title}}\",\"content\":\"{{content}}\"}{{/sub}}]}";
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(template), "textboard");
        try {
            JSONObject jsonObject = JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
            HashMap<String, Object> rootModel = new HashMap<String, Object>(16);
            rootModel.put("title", modelValues.get(jsonObject.getString("title")));
            rootModel.put("mobile", "");
            rootModel.put("info", "");
            String content = jsonObject.getString("content");
            String[] contents = content.split(",");
            ArrayList<String> list = new ArrayList<String>(16);
            for (String con : contents) {
                if (modelValues.get(con) == null || String.valueOf(modelValues.get(con)).length() <= 0) continue;
                list.add(String.valueOf(modelValues.get(con)));
            }
            String target = String.join((CharSequence)"\u00b7", list);
            rootModel.put("content", target);
            JSONArray sub = jsonObject.getJSONArray("sub");
            ArrayList subList = new ArrayList(16);
            for (int i = 0; i < sub.size(); ++i) {
                JSONObject subObj = sub.getJSONObject(i);
                HashMap<String, String> subMap = new HashMap<String, String>(16);
                for (String key : subObj.keySet()) {
                    String subKeyVal = subObj.getString(key);
                    if (subKeyVal == null || subKeyVal.length() <= 0 || modelValues.get(key) == null || String.valueOf(modelValues.get(key)).length() <= 0) continue;
                    subMap.put("title", subKeyVal);
                    subMap.put("content", String.valueOf(modelValues.get(key)));
                }
                if (subMap.isEmpty()) continue;
                subList.add(subMap);
            }
            rootModel.put("sub", subList);
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, rootModel).flush();
            return writer.toString();
        }
        catch (Exception e) {
            logger.error("Exeception:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> textBoardProcess(String text, Map<String, Object> modelValues) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)text, (Feature[])new Feature[]{Feature.OrderedField});
            HashMap<String, Object> rootModel = new HashMap<String, Object>(16);
            rootModel.put("title", modelValues.get(jsonObject.getString("title")));
            rootModel.put("mobile", "");
            rootModel.put("info", "");
            String content = jsonObject.getString("content");
            String tag = jsonObject.getString("tag");
            if (content != null && content.length() > 0) {
                String[] contents = content.split(",");
                ArrayList<String> list = new ArrayList<String>(16);
                for (String con : contents) {
                    if (modelValues.get(con) == null || String.valueOf(modelValues.get(con)).length() <= 0) continue;
                    list.add(String.valueOf(modelValues.get(con)));
                }
                String target = String.join((CharSequence)"\u00b7", list);
                rootModel.put("content", target);
            }
            JSONArray sub = jsonObject.getJSONArray("sub");
            ArrayList subList = new ArrayList(16);
            for (int i = 0; i < sub.size(); ++i) {
                JSONObject subObj = sub.getJSONObject(i);
                HashMap<String, String> subMap = new HashMap<String, String>(16);
                for (String key : subObj.keySet()) {
                    String subKeyVal = subObj.getString(key);
                    if (subKeyVal == null || subKeyVal.length() <= 0 || modelValues.get(key) == null || String.valueOf(modelValues.get(key)).length() <= 0) continue;
                    subMap.put("title", subKeyVal);
                    subMap.put("content", String.valueOf(modelValues.get(key)));
                }
                if (subMap.isEmpty()) continue;
                subList.add(subMap);
            }
            rootModel.put("sub", subList);
            ArrayList tagList = new ArrayList(16);
            if (modelValues.get(tag) != null && String.valueOf(modelValues.get(tag)).length() > 0 && !"null".equals(modelValues.get(tag))) {
                String[] tags;
                String tagInfo = String.valueOf(modelValues.get(tag));
                String splitTag = CosmicCommonUtils.query("splitTag");
                if (splitTag.isEmpty()) {
                    splitTag = ",";
                }
                for (String tagStr : tags = tagInfo.split(splitTag)) {
                    HashMap<String, String> tagsMap = new HashMap<String, String>();
                    tagsMap.put("name", tagStr);
                    tagList.add(tagsMap);
                }
            }
            rootModel.put("tag", tagList);
            return rootModel;
        }
        catch (Exception e) {
            logger.error("Exeception:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static String listBoardProcessTemplate(String title, String total, String textStr, List<Map<String, Object>> modelValues) {
        try {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            ArrayList<Map<String, Object>> subData = new ArrayList<Map<String, Object>>(16);
            JSONObject jsonObject = JSONObject.parseObject((String)textStr, (Feature[])new Feature[]{Feature.OrderedField});
            String numberFormat = jsonObject.getString(NUMBER_FORMAT);
            String parse = jsonObject.getString("parse");
            if (parse.equals("true")) {
                Map<String, Object> maps = modelValues.get(0);
                JSONObject sub = jsonObject.getJSONObject("sub");
                for (String subKey : sub.keySet()) {
                    if (subKey == null) continue;
                    subData.add(CosmicComposite.createItem(sub.get((Object)subKey), maps.get(subKey), numberFormat));
                }
                dataMap.put("sub", subData);
            } else {
                JSONArray sub = jsonObject.getJSONArray("sub");
                for (Map<String, Object> maps : modelValues) {
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    for (int i = 0; i < sub.size(); ++i) {
                        temp.put(sub.getString(i), maps.get(sub.getString(i)));
                    }
                    temp.put(NUMBER_FORMAT, numberFormat);
                    subData.add(temp);
                }
                dataMap.put("sub", subData);
            }
            dataMap.put("title", title);
            JSONObject json = new JSONObject(dataMap);
            return json.toJSONString();
        }
        catch (Exception e) {
            logger.error("Exeception:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> listBoardProcess(String title, String total, String textStr, List<Map<String, Object>> modelValues) {
        try {
            HashMap<String, Object> rootModle = new HashMap<String, Object>(16);
            ArrayList listData = new ArrayList(16);
            JSONObject jsonObject = JSONObject.parseObject((String)textStr, (Feature[])new Feature[]{Feature.OrderedField});
            String numberFormat = jsonObject.getString(NUMBER_FORMAT);
            String parse = jsonObject.getString("parse");
            String tag = jsonObject.getString("tag");
            String url = jsonObject.getString("url");
            if (parse.equals("true")) {
                for (Map<String, Object> model : modelValues) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                    JSONArray listTag = jsonObject.getJSONArray("list");
                    ArrayList listSub = new ArrayList(16);
                    if (listTag == null) continue;
                    for (int i = 0; i < listTag.size(); ++i) {
                        JSONObject subObj = listTag.getJSONObject(i);
                        HashMap<String, String> subMap = new HashMap<String, String>(16);
                        for (String key : subObj.keySet()) {
                            String subKeyVal = subObj.getString(key);
                            if (subKeyVal == null || subKeyVal.length() <= 0 || model.get(key) == null || String.valueOf(model.get(key)).length() <= 0) continue;
                            subMap.put("title", subKeyVal);
                            subMap.put("content", String.valueOf(model.get(key)));
                        }
                        if (subMap.isEmpty()) continue;
                        listSub.add(subMap);
                    }
                    String content = jsonObject.getString("content");
                    if (content != null && content.length() > 0) {
                        String[] contents = content.split(",");
                        ArrayList<String> list = new ArrayList<String>(16);
                        for (String con : contents) {
                            if (model.get(con) == null || String.valueOf(model.get(con)).length() <= 0) continue;
                            list.add(String.valueOf(model.get(con)));
                        }
                        String target = String.join((CharSequence)"\u00b7", list);
                        dataMap.put("content", target);
                    }
                    if (model.get(tag) != null && String.valueOf(model.get(tag)).length() > 0 && !"null".equals(model.get(tag))) {
                        String[] tags;
                        String tagInfo = String.valueOf(model.get(tag));
                        String splitTag = CosmicCommonUtils.query("splitTag");
                        if (splitTag.isEmpty()) {
                            splitTag = ",";
                        }
                        ArrayList tagList = new ArrayList(16);
                        for (String tagStr : tags = tagInfo.split(splitTag)) {
                            HashMap<String, String> tagsMap = new HashMap<String, String>();
                            tagsMap.put("name", tagStr);
                            tagList.add(tagsMap);
                        }
                        dataMap.put("tag", tagList);
                    }
                    dataMap.put("title", model.get(jsonObject.getString("title")));
                    dataMap.put("url", model.get(url));
                    dataMap.put("sub", listSub);
                    listData.add(dataMap);
                }
                ArrayList<Map<String, Object>> subList = new ArrayList<Map<String, Object>>(16);
                Map<String, Object> maps = modelValues.get(0);
                JSONObject sub = jsonObject.getJSONObject("sub");
                if (sub != null) {
                    for (String subKey : sub.keySet()) {
                        if (subKey == null) continue;
                        if ("total".equals(subKey)) {
                            maps.put(subKey, total);
                        }
                        subList.add(CosmicComposite.createItem(sub.get((Object)subKey), maps.get(subKey), numberFormat));
                    }
                }
                rootModle.put("sub", subList);
            }
            rootModle.put("list", listData);
            rootModle.put("title", title);
            return rootModle;
        }
        catch (Exception e) {
            logger.error("Exeception:{}", (Object)e.getMessage());
            return null;
        }
    }

    private static Map<String, Object> createItem(Object title, Object content, Object numberFormat) {
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        item.put("title", title);
        item.put("content", content);
        item.put(NUMBER_FORMAT, numberFormat);
        return item;
    }

    private static Map<String, String> createTagItem(String name) {
        HashMap<String, String> tagItem = new HashMap<String, String>(16);
        tagItem.put("name", name);
        return tagItem;
    }
}

