/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.ext;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.aimp.cmapp.sdk.ext.CosmicCommonUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CosmicSingle {
    private static final int INIT_CAP = 16;
    private static final Log logger = LogFactory.getLog(CosmicSingle.class);

    private static Map<String, Object> createFieldMap(String field, String fieldName, boolean numerical) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>(16);
        fieldMap.put("field", field);
        fieldMap.put("fieldName", fieldName);
        fieldMap.put("numerical", numerical);
        return fieldMap;
    }

    public static String single(Set<String> keys, String title, String tableType, List<Map<String, Object>> modelValues) {
        Map<String, Object> value = modelValues.get(0);
        JSONObject data = new JSONObject();
        data.put("title", (Object)title);
        data.put("metricName", (Object)"null");
        data.put("metricValue", (Object)"0");
        data.put("numberFormat", (Object)"");
        Map<String, String> maps = CosmicCommonUtils.queryFieldDesc(keys);
        List<String> percentEndswith = CosmicCommonUtils.getPercentEndswith();
        String div = CosmicCommonUtils.getDiv();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String name;
            if (entry.getValue() instanceof String || (name = maps.get(entry.getKey())) == null) continue;
            String[] fieldNames = name.split(":");
            data.put("metricName", (Object)fieldNames[0]);
            String val = String.valueOf(entry.getValue());
            if (CosmicCommonUtils.isPercentField(fieldNames[0], percentEndswith)) {
                BigDecimal decimal = new BigDecimal(val).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                val = String.format("%s", decimal);
                data.put("numberFormat", (Object)"{0}0.0%");
            } else if ("true".equals(fieldNames[1])) {
                val = CosmicCommonUtils.divide(val, div);
                data.put("numberFormat", (Object)CosmicCommonUtils.numberFormat(div));
            }
            data.put("metricValue", (Object)val);
        }
        return JSONObject.toJSONString((Object)data);
    }

    public static String tableProcessTemplate(Set<String> keys, String title, String tableType, List<Map<String, Object>> modelValues, String order, String total) throws IOException {
        if (title == null) {
            title = "";
        }
        List<String> percentEndswith = CosmicCommonUtils.getPercentEndswith();
        String div = CosmicCommonUtils.getDiv();
        Map<String, String> maps = CosmicCommonUtils.queryFieldDesc(keys);
        HashMap<String, Object> dataModel = new HashMap<String, Object>(16);
        dataModel.put("title", title);
        dataModel.put("numberFormat", "{0}#,##0\u5343");
        if (tableType.equalsIgnoreCase("rank")) {
            order = order == null || order.isEmpty() ? "asc" : order;
            total = total == null || total.isEmpty() ? "10" : total;
            dataModel.put("order", order);
            dataModel.put("total", total);
        }
        ArrayList<FieldData> fieldCaches = new ArrayList<FieldData>(16);
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(16);
        ArrayList fieldValues = new ArrayList(16);
        int i = 0;
        for (Map<String, Object> model : modelValues) {
            ArrayList<Object> item = new ArrayList<Object>(16);
            int j = 0;
            for (Map.Entry<String, Object> entry : model.entrySet()) {
                Object val = entry.getValue();
                if (i == 0) {
                    String name = maps.get(entry.getKey());
                    String[] fieldNames = name.split(":");
                    FieldData fieldData = new FieldData();
                    fieldData.field = entry.getKey();
                    fieldData.fieldName = fieldNames[0];
                    fieldData.numerical = Boolean.parseBoolean(fieldNames[1]);
                    if (fieldData.numerical) {
                        fieldData.percent = CosmicCommonUtils.isPercentField(fieldData.fieldName, percentEndswith);
                    }
                    fieldCaches.add(fieldData);
                    fields.add(CosmicSingle.createFieldMap(fieldData.field, fieldNames[0], Boolean.parseBoolean(fieldNames[1])));
                }
                FieldData fieldData = (FieldData)fieldCaches.get(j);
                if (fieldData.percent) {
                    BigDecimal decimal = new BigDecimal(String.valueOf(val)).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                    val = String.format("%s", decimal);
                } else if (fieldData.numerical) {
                    val = CosmicCommonUtils.divide(String.valueOf(val), div);
                }
                ++j;
                item.add(val);
            }
            fieldValues.add(item);
            ++i;
        }
        if (tableType.equalsIgnoreCase("rank") || tableType.equalsIgnoreCase("line")) {
            int idx = 0;
            if (!((FieldData)fieldCaches.get((int)idx)).numerical) {
                idx = 1;
            }
            if (((FieldData)fieldCaches.get((int)idx)).percent) {
                dataModel.put("numberFormat", "{0}0.0%");
            }
        }
        dataModel.put("fields", fields);
        dataModel.put("fieldValues", fieldValues);
        JSONObject json = new JSONObject(dataModel);
        return json.toJSONString();
    }

    private static class FieldData {
        String field;
        String fieldName;
        boolean numerical;
        boolean percent;

        private FieldData() {
        }
    }
}

