/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.sso;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.thirdauth.app.AppAuthResult;
import kd.bos.login.thirdauth.app.ThirdAppAuthtication;
import kd.bos.login.thirdauth.app.UserType;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;

public class CosmicAppPassportAuthication
extends ThirdAppAuthtication {
    private static final Log logger = LogFactory.getLog(CosmicAppPassportAuthication.class);
    private static final String authconfig = "cosmicapp_authconfig";
    private static final String cosmicapp_passport_code = "cosmicapp_passport_code";

    public boolean isNeedHandle(HttpServletRequest request, Account account) {
        String code = request.getParameter(cosmicapp_passport_code);
        return !StringUtils.isEmpty((String)code);
    }

    public AppAuthResult appAuthtication(HttpServletRequest request, Account account) {
        JSONObject config = this.getAuthConfig();
        AppAuthResult result = new AppAuthResult();
        result.setSucceed(false);
        String code = request.getParameter(cosmicapp_passport_code);
        String clientId = config.getString("clientId");
        String apiUrl = config.getString("url");
        String clientSecret = config.getString("clientSecret");
        String url = String.format("%s/auth/user/auth_code/validation?client_id=%s&client_secret=%s&auth_code=%s", apiUrl, clientId, clientSecret, code);
        JSONObject tokenData = this.cloudApiRequest(url, "post");
        if (tokenData == null) {
            return result;
        }
        logger.info(tokenData.toJSONString());
        String accessToken = tokenData.getString("access_token");
        url = String.format("%s/account/user_info?access_token=%s", apiUrl, accessToken);
        JSONObject userData = this.cloudApiRequest(url, "get");
        if (userData != null && !StringUtils.isBlank((String)userData.getString("phone"))) {
            logger.info(userData.toJSONString());
            result.setUserType(UserType.MOBILE_PHONE);
            result.setUserFlag(userData.getString("phone"));
        } else {
            result.setUserType(UserType.YZJUID);
            result.setUserFlag(tokenData.getString("uid"));
        }
        result.setSucceed(true);
        return result;
    }

    private JSONObject getAuthConfig() {
        String property = System.getProperty(RequestContext.get().getTenantId() + "_" + authconfig);
        if (StringUtils.isBlank((String)property)) {
            property = System.getProperty(authconfig);
        }
        return JSON.parseObject((String)property);
    }

    private JSONObject cloudApiRequest(String url, String method) {
        try {
            String respString = "get".equalsIgnoreCase(method) ? HttpClientUtils.get((String)url) : HttpClientUtils.post((String)url, null, null);
            logger.info("cosmicapp_passport_code get: " + url + "; result: " + respString);
            JSONObject jsonObject = JSON.parseObject((String)respString);
            if (jsonObject.getInteger("errcode") == 0) {
                return jsonObject.getJSONObject("data");
            }
        }
        finally {
            return null;
        }
        {
        }
    }
}

