/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.util;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import kd.aimp.cmapp.sdk.enums.ChartLable;
import kd.aimp.cmapp.sdk.util.NumberFormater;
import kd.bos.util.StringUtils;

public class CosmicChartUtils {
    public static final String DEFAULT_NUMBER_FORMAT = "#,##0.00";

    public static String buildCosmicLabel(ChartLable chartLable, Map<String, String> attr, String val) {
        StringBuffer sb = new StringBuffer();
        if (null != attr && !attr.isEmpty()) {
            attr.forEach((k, v) -> {
                if (StringUtils.isNotEmpty((String)v)) {
                    sb.append((String)k);
                    sb.append("=\"");
                    sb.append((String)v);
                    sb.append("\" ");
                }
            });
        }
        return String.format(chartLable.getLable(), sb, val);
    }

    public static String buildCosmicCard(String lable, Object value, String numberFormat) {
        BigDecimal num = Optional.ofNullable(value).map(String::valueOf).map(BigDecimal::new).orElse(BigDecimal.ZERO);
        NumberFormater numberFormater = new NumberFormater(numberFormat);
        return String.format(ChartLable.COSMIC_CARD.getLable(), lable, numberFormater.format(num));
    }
}

