/*
 * Decompiled with CFR 0.152.
 */
package kd.aimp.cmapp.sdk.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import kd.aimp.cmapp.sdk.util.TextParseDateUtil;

public class TimeExtractionProcess {
    private String question;
    private LocalDate baseDay;
    private static final DateTimeFormatter DATE_FORMATTERTER = DateTimeFormatter.ofPattern("yyyy/MM/dd");

    public TimeExtractionProcess(String question, LocalDate baseDay) {
        this.question = question;
        this.baseDay = null == baseDay ? LocalDate.now() : baseDay;
        this.specialProcess();
        this.strnumToAlnum();
        this.timeSpan();
        this.timePoint();
    }

    private void specialProcess() {
        Map<String, String> replaceDict = TextParseDateUtil.SpecialProcess.replaceDict;
        for (Map.Entry<String, String> entry : replaceDict.entrySet()) {
            this.question = this.question.replace(entry.getKey().toUpperCase(), entry.getValue()).replace(entry.getKey().toLowerCase(), entry.getValue());
        }
        Matcher iterator = TextParseDateUtil.SpecialProcess.pattern_2.matcher(this.question);
        if (iterator.find()) {
            return;
        }
        iterator = TextParseDateUtil.SpecialProcess.pattern_3.matcher(this.question);
        while (iterator.find()) {
            int yearLen;
            String year = iterator.group(2) != null ? ((yearLen = iterator.group(2).length()) == 2 ? "20" + iterator.group(2) : (yearLen == 3 ? "2" + iterator.group(2) : iterator.group(2))) : String.valueOf(this.baseDay.getYear());
            String string1 = year + "\u5e74";
            this.question = this.question.replace(iterator.group(), string1);
        }
    }

    private void strnumToAlnum() {
        Matcher matcher = TextParseDateUtil.StrnumToAlnum.pattern_1.matcher(this.question);
        ArrayList<String> strNumList = new ArrayList<String>();
        while (matcher.find()) {
            strNumList.add(matcher.group());
        }
        if (!strNumList.isEmpty()) {
            for (String item : strNumList) {
                int v = TextParseDateUtil.ChineseToArabic.convert(item);
                if (item.startsWith("0")) continue;
                if (item.startsWith("\u96f6") && item.length() > 1) {
                    this.question = this.question.replaceFirst(item, "0" + v);
                    continue;
                }
                this.question = this.question.replaceFirst(item, String.valueOf(v));
            }
        }
    }

    private void timeSpan() {
        if (TextParseDateUtil.TimeSpan.pattern_6.matcher(this.question).find()) {
            this.question = this.getTimeSpan();
        }
        Matcher date1Matcher = TextParseDateUtil.TimeSpan.pattern_7.matcher(this.question);
        ArrayList<String> date1List = new ArrayList<String>();
        while (date1Matcher.find()) {
            date1List.add(date1Matcher.group());
        }
        if (!date1List.isEmpty()) {
            for (String item : date1List) {
                String timespan = this.strToDate(item);
                this.question = this.question.replace(item, timespan);
            }
        }
        Matcher date2Matcher = TextParseDateUtil.TimeSpan.pattern_8.matcher(this.question);
        ArrayList<String> date2List = new ArrayList<String>();
        while (date2Matcher.find()) {
            date2List.add(date2Matcher.group());
        }
        if (!date2List.isEmpty()) {
            for (String item : date2List) {
                String timespan = this.strToDate(item);
                this.question = this.question.replace(item, timespan);
            }
        }
    }

    private String getTimeSpan() {
        String timespan;
        String timespan2;
        LocalDate day_end;
        LocalDate day_begin;
        Matcher iterator = TextParseDateUtil.GetTimeSpan.pattern_0.matcher(this.question);
        while (iterator.find()) {
            day_begin = this.baseDay;
            if (iterator.group(1) != null && iterator.group(2) != null) {
                if (this.isDigit(iterator.group(1))) {
                    day_begin = day_begin.withYear(Integer.parseInt(iterator.group(1)));
                } else {
                    int yearShift = this.getYearShift(iterator.group(1));
                    day_begin = this.baseDay.plusYears(yearShift);
                }
            }
            if (iterator.group(3) != null && iterator.group(4) != null) {
                if (this.isDigit(iterator.group(3))) {
                    day_begin = day_begin.withMonth(Integer.parseInt(iterator.group(3)));
                } else {
                    int monthShift = this.getMonthOrWeekShift(iterator.group(3));
                    day_begin = day_begin.plusMonths(monthShift);
                }
            }
            if (iterator.group(5) == null || iterator.group(6) == null) continue;
            LocalDate monthFloor = day_begin.withDayOfMonth(1);
            day_begin = monthFloor.getDayOfWeek().getValue() == 1 && "1".equals(iterator.group(5)) ? monthFloor.with(DayOfWeek.MONDAY) : monthFloor.plusWeeks(Long.parseLong(iterator.group(5)) - 1L).with(DayOfWeek.MONDAY);
            day_end = day_begin.plusDays(6L).with(DayOfWeek.SUNDAY);
            timespan2 = String.format("%s-%s", this.formatDate(day_begin, DATE_FORMATTERTER), this.formatDate(day_end, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan2);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_14.matcher(this.question);
        while (iterator.find()) {
            day_begin = this.baseDay;
            if (iterator.group(1) != null && iterator.group(2) != null) {
                if (this.isDigit(iterator.group(1))) {
                    day_begin = day_begin.withYear(Integer.parseInt(iterator.group(1)));
                } else {
                    int yearShift = this.getYearShift(iterator.group(1));
                    day_begin = this.baseDay.plusYears(yearShift);
                }
            }
            if (iterator.group(3) == null || iterator.group(4) == null) continue;
            LocalDate yearFloor = day_begin.withDayOfYear(1);
            day_begin = yearFloor.getDayOfWeek().getValue() == 1 && "1".equals(iterator.group(3)) ? yearFloor.with(DayOfWeek.MONDAY) : yearFloor.plusWeeks(Long.parseLong(iterator.group(3)) - 1L).with(DayOfWeek.MONDAY);
            day_end = day_begin.plusDays(6L).with(DayOfWeek.SUNDAY);
            timespan2 = String.format("%s-%s", this.formatDate(day_begin, DATE_FORMATTERTER), this.formatDate(day_end, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan2);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_1.matcher(this.question);
        while (iterator.find()) {
            day_begin = null;
            LocalDate day_end2 = null;
            if ("\u5468".equals(iterator.group(2)) || "\u661f\u671f".equals(iterator.group(2)) || "\u793c\u62dc".equals(iterator.group(2))) {
                int weekShift = this.getMonthOrWeekShift(iterator.group(1));
                day_begin = this.baseDay.plusWeeks(weekShift).with(DayOfWeek.MONDAY);
                day_end2 = day_begin.plusDays(6L).with(DayOfWeek.SUNDAY);
            } else if ("\u6708".equals(iterator.group(2))) {
                int monthShift = this.getMonthOrWeekShift(iterator.group(1));
                day_begin = this.baseDay.plusMonths(monthShift).withDayOfMonth(1);
                day_end2 = day_begin.plusMonths(1L).minusDays(1L);
            } else if ("\u5b63\u5ea6".equals(iterator.group(2))) {
                int quarterShift = this.getMonthOrWeekShift(iterator.group(1));
                day_begin = this.baseDay.plusMonths(quarterShift * 3).with(TemporalAdjusters.firstDayOfMonth());
                day_end2 = day_begin.plusMonths(3L).minusDays(1L);
            }
            timespan = String.format("%s-%s", this.formatDate(day_begin, DATE_FORMATTERTER), this.formatDate(day_end2, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_15.matcher(this.question);
        while (iterator.find()) {
            int monthShift = this.getMonthOrWeekShift(iterator.group(1));
            LocalDate day_begin2 = this.baseDay.plusMonths(monthShift).withDayOfMonth(Integer.parseInt(iterator.group(3)));
            timespan = String.format("%s-%s", this.formatDate(day_begin2, DATE_FORMATTERTER), this.formatDate(day_begin2, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_2.matcher(this.question);
        while (iterator.find()) {
            String group_1 = iterator.group(1);
            String group_2 = iterator.group(2);
            LocalDate day_begin3 = null;
            LocalDate day_end3 = null;
            if ("\u661f\u671f".equals(group_2) || "\u5468".equals(group_2) || "\u793c\u62dc".equals(group_2)) {
                int week = Integer.parseInt(group_1);
                day_begin3 = this.baseDay.minusWeeks(week);
                day_end3 = this.baseDay;
            } else if ("\u6708".equals(group_2) || "\u6708\u4efd".equals(group_2)) {
                int month = Integer.parseInt(group_1);
                if (this.question.charAt(iterator.start() + group_1.length()) == '\u524d') {
                    day_begin3 = this.baseDay.minusMonths(month).withDayOfMonth(1);
                    day_end3 = this.baseDay.minusMonths(month).withDayOfMonth(this.baseDay.minusMonths(month).lengthOfMonth());
                } else {
                    day_begin3 = this.baseDay.minusMonths(month);
                    day_end3 = this.baseDay;
                }
            } else if ("\u5929".equals(group_2) || "\u65e5".equals(group_2)) {
                int day = Integer.parseInt(group_1);
                day_begin3 = this.baseDay.minusDays(day);
                day_end3 = this.baseDay.minusDays(day);
            } else if ("\u5e74".equals(group_2)) {
                int year = Integer.parseInt(group_1);
                day_begin3 = this.baseDay.minusYears(year);
                day_end3 = this.baseDay;
            }
            String timespan3 = String.format("%s-%s", this.formatDate(day_begin3, DATE_FORMATTERTER), this.formatDate(day_end3, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan3);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_9.matcher(this.question);
        while (iterator.find()) {
            int group_1 = Integer.parseInt(iterator.group(1));
            LocalDate day_begin4 = this.baseDay;
            day_end = this.baseDay.plusMonths(group_1);
            timespan2 = String.format("%s-%s", this.formatDate(day_begin4, DATE_FORMATTERTER), this.formatDate(day_end, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan2);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_3.matcher(this.question);
        while (iterator.find()) {
            String year = iterator.group(1) != null ? iterator.group(1) : "None";
            int month = Integer.parseInt(iterator.group(2));
            int yearShift = this.getYearShift(year);
            if (month < 1 || month > 12) continue;
            LocalDate day_begin5 = this.baseDay.plusYears(yearShift).withMonth(month).withDayOfMonth(1);
            LocalDate day_end4 = day_begin5.plusMonths(1L).minusDays(1L);
            String timespan4 = String.format("%s-%s", this.formatDate(day_begin5, DATE_FORMATTERTER), this.formatDate(day_end4, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan4);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_4.matcher(this.question);
        while (iterator.find()) {
            LocalDate day_begin6 = null;
            LocalDate day_end5 = null;
            if (iterator.group(2) != null && !"".equals(iterator.group(2))) {
                String yearStr = iterator.group(1) != null ? iterator.group(1) : "None";
                int qua = Integer.parseInt(iterator.group(3));
                int yearShift = this.getYearShift(yearStr);
                day_begin6 = this.baseDay.withMonth(1).withDayOfMonth(1).plusYears(yearShift);
                day_end5 = day_begin6.plusMonths(qua * 3).minusDays(1L);
            } else {
                int qua = Integer.parseInt(iterator.group(3));
                day_begin6 = this.baseDay.minusMonths(qua * 3).withDayOfMonth(1);
                day_end5 = day_begin6.plusMonths(3L).minusDays(1L);
            }
            String timespan5 = String.format("%s-%s", this.formatDate(day_begin6, DATE_FORMATTERTER), this.formatDate(day_end5, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan5);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_11.matcher(this.question);
        while (iterator.find()) {
            int yearShift = this.getYearShift(iterator.group(1));
            int qua = Integer.parseInt(iterator.group(3));
            LocalDate day_begin7 = this.baseDay.plusYears(yearShift).withMonth(1).withDayOfMonth(1).plusMonths((qua - 1) * 3);
            LocalDate day_end6 = day_begin7.plusMonths(3L).minusDays(1L);
            String timespan6 = String.format("%s-%s", this.formatDate(day_begin7, DATE_FORMATTERTER), this.formatDate(day_end6, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan6);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_13.matcher(this.question);
        while (iterator.find()) {
            String year;
            String string = year = iterator.group(1) != null ? iterator.group(1) : "None";
            if (!this.isDigit(year)) {
                int yearShift = this.getYearShift(year);
                year = String.valueOf(this.baseDay.plusYears(yearShift).getYear());
            }
            int qua = Integer.parseInt(iterator.group(2));
            LocalDate day_begin8 = Year.parse(year).atDay(1).withMonth(1).withDayOfMonth(1).plusMonths((qua - 1) * 3);
            LocalDate day_end7 = day_begin8.plusMonths(3L).minusDays(1L);
            String timespan7 = String.format("%s-%s", this.formatDate(day_begin8, DATE_FORMATTERTER), this.formatDate(day_end7, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan7);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_12.matcher(this.question);
        while (iterator.find()) {
            int qua = Integer.parseInt(iterator.group(1));
            LocalDate day_begin9 = this.baseDay.withMonth(1).withDayOfMonth(1).plusMonths((qua - 1) * 3);
            LocalDate day_end8 = day_begin9.plusMonths(3L).minusDays(1L);
            String timespan8 = String.format("%s-%s", this.formatDate(day_begin9, DATE_FORMATTERTER), this.formatDate(day_end8, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan8);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_6_banniandu.matcher(this.question);
        while (iterator.find()) {
            int cur_month = this.baseDay.getMonthValue();
            String timespan9 = 1 <= cur_month && cur_month <= 6 ? String.format("%s/01/01-%s/06/30", this.baseDay.getYear(), this.baseDay.getYear()) : String.format("%s/07/01-%s/12/31", this.baseDay.getYear(), this.baseDay.getYear());
            this.question = this.question.replace(iterator.group(), timespan9);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_6.matcher(this.question);
        while (iterator.find()) {
            String year = iterator.group(1) != null ? iterator.group(1) : "None";
            String period = iterator.group(2);
            if (!this.isDigit(year)) {
                int yearShift = this.getYearShift(year);
                year = String.valueOf(this.baseDay.plusYears(yearShift).getYear());
            }
            if ("\u4e0a".equals(period)) {
                String timespan10 = String.format("%s/01/01-%s/06/30", year, year);
                this.question = this.question.replace(iterator.group(), timespan10);
                continue;
            }
            if (!"\u4e0b".equals(period)) continue;
            String timespan11 = String.format("%s/07/01-%s/12/31", year, year);
            this.question = this.question.replace(iterator.group(), timespan11);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_7.matcher(this.question);
        while (iterator.find()) {
            LocalDate day_begin10 = this.baseDay.minusMonths(6L);
            LocalDate day_end9 = this.baseDay;
            String timespan12 = String.format("%s-%s", this.formatDate(day_begin10, DATE_FORMATTERTER), this.formatDate(day_end9, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan12);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_5_daqiannian.matcher(this.question);
        while (iterator.find()) {
            LocalDate day_begin11 = this.baseDay.minusYears(3L).with(TemporalAdjusters.firstDayOfYear());
            LocalDate day_end10 = this.baseDay.minusYears(3L).with(TemporalAdjusters.lastDayOfYear());
            String timespan13 = String.format("%s-%s", this.formatDate(day_begin11, DATE_FORMATTERTER), this.formatDate(day_end10, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan13);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_5.matcher(this.question);
        while (iterator.find()) {
            String year = iterator.group(1);
            int yearShift = this.getYearShift(year);
            LocalDate day_begin12 = this.baseDay.plusYears(yearShift).with(TemporalAdjusters.firstDayOfYear());
            LocalDate day_end11 = this.baseDay.plusYears(yearShift).with(TemporalAdjusters.lastDayOfYear());
            String timespan14 = String.format("%s-%s", this.formatDate(day_begin12, DATE_FORMATTERTER), this.formatDate(day_end11, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan14);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_8.matcher(this.question);
        while (iterator.find()) {
            String group_1 = iterator.group(1);
            int[] shiftValues = this.getShiftValues(group_1);
            LocalDate day_begin13 = this.baseDay.plusDays(shiftValues[0]);
            LocalDate day_end12 = this.baseDay.plusDays(shiftValues[1]);
            String timespan15 = String.format("%s-%s", this.formatDate(day_begin13, DATE_FORMATTERTER), this.formatDate(day_end12, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan15);
        }
        iterator = TextParseDateUtil.GetTimeSpan.pattern_10.matcher(this.question);
        while (iterator.find()) {
            String date = iterator.group(1);
            String xun = iterator.group(2);
            int[] shiftValues = this.getXunShiftValues(xun);
            String[] dateParts = date.split("-");
            LocalDate day_begin14 = LocalDate.parse(dateParts[0], DATE_FORMATTERTER).plusDays(shiftValues[0]);
            LocalDate day_end13 = shiftValues[1] == 0 ? LocalDate.parse(dateParts[1], DATE_FORMATTERTER) : day_begin14.plusDays(shiftValues[1]);
            String timespan16 = String.format("%s-%s", this.formatDate(day_begin14, DATE_FORMATTERTER), this.formatDate(day_end13, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan16);
        }
        return this.question;
    }

    private void timePoint() {
        String timespan;
        LocalDate dayEnd;
        String dayEndPoint;
        String dayBegin;
        Matcher iterator = TextParseDateUtil.TimePoint.pattern_1.matcher(this.question);
        this.getTimePoint(iterator);
        iterator = TextParseDateUtil.TimePoint.pattern_8.matcher(this.question);
        while (iterator.find()) {
            dayBegin = iterator.group(1);
            dayEndPoint = iterator.group(3);
            dayEnd = LocalDate.parse(dayBegin, DATE_FORMATTERTER).withDayOfMonth(Integer.parseInt(dayEndPoint));
            timespan = String.format("%s-%s", dayBegin, this.formatDate(dayEnd, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan);
        }
        iterator = TextParseDateUtil.TimePoint.pattern_9.matcher(this.question);
        while (iterator.find()) {
            dayBegin = iterator.group(1);
            dayEndPoint = iterator.group(3);
            dayEnd = null;
            if ("\u6708".equals(dayEndPoint)) {
                dayEnd = LocalDate.parse(dayBegin, DATE_FORMATTERTER).with(TemporalAdjusters.lastDayOfMonth());
            } else if ("\u5e74".equals(dayEndPoint)) {
                dayEnd = LocalDate.parse(dayBegin, DATE_FORMATTERTER).with(TemporalAdjusters.lastDayOfYear());
            }
            timespan = String.format("%s-%s", dayBegin, this.formatDate(dayEnd, DATE_FORMATTERTER));
            this.question = this.question.replace(iterator.group(), timespan);
        }
        iterator = TextParseDateUtil.TimePoint.pattern_7.matcher(this.question);
        while (iterator.find()) {
            dayBegin = iterator.group(1);
            String dayEnd2 = iterator.group(4);
            String timespan2 = String.format("%s-%s", dayBegin, dayEnd2);
            this.question = this.question.replace(iterator.group(), timespan2);
        }
    }

    private void getTimePoint(Matcher iterator) {
        while (iterator.find()) {
            String timespan;
            LocalDate day;
            HashMap<String, Integer> dayShiftDict;
            Matcher match = TextParseDateUtil.TimePoint.pattern_101.matcher(iterator.group(1));
            if (match.find()) {
                dayShiftDict = new HashMap<String, Integer>();
                dayShiftDict.put("\u5f53\u524d", 0);
                dayShiftDict.put("\u73b0\u5728", 0);
                day = this.baseDay.plusDays(((Integer)dayShiftDict.get(match.group(1))).intValue());
                timespan = day.format(DATE_FORMATTERTER) + "-" + day.format(DATE_FORMATTERTER);
                this.question = this.question.replace(iterator.group(), timespan);
            }
            if ((match = TextParseDateUtil.TimePoint.pattern_102.matcher(iterator.group(1))).find()) {
                dayShiftDict = new HashMap();
                dayShiftDict.put("\u4eca", 0);
                dayShiftDict.put("\u5f53", 0);
                dayShiftDict.put("\u6628", -1);
                dayShiftDict.put("\u524d", -2);
                dayShiftDict.put("\u5927\u524d", -3);
                dayShiftDict.put("\u660e", 1);
                dayShiftDict.put("\u540e", 2);
                dayShiftDict.put("\u5927\u540e", 3);
                day = this.baseDay.plusDays(((Integer)dayShiftDict.get(match.group(1))).intValue());
                timespan = day.format(DATE_FORMATTERTER) + "-" + day.format(DATE_FORMATTERTER);
                this.question = this.question.replace(iterator.group(), timespan);
            }
            if (!(match = TextParseDateUtil.TimePoint.pattern_103.matcher(iterator.group(1))).find() || null == match.group(1)) continue;
            int weekShift = this.getMonthOrWeekShift(match.group(1));
            day = this.baseDay.plusWeeks(weekShift);
            if (match.group(3) != null) {
                day = day.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).plusDays(Integer.parseInt(match.group(3)) - 1);
            }
            timespan = day.format(DATE_FORMATTERTER) + "-" + day.format(DATE_FORMATTERTER);
            this.question = this.question.replace(iterator.group(), timespan);
        }
    }

    private String strToDate(String date_str) {
        Matcher date_search = TextParseDateUtil.StrToDate.pattern_1.matcher(date_str);
        if (date_search.find()) {
            String year_str = date_search.group(1);
            String month_str = date_search.group(3);
            String day_str = date_search.group(5);
            if (String.valueOf(month_str).length() == TextParseDateUtil.StrToDate.int3) {
                month_str = TextParseDateUtil.StrToDate.str5 + month_str;
            }
            if (String.valueOf(day_str).length() == TextParseDateUtil.StrToDate.int3) {
                day_str = TextParseDateUtil.StrToDate.str5 + day_str;
            }
            if (year_str.length() == TextParseDateUtil.StrToDate.int1) {
                year_str = TextParseDateUtil.StrToDate.str1 + year_str;
            } else if (year_str.length() == TextParseDateUtil.StrToDate.int2) {
                year_str = TextParseDateUtil.StrToDate.str2 + year_str;
            }
            String date_date = String.format("%s/%s/%s", year_str, month_str, day_str);
            date_date = date_date + "-" + date_date;
            return date_date;
        }
        date_search = TextParseDateUtil.StrToDate.pattern_4.matcher(date_str = date_str.replace(TextParseDateUtil.StrToDate.str3, TextParseDateUtil.StrToDate.str4));
        if (date_search.find()) {
            String year_str;
            HashMap<String, Integer> yearShiftDict = new HashMap<String, Integer>();
            yearShiftDict.put("\u4eca", 0);
            yearShiftDict.put("\u53bb", -1);
            yearShiftDict.put("\u524d", -2);
            yearShiftDict.put("\u660e", 1);
            if (date_search.group(1) != null && yearShiftDict.containsKey(date_search.group(1))) {
                int yearShift = this.getYearShift(date_search.group(1));
                year_str = String.valueOf(this.baseDay.plusYears(yearShift).getYear());
            } else {
                year_str = date_search.group(1);
            }
            String month_str = date_search.group(2);
            String day_str = date_search.group(3);
            if (month_str.length() == TextParseDateUtil.StrToDate.int3) {
                month_str = TextParseDateUtil.StrToDate.str5 + month_str;
            }
            if (day_str.length() == TextParseDateUtil.StrToDate.int3) {
                day_str = TextParseDateUtil.StrToDate.str5 + day_str;
            }
            if (year_str.length() == TextParseDateUtil.StrToDate.int1) {
                year_str = TextParseDateUtil.StrToDate.str1 + year_str;
            } else if (year_str.length() == TextParseDateUtil.StrToDate.int2) {
                year_str = TextParseDateUtil.StrToDate.str2 + year_str;
            }
            String date_str_temp = String.format("%s/%s/%s", year_str, month_str, day_str);
            date_str_temp = date_str_temp + "-" + date_str_temp;
            return date_str_temp;
        }
        date_search = TextParseDateUtil.StrToDate.pattern_5.matcher(date_str);
        if (date_search.find()) {
            String year_str = date_search.group(1);
            String month_str = date_search.group(2);
            String day_str = date_search.group(3);
            if (month_str.length() == TextParseDateUtil.StrToDate.int3) {
                month_str = TextParseDateUtil.StrToDate.str5 + month_str;
            }
            if (day_str.length() == TextParseDateUtil.StrToDate.int3) {
                day_str = TextParseDateUtil.StrToDate.str5 + day_str;
            }
            if (year_str.length() == TextParseDateUtil.StrToDate.int1) {
                year_str = TextParseDateUtil.StrToDate.str1 + year_str;
            } else if (year_str.length() == TextParseDateUtil.StrToDate.int2) {
                year_str = TextParseDateUtil.StrToDate.str2 + year_str;
            }
            String date_str_temp = String.format("%s/%s/%s", year_str, month_str, day_str);
            date_str_temp = date_str_temp + "-" + date_str_temp;
            return date_str_temp;
        }
        date_search = TextParseDateUtil.StrToDate.pattern_6.matcher(date_str);
        if (date_search.find()) {
            String year_str = date_search.group(1);
            String month_str = date_search.group(2);
            if (month_str.length() == TextParseDateUtil.StrToDate.int3) {
                month_str = TextParseDateUtil.StrToDate.str5 + month_str;
            }
            if (year_str.length() == TextParseDateUtil.StrToDate.int1) {
                year_str = TextParseDateUtil.StrToDate.str1 + year_str;
            } else if (year_str.length() == TextParseDateUtil.StrToDate.int2) {
                year_str = TextParseDateUtil.StrToDate.str2 + year_str;
            }
            int month_range = LocalDate.of(Integer.parseInt(year_str), Integer.parseInt(month_str), 1).lengthOfMonth();
            String date_str_temp = String.format("%s/%s/01-%s/%s/%d", year_str, month_str, year_str, month_str, month_range);
            return date_str_temp;
        }
        date_search = TextParseDateUtil.StrToDate.pattern_7.matcher(date_str);
        if (date_search.find()) {
            String month_str = date_search.group(1);
            String day_str = date_search.group(2);
            if (month_str.length() == TextParseDateUtil.StrToDate.int3) {
                month_str = TextParseDateUtil.StrToDate.str5 + month_str;
            }
            if (day_str.length() == TextParseDateUtil.StrToDate.int3) {
                day_str = TextParseDateUtil.StrToDate.str5 + day_str;
            }
            String date_str_temp = String.format("%s/%s/%s", this.baseDay.getYear(), month_str, day_str);
            date_str_temp = date_str_temp + "-" + date_str_temp;
            return date_str_temp;
        }
        date_search = TextParseDateUtil.StrToDate.pattern_8.matcher(date_str);
        if (date_search.find()) {
            String year_str = "";
            if (date_search.group(1) != null && date_search.group(1).matches("\\d+")) {
                year_str = date_search.group(1);
            }
            if (year_str.length() == TextParseDateUtil.StrToDate.int1 && Integer.parseInt(year_str.substring(0, 1)) <= TextParseDateUtil.StrToDate.int1) {
                year_str = TextParseDateUtil.StrToDate.str1 + year_str;
            } else if (year_str.length() == TextParseDateUtil.StrToDate.int2) {
                year_str = TextParseDateUtil.StrToDate.str2 + year_str;
            }
            String day_begin = String.format("%s/01/01", year_str);
            String day_end = String.format("%s/12/31", year_str);
            return String.format("%s-%s", day_begin, day_end);
        }
        return null;
    }

    private boolean isDigit(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int getYearShift(String yearStr) {
        switch (yearStr) {
            case "\u672c": 
            case "\u4eca": 
            case "\u4eca\u5e74": {
                return 0;
            }
            case "\u53bb": 
            case "\u53bb\u5e74": 
            case "\u4e0a1": 
            case "\u4e0a": {
                return -1;
            }
            case "\u524d": 
            case "\u524d\u5e74": {
                return -2;
            }
            case "\u660e": 
            case "\u660e\u5e74": 
            case "\u4e0b": 
            case "\u4e0b1": {
                return 1;
            }
        }
        return 0;
    }

    private int getMonthOrWeekShift(String monthStr) {
        switch (monthStr) {
            case "\u4e0a\u4e0a": {
                return -2;
            }
            case "\u4e0a": {
                return -1;
            }
            case "\u672c": 
            case "\u5f53": 
            case "\u8fd9": {
                return 0;
            }
            case "\u4e0b\u4e0b": {
                return 2;
            }
            case "\u4e0b": {
                return 1;
            }
        }
        return 0;
    }

    private int[] getShiftValues(String yearStr) {
        switch (yearStr) {
            case "\u8fd1": {
                return new int[]{-15, 0};
            }
            case "\u8fc7\u53bb": {
                return new int[]{0, -15};
            }
            case "\u672a\u6765": {
                return new int[]{0, 15};
            }
            case "\u4e0a": {
                return new int[]{0, 14};
            }
            case "\u4e0b": {
                return new int[]{14, 0};
            }
        }
        return new int[]{-15, 0};
    }

    private int[] getXunShiftValues(String yearStr) {
        switch (yearStr) {
            case "\u4e0a\u65ec": {
                return new int[]{0, 9};
            }
            case "\u4e2d\u65ec": {
                return new int[]{9, 10};
            }
            case "\u4e0b\u65ec": {
                return new int[]{19, 0};
            }
            case "\u4e2d\u4e0a\u65ec": {
                return new int[]{0, 19};
            }
            case "\u4e2d\u4e0b\u65ec": {
                return new int[]{9, 0};
            }
        }
        return new int[]{0, 9};
    }

    private String formatDate(LocalDate date, DateTimeFormatter formatter) {
        return null == date ? "" : date.format(formatter);
    }

    public List<Map<String, String>> getDates() {
        ArrayList<Map<String, String>> dates = new ArrayList<Map<String, String>>();
        Matcher matcher = TextParseDateUtil.pattern_date.matcher(this.question);
        while (matcher.find()) {
            String group = matcher.group();
            String[] datas = group.replace("/", "").split("-");
            HashMap<String, String> dateMap = new HashMap<String, String>();
            dateMap.put("begin", datas[0]);
            dateMap.put("end", datas[1]);
            dates.add(dateMap);
        }
        return dates;
    }

    public List<String> getDatesStr() {
        ArrayList<String> dates = new ArrayList<String>();
        Matcher matcher = TextParseDateUtil.pattern_date.matcher(this.question);
        while (matcher.find()) {
            String group = matcher.group();
            dates.add(group.replace("/", ""));
        }
        return dates;
    }
}

