/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.aop;

import kd.ai.gai.core.code.GaiErrorCode;
import kd.bos.exception.ErrorCode;

public class Result<T> {
    private String errorCode = "";
    private String message;
    private String requestId;
    private T data;
    private boolean status = true;

    public Result() {
    }

    public Result(String errorCode, String message, String requestId, T data, boolean status) {
        this.errorCode = errorCode;
        this.message = message;
        this.requestId = requestId;
        this.data = data;
        this.status = status;
    }

    public Result(String errorCode, String message, String requestId, boolean status) {
        this.errorCode = errorCode;
        this.message = message;
        this.requestId = requestId;
        this.status = status;
    }

    public static <T> Result<T> success(String requestId, T data) {
        return new Result<T>(GaiErrorCode.OK.getCode(), GaiErrorCode.OK.getMsg(), requestId, data, true);
    }

    public static <T> Result fail(String requestId, GaiErrorCode errorCode) {
        return new Result<T>(errorCode.getCode(), errorCode.getMsg(), requestId, false);
    }

    public static <T> Result<T> fail(String requestId, ErrorCode errorCode) {
        return new Result<T>(errorCode.getCode(), errorCode.getMessage(), requestId, false);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }
}

