/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.api.mservice.query.MsRequiredParams;
import kd.ai.gai.core.domain.dto.agent.ApiChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.SkillSrcEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.util.AgentThreadUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.mservice.GaiAgentService;
import kd.ai.gai.pojo.agent.AgentStartParams;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentServiceImpl
implements GaiAgentService {
    private static final Log logger = LogFactory.getLog(GaiAgentServiceImpl.class);

    public String agentStart(String requiredParams, String bizParams) {
        logger.info("agentStart requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        AgentStartParams agentStartParams = (AgentStartParams)JSONObject.parseObject((String)bizParams, AgentStartParams.class);
        String agentId = agentStartParams.getAgentId();
        MsRequiredParams msRequiredParams = (MsRequiredParams)JSONObject.parseObject((String)requiredParams, MsRequiredParams.class);
        String chatSessionId = null;
        Context context = null;
        if (StringUtils.isEmpty((CharSequence)agentStartParams.getChatSessionId())) {
            context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (long)0L, null, null, null, null);
            chatSessionId = context.getChatSessionId();
            FlowCacheData.putContext((String)chatSessionId, (Context)context);
        } else {
            chatSessionId = agentStartParams.getChatSessionId();
            context = FlowCacheData.getContext((String)chatSessionId);
        }
        if (Context.needCheckLicense((Context)context)) {
            try {
                GPTLicenseHelper.checkLic((String)GaiFormIdEnum.GAI_AGENT.getId(), (Long)Long.parseLong(agentId));
            }
            catch (KDBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return JSONObject.toJSONString((Object)BaseResult.fail((String)e.getErrorCode().getMessage()));
            }
        }
        Skill skill = new Skill();
        skill.setId(agentId);
        skill.setType(Skill.Type.AGENT);
        skill.setSkillSrc(SkillSrcEnum.USER);
        context.setCurrentSkill(skill);
        FlowCacheData.putContext((String)chatSessionId, (Context)context);
        JSONObject configJo = new JSONObject();
        configJo.put("callBackInfo", (Object)agentStartParams.getCallBackInfo());
        configJo.put("requiredParams", (Object)msRequiredParams);
        configJo.put("slideEnv", (Object)SLIDEENV.API_MSERVICE);
        configJo.put("needPushMsg", (Object)agentStartParams.getNeedPushMsg());
        Message userMessage = MessageService.insertMessage((String)context.getChatSessionId(), (String)agentStartParams.getInput(), (String)"", (String)configJo.toJSONString(), (Skill)skill, (ChatMessageTypeEnum)ChatMessageTypeEnum.USER, (EnableEnum)(agentStartParams.getNeedPushMsg() != false ? EnableEnum.YES : EnableEnum.NO));
        HashMap<String, String> inParaMap = new HashMap<String, String>();
        inParaMap.put("asTool", agentStartParams.getNeedPushMsg() != null && agentStartParams.getNeedPushMsg() == false ? "true" : "false");
        Context con = context;
        AgentThreadUtils.execute(() -> ChatService.startJavaAgentChat((Context)con, (Message)userMessage, (Map)inParaMap));
        JSONObject dataJo = new JSONObject();
        dataJo.put("chatSessionId", (Object)chatSessionId);
        dataJo.put("runId", (Object)String.valueOf(userMessage.getRunId()));
        String result = JSONObject.toJSONString((Object)new BaseResult((Object)dataJo));
        logger.info("agentStart result:{}", (Object)result);
        return result;
    }

    public String runMessage(String requiredParams, String bizParams) {
        logger.info("runMessage requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        JSONObject bizParamsJo = JSONObject.parseObject((String)bizParams);
        long runId = Long.parseLong(bizParamsJo.getString("runId"));
        ApiChatMessageDTO apiChatMessageDTO = MessageService.getAssistantMessage((long)runId);
        if (apiChatMessageDTO == null) {
            return JSONObject.toJSONString((Object)BaseResult.fail((String)String.format("\u6267\u884c\u6d88\u606f:%s\u4e0d\u5b58\u5728", runId)));
        }
        String result = JSONObject.toJSONString((Object)new BaseResult((Object)apiChatMessageDTO));
        logger.info("runMessage result:{}", (Object)result);
        return result;
    }

    public String agentCancel(String requiredParams, String bizParams) {
        logger.info("agentCancel requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        JSONObject bizParamsJo = JSONObject.parseObject((String)bizParams);
        long runId = Long.parseLong(bizParamsJo.getString("runId"));
        Run run = RunService.getRunById((Long)runId);
        JSONObject dataJo = new JSONObject();
        if (run != null) {
            if (!RunStepStatusEnum.isEndStatus((String)run.getRunStatus())) {
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession((Long)run.getSessionId());
                ChatService.agentCancel((String)chatSessionDTO.getId(), (long)runId);
                dataJo.put("runStatus", (Object)RunStepStatusEnum.CANCELLED.getId());
                dataJo.put("runId", (Object)String.valueOf(run.getRunId()));
                String result = JSONObject.toJSONString((Object)new BaseResult((Object)dataJo));
                logger.info("runMessage result:{}", (Object)result);
                return result;
            }
            return JSONObject.toJSONString((Object)BaseResult.fail((String)"\u6267\u884c\u5df2\u7ed3\u675f\uff0c\u4e0d\u652f\u6301\u53d6\u6d88"));
        }
        return JSONObject.toJSONString((Object)BaseResult.fail((String)String.format("\u6267\u884c\u8bb0\u5f55:%s\u4e0d\u5b58\u5728", runId)));
    }

    public String updateAgent(String requiredParams, String bizParams) {
        logger.info("updateAgent requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        JSONObject bizParamsJo = JSONObject.parseObject((String)bizParams);
        long agentId = Long.parseLong(bizParamsJo.getString("agentId"));
        String llmNumber = bizParamsJo.getString("llmNumber");
        DynamicObject agentDo = BusinessDataServiceHelper.loadSingle((Object)agentId, (String)GaiFormIdEnum.GAI_AGENT.getId());
        if (agentDo != null) {
            agentDo.set("llm", (Object)llmNumber);
            List serviceList = AiccService.getLlmList();
            for (Map service : serviceList) {
                if (!llmNumber.equals(service.get("number"))) continue;
                agentDo.set("llmname", (Object)((String)service.get("name")));
                break;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{agentDo});
            JSONObject dataJo = new JSONObject();
            dataJo.put("agentId", (Object)StrUtils.longAsString((Long)((Long)agentDo.getPkValue())));
            dataJo.put("llmNumber", (Object)llmNumber);
            String result = JSONObject.toJSONString((Object)new BaseResult((Object)dataJo));
            logger.info("updateAgent result:{}", (Object)result);
            return result;
        }
        return JSONObject.toJSONString((Object)BaseResult.fail((String)String.format("\u667a\u80fd\u4f53:%s\u4e0d\u5b58\u5728", agentId)));
    }

    public String callbacktest(String paramJson) {
        logger.info("callbacktest paramJson:{}", (Object)paramJson);
        return JSONObject.toJSONString((Object)new BaseResult((Object)paramJson));
    }
}

