/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.agent.ChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.mservice.GaiChatService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.IAppCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiChatServiceImpl
implements GaiChatService {
    private static final Log logger = LogFactory.getLog(GaiChatServiceImpl.class);

    public String getMessageList(String requiredParams, String bizParams) {
        logger.info("getMessageList requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        JSONObject bizParamsJo = JSON.parseObject((String)bizParams);
        List chatSessionIdList = bizParamsJo.getJSONArray("chatSessionIdList").toJavaList(String.class);
        Map idMap = ChatService.getSessionIdList((List)chatSessionIdList);
        long startTime = bizParamsJo.getLongValue("startTime");
        JSONObject dataJo = new JSONObject();
        JSONArray listJa = new JSONArray();
        List chatMessageDTOList = ChatService.getChatMessageList(idMap.keySet(), (Date)(startTime > 0L ? new Date(startTime) : null));
        if (CollectionUtils.isNotEmpty((Collection)chatMessageDTOList)) {
            JSONObject listItemJo = null;
            Map<String, List<ChatMessageDTO>> chatMessageDTOMap = chatMessageDTOList.stream().collect(Collectors.groupingBy(ChatMessageDTO::getSessionId));
            for (Map.Entry<String, List<ChatMessageDTO>> item : chatMessageDTOMap.entrySet()) {
                listItemJo = new JSONObject();
                listItemJo.put("chatSessionId", idMap.get(Long.parseLong(item.getKey())));
                listItemJo.put("messageList", item.getValue());
                listJa.add((Object)listItemJo);
            }
            dataJo.put("list", (Object)listJa);
        }
        String result = JSONObject.toJSONString((Object)new BaseResult((Object)dataJo));
        logger.info("getMessageList result:{}", (Object)result);
        return result;
    }

    public String sendMsg(String requiredParams, String bizParams) {
        logger.info("sendMsg requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        BaseResult baseResult = new BaseResult(null);
        try {
            JSONObject bizParamsJo = JSON.parseObject((String)bizParams);
            String chatSessionId = bizParamsJo.getString("chatSessionId");
            Context context = FlowCacheData.getContext((String)chatSessionId);
            String content = bizParamsJo.getString("content");
            long type = bizParamsJo.getLong("type");
            if (type == ChatMessageTypeEnum.USER.getId()) {
                baseResult = BaseResult.fail((String)"\u6682\u4e0d\u652f\u6301\u53d1\u9001\u7528\u6237\u6d88\u606f");
            } else if (type == ChatMessageTypeEnum.ASSISTANT.getId() || type == ChatMessageTypeEnum.PROCESS.getId()) {
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession((String)chatSessionId);
                Message lastUserMessage = MessageService.getLastUserMessage((String)chatSessionId, null);
                Message message = new Message();
                message.setContentTag(content);
                message.setType(Long.valueOf(type));
                message.setSessionId(Long.valueOf(Long.parseLong(chatSessionDTO.getSessionId())));
                message.setRunId(lastUserMessage.getRunId());
                message.setEnable(EnableEnum.YES.getKeyStr());
                message.setSkillId(lastUserMessage.getSkillId());
                message.setSkillType(lastUserMessage.getSkillType());
                message.setSkillSrc(lastUserMessage.getSkillSrc());
                message = MessageService.saveMessage((String)chatSessionId, (Message)message);
                ChatService.pushUserOrAssistantMessage((Context)context, (Message)message);
            }
        }
        catch (Exception e) {
            logger.error(String.format("error : %s", e.getMessage()), (Throwable)e);
            baseResult = BaseResult.fail((String)e.getMessage());
        }
        String result = JSONObject.toJSONString((Object)baseResult);
        logger.info("sendMsg result:{}", (Object)result);
        return result;
    }

    public String pushCallbackMsg(String requiredParams, String bizParams) {
        logger.info("pushMsg requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        BaseResult baseResult = new BaseResult(null);
        try {
            String taskCacheKey;
            JSONObject bizParamsJo = JSON.parseObject((String)bizParams);
            String chatSessionId = bizParamsJo.getString("chatSessionId");
            JSONObject callbackInfo = bizParamsJo.getJSONObject("callbackInfo");
            JSONObject resultVoMapJo = bizParamsJo.getJSONObject("resultVoMap");
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (callbackInfo != null) {
                context.setCallbackUrl(JSONArray.toJSONString((Object)callbackInfo));
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
            }
            JSONArray actionListJa = resultVoMapJo.getJSONArray("actionList");
            JSONObject actionJo = actionListJa.getJSONObject(0);
            String type = actionJo.getString("type");
            JSONObject dataJo = actionJo.getJSONObject("data");
            IAppCache appCache = EngineCache.getAppCache((String)chatSessionId);
            String taskId = (String)appCache.get(taskCacheKey = "taskCacheId_" + chatSessionId, String.class);
            if (taskId == null || taskId.length() == 0) {
                taskId = String.valueOf(ID.genLongId());
                appCache.put(taskCacheKey, (Object)taskId);
            }
            String msgCacheKey = "streamBuffer" + chatSessionId;
            String thinkMsgCacheKey = "streamThinkBuffer" + chatSessionId;
            String assistantMsgCacheKey = "lastRunId_" + chatSessionId;
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ResultActionType.waiting.name())) {
                long assistantMessageId = ID.genLongId();
                JSONObject msgCacheJo = new JSONObject();
                msgCacheJo.put("message", (Object)"");
                msgCacheJo.put("messageId", (Object)String.valueOf(assistantMessageId));
                appCache.put(msgCacheKey, (Object)msgCacheJo.toJSONString());
                JSONObject thinkCacheJO = new JSONObject();
                thinkCacheJO.put("thinkMsg", (Object)"");
                thinkCacheJO.put("messageId", (Object)String.valueOf(assistantMessageId));
                appCache.put(thinkMsgCacheKey, (Object)thinkCacheJO.toJSONString());
                logger.info("waiting.msgCacheStr:{}", (Object)msgCacheJo.toJSONString());
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession((String)chatSessionId);
                DynamicObject assistantMessageDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
                assistantMessageDo.set("id", (Object)assistantMessageId);
                assistantMessageDo.set("sessionId", (Object)chatSessionDTO.getSessionId());
                assistantMessageDo.set("type", (Object)ChatMessageTypeEnum.ASSISTANT.getId());
                assistantMessageDo.set("enable", (Object)EnableEnum.NO.getKey());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{assistantMessageDo});
                dataJo.put("taskId", (Object)taskId);
                PushMsgService.doPush((Context)context, (Map)resultVoMapJo);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ResultActionType.think_chat.name())) {
                String thinkMsgCacheStr = (String)appCache.get(thinkMsgCacheKey, String.class);
                String streamThinkMsg = dataJo.getString("message");
                int seqNo = dataJo.getIntValue("seqNo");
                JSONObject thinkCacheJO = JSON.parseObject((String)thinkMsgCacheStr);
                String messageId = thinkCacheJO.getString("messageId");
                logger.info("thinkMsgCacheJo:{}", (Object)thinkCacheJO.toJSONString());
                String cacheMessage = thinkCacheJO.getString("thinkMsg");
                cacheMessage = (cacheMessage == null ? "" : cacheMessage) + (streamThinkMsg == null ? "" : streamThinkMsg);
                thinkCacheJO.put("thinkMsg", (Object)cacheMessage);
                appCache.put(thinkMsgCacheKey, (Object)thinkCacheJO.toJSONString());
                Message message = MessageService.getLastUserMessage((String)chatSessionId, null);
                message.setMessageId(Long.valueOf(Long.parseLong(messageId)));
                message.setType(ChatMessageTypeEnum.ASSISTANT.getId());
                message.setContentTag(cacheMessage);
                ChatService.pushAssistantStreamThinkMessage((Context)context, (Message)message, (String)streamThinkMsg, (int)seqNo);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ResultActionType.chat.name())) {
                String msgCacheStr = (String)appCache.get(msgCacheKey, String.class);
                logger.info("chat.msgCacheStr:{}", (Object)msgCacheStr);
                String streamMessage = dataJo.getString("message");
                int seqNo = dataJo.getIntValue("seqNo");
                JSONObject msgCacheJo = JSONObject.parseObject((String)msgCacheStr);
                String messageId = msgCacheJo.getString("messageId");
                logger.info("msgCacheJo:{}", (Object)msgCacheJo.toJSONString());
                String cacheMessage = msgCacheJo.getString("message");
                cacheMessage = (cacheMessage == null ? "" : cacheMessage) + (streamMessage == null ? "" : streamMessage);
                msgCacheJo.put("message", (Object)cacheMessage);
                appCache.put(msgCacheKey, (Object)msgCacheJo.toJSONString());
                Message message = MessageService.getLastUserMessage((String)chatSessionId, null);
                logger.info("messageaaa:{}", (Object)JSONObject.toJSONString((Object)message));
                message.setMessageId(Long.valueOf(Long.parseLong(messageId)));
                message.setType(ChatMessageTypeEnum.ASSISTANT.getId());
                message.setContentTag(cacheMessage);
                ChatService.pushAssistantStreamMessage((Context)context, (Message)message, (String)streamMessage, (boolean)false, (String)message.getConfigTag(), (int)seqNo);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ResultActionType.streamDone.name())) {
                JSONObject msgCacheJo = JSONObject.parseObject((String)((String)appCache.get(msgCacheKey, String.class)));
                String messageStr = msgCacheJo.getString("message");
                String messageId = msgCacheJo.getString("messageId");
                JSONObject thinkMsgCacheJO = JSON.parseObject((String)((String)appCache.get(thinkMsgCacheKey, String.class)));
                String thinkMsg = thinkMsgCacheJO.getString("thinkMsg");
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession((String)chatSessionId);
                Message lastUserMessage = MessageService.getLastUserMessage((String)chatSessionId, null);
                long runId = lastUserMessage.getRunId();
                Message message = new Message();
                message.setMessageId(Long.valueOf(Long.parseLong(messageId)));
                message.setContentTag(messageStr);
                message.setThought(thinkMsg);
                message.setType(ChatMessageTypeEnum.ASSISTANT.getId());
                message.setSessionId(Long.valueOf(Long.parseLong(chatSessionDTO.getSessionId())));
                message.setRunId(lastUserMessage.getRunId());
                message.setEnable(EnableEnum.YES.getKeyStr());
                message.setSkillId(lastUserMessage.getSkillId());
                message.setSkillType(lastUserMessage.getSkillType());
                message.setSkillSrc(lastUserMessage.getSkillSrc());
                MessageService.saveJavaMessage((String)chatSessionId, (Message)message);
                appCache.put(assistantMsgCacheKey, (Object)messageStr);
                appCache.remove(msgCacheKey);
                appCache.remove(thinkMsgCacheKey);
                PushMsgService.pushStreamDown((Context)context, (String)taskId, (String)"0", (String)"", (String)messageId, (String)(runId + ""));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)ResultActionType.waitingDone.name())) {
                PushMsgService.pushWaitingDone((Context)context, (long)0L, (String)taskId);
                appCache.remove(taskCacheKey);
            } else {
                PushMsgService.doPush((Context)context, (Map)resultVoMapJo);
            }
        }
        catch (Exception e) {
            logger.error(String.format("error : %s", e.getMessage()), (Throwable)e);
            baseResult = BaseResult.fail((String)e.getMessage());
        }
        String result = JSONObject.toJSONString((Object)baseResult);
        logger.info("pushMsg result:{}", (Object)result);
        return result;
    }
}

