/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.UUID;
import kd.ai.gai.core.trace.MonitorServiceHelper;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.entity.EventLog;
import kd.ai.gai.core.trace.entity.EventLogResult;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.ai.gai.mservice.GaiMonitorService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class GaiMonitorServiceImpl
implements GaiMonitorService {
    private static final Log logger = LogFactory.getLog(GaiMonitorServiceImpl.class);

    public String saveStepLog(String paramsJson) {
        BaseResult logResult = new BaseResult();
        try {
            ParserConfig config = new ParserConfig();
            config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
            StepLog log = (StepLog)JSON.parseObject((String)paramsJson, StepLog.class, (ParserConfig)config, (Feature[])new Feature[]{Feature.DisableFieldSmartMatch});
            if (StringUtils.isEmpty((String)log.getChatSessionId())) {
                log.setChatSessionId(String.format("MS%s", UUID.randomUUID().toString().replaceAll("-", "")));
            }
            StepLogResult stepLogResult = MonitorServiceHelper.saveStepLog((StepLog)log);
            logResult.setData((Object)stepLogResult);
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace((Exception)e)));
            logResult.setErrCode(BaseResult.FAILED);
            logResult.setErrMsg(e.getMessage());
            logResult.setStatus(Boolean.FALSE);
        }
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCase);
        return JSONObject.toJSONString((Object)logResult, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    public String saveEventLog(String paramsJson) {
        BaseResult logResult = new BaseResult();
        try {
            ParserConfig config = new ParserConfig();
            config.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
            EventLog log = (EventLog)JSON.parseObject((String)paramsJson, EventLog.class, (ParserConfig)config, (Feature[])new Feature[]{Feature.DisableFieldSmartMatch});
            if (StringUtils.isEmpty((String)log.getChatSessionId())) {
                log.setChatSessionId(String.format("MS%s", UUID.randomUUID().toString().replaceAll("-", "")));
            }
            EventLogResult eventLogResult = MonitorServiceHelper.saveEventLog((EventLog)log);
            logResult.setData((Object)eventLogResult);
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace((Exception)e)));
            logResult.setErrCode(BaseResult.FAILED);
            logResult.setErrMsg(e.getMessage());
            logResult.setStatus(Boolean.FALSE);
        }
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.setPropertyNamingStrategy(PropertyNamingStrategy.SnakeCase);
        return JSONObject.toJSONString((Object)logResult, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }
}

