/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.api.APIResultHelper;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.APILLMMessage;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.APIDetailService;
import kd.ai.gai.mservice.GaiPromptOpenAPIService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GaiPromptOpenAPIServiceImpl
implements GaiPromptOpenAPIService {
    private static final Log logger = LogFactory.getLog(GaiPromptOpenAPIServiceImpl.class);

    public Map<String, Object> syncCallUseHistoryMsg(String chatSessionId, boolean isStream, String promptNumber, String input, Map<String, String> varParams) {
        return this.syncCallUseDynamicRepo(chatSessionId, isStream, promptNumber, input, varParams, null);
    }

    public Map<String, Object> syncCallUseDynamicRepo(String chatSessionId, boolean isStream, String promptNumber, String input, Map<String, String> varParams, List<Long> repoIds) {
        return this.syncCallUseDynamicRepoTopK(chatSessionId, isStream, promptNumber, input, varParams, null, 0);
    }

    public Map<String, Object> syncCallUseDynamicRepoTopK(String chatSessionId, boolean isStream, String promptNumber, String input, Map<String, String> varParams, List<Long> repoIds, int useKnowledgeTopK) {
        DynamicObject prampt;
        Context context;
        String opDesc;
        String requestId = APIResultHelper.buildRequestId();
        String string = opDesc = repoIds == null ? "\u542b\u5bf9\u8bdd\u5386\u53f2" : "\u52a8\u6001\u77e5\u8bc6\u5e93+\u542b\u5bf9\u8bdd\u5386\u53f2";
        if (StringUtils.isEmpty((CharSequence)chatSessionId)) {
            chatSessionId = requestId;
            logger.info("\u3010GPT\u63d0\u793a-OpenAPI\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528({})-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0cchatSessionId\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316:{}", (Object)opDesc, (Object)chatSessionId);
        }
        if (Objects.isNull(context = FlowCacheData.getContext((String)chatSessionId))) {
            context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (String)chatSessionId, null, (long)0L, null, null, null);
            FlowCacheData.putContext((String)chatSessionId, (Context)context);
            logger.info(String.format("\u3010GPT\u63d0\u793a-OpenAPI\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0crequestId:%s,\u6784\u5efa Context\uff1a%s", requestId, JSON.toJSONString((Object)context)));
        }
        if (Objects.isNull(prampt = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)promptNumber)}))) {
            return MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PRAMPT_NO_EXIET_ERROR);
        }
        long promptId = prampt.getLong("id");
        GPTLicenseHelper.checkLic((String)"gai_prompt", (Long)promptId);
        APILLMMessage message = new APILLMMessage();
        message.setParamMap(varParams);
        message.setPromptId(promptId);
        message.setUserInput(input);
        message.setStream(isStream);
        message.setRepoIdList(repoIds);
        message.setUseKnowledgeTopK(useKnowledgeTopK);
        Result result = HandlerFactory.runHandler((Context)context, (Message)message);
        logger.info("\u3010GPT\u63d0\u793a-OpenAPI\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528({})-\u7ed3\u675f\uff0crequestId: %s,LLM \u7ed3\u679c\uff1a%s", new Object[]{opDesc, requestId, JSON.toJSONString((Object)result)});
        return MserviceResultHelper.build((String)requestId, (Result)result);
    }

    public Map<String, Object> syncCall(boolean isStream, String promptNumber, String input, Map<String, String> varParams) {
        Long startTime = System.currentTimeMillis();
        String requestId = APIResultHelper.buildRequestId();
        DynamicObject prampt = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)promptNumber)});
        if (Objects.isNull(prampt)) {
            return MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PRAMPT_NO_EXIET_ERROR);
        }
        long promptId = prampt.getLong("id");
        GPTLicenseHelper.checkLic((String)"gai_prompt", (Long)promptId);
        APILLMMessage message = new APILLMMessage();
        message.setParamMap(varParams);
        message.setPromptId(promptId);
        message.setUserInput(input);
        message.setStream(isStream);
        Context context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (long)0L, null, null, null, null);
        Result result = HandlerFactory.runHandler((Context)context, (Message)message);
        logger.info(String.format("\u3010GPT\u63d0\u793a-OpenAPI\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u7ed3\u675f\uff0crequestId: %s,LLM \u7ed3\u679c\uff1a%s", requestId, JSON.toJSONString((Object)result)));
        APIDetailService.insert((String)"002", (long)(System.currentTimeMillis() - startTime), (String)result.getErrorCode().getCode(), (String)context.getChatSessionId());
        return MserviceResultHelper.build((String)requestId, (Result)result);
    }
}

