/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.domain.dto.repo.GaiRepoData;
import kd.ai.gai.core.domain.mservice.GaiDBRepoAddGroupChunkDataParams;
import kd.ai.gai.core.domain.mservice.GaiDBRepoDelChunkParams;
import kd.ai.gai.core.domain.mservice.GaiRagSearchParams;
import kd.ai.gai.core.domain.mservice.GaiRepoAddFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoAddGroupDataParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateDBParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateParams;
import kd.ai.gai.core.domain.mservice.GaiRepoDelFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoDelGroupParams;
import kd.ai.gai.core.domain.vo.AddRepoGroupDatasVO;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.helper.RagHelper;
import kd.ai.gai.core.rag.service.RagService;
import kd.ai.gai.mservice.GaiRagService;
import kd.ai.gai.util.GaiMServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiRagServiceImpl
implements GaiRagService {
    private static final Log logger = LogFactory.getLog(GaiRagServiceImpl.class);
    private static final RepoServiceCallType METHOD_DESC = RepoServiceCallType.MSERVICE;

    public Map<String, Object> createRepo(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoCreateParams params = (GaiRepoCreateParams)JsonUtil.fromJson((String)paramsJson, GaiRepoCreateParams.class);
            RepoDataInfo repo = RagHelper.createRepo((RepoServiceCallType)METHOD_DESC, (GaiRepoCreateParams)params);
            Object convertResult = GaiMServiceUtils.pojoToObject(repo.getRepoId());
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryRepoInfo(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoData repoDTO = RagHelper.queryRepoInfo((RepoServiceCallType)METHOD_DESC, (long)repoId);
            Object convertResult = GaiMServiceUtils.pojoToObject(repoDTO);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryRepoFilesInfo(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            List repoFilesInfos = RagHelper.queryRepoFilesInfo((RepoServiceCallType)METHOD_DESC, (long)repoId);
            Object convertResult = GaiMServiceUtils.pojoToObject(repoFilesInfos);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryIndexMethod() {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            List gaiEmbeddings = RagHelper.queryIndexMethod((RepoServiceCallType)METHOD_DESC);
            Object convertResult = GaiMServiceUtils.pojoToObject(gaiEmbeddings);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> addRepoFiles(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoAddFileParams params = (GaiRepoAddFileParams)JsonUtil.fromJson((String)paramsJson, GaiRepoAddFileParams.class);
            boolean success = RagHelper.addRepoFiles((RepoServiceCallType)METHOD_DESC, (GaiRepoAddFileParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> createDBRepo(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoCreateDBParams params = (GaiRepoCreateDBParams)JsonUtil.fromJson((String)paramsJson, GaiRepoCreateDBParams.class);
            RepoDataInfo repo = RagHelper.createRepoByDatabase((RepoServiceCallType)METHOD_DESC, (GaiRepoCreateDBParams)params);
            Object convertResult = GaiMServiceUtils.pojoToObject(repo);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> deleteRepoById(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoById((RepoServiceCallType)METHOD_DESC, (long)repoId);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> deleteRepoFiles(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoDelFileParams params = (GaiRepoDelFileParams)JsonUtil.fromJson((String)paramsJson, GaiRepoDelFileParams.class);
            boolean success = RagHelper.deleteRepoFiles((RepoServiceCallType)METHOD_DESC, (GaiRepoDelFileParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> queryDBRepoGroupDatas(long repoId) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            List repoFilesInfos = RagHelper.queryRepoGroupDatasInfo((RepoServiceCallType)METHOD_DESC, (long)repoId);
            Object convertResult = GaiMServiceUtils.pojoToObject(repoFilesInfos);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> addDBRepoGroupDatas(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoAddGroupDataParams params = (GaiRepoAddGroupDataParams)JsonUtil.fromJson((String)paramsJson, GaiRepoAddGroupDataParams.class);
            AddRepoGroupDatasVO addRepoGroupDatasVO = RagHelper.addRepoGroupDatas((RepoServiceCallType)METHOD_DESC, (GaiRepoAddGroupDataParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)addRepoGroupDatasVO);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> addDBRepoGroupChunks(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiDBRepoAddGroupChunkDataParams params = (GaiDBRepoAddGroupChunkDataParams)JsonUtil.fromJson((String)paramsJson, GaiDBRepoAddGroupChunkDataParams.class);
            boolean success = RagHelper.addRepoGroupChunkDatas((RepoServiceCallType)METHOD_DESC, (GaiDBRepoAddGroupChunkDataParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> delDBRepoGroupDatas(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoDelGroupParams params = (GaiRepoDelGroupParams)JsonUtil.fromJson((String)paramsJson, GaiRepoDelGroupParams.class);
            boolean success = RagHelper.deleteRepoGroupDatas((RepoServiceCallType)METHOD_DESC, (GaiRepoDelGroupParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> delDBRepoChunkDatas(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiDBRepoDelChunkParams params = (GaiDBRepoDelChunkParams)JsonUtil.fromJson((String)paramsJson, GaiDBRepoDelChunkParams.class);
            boolean success = RagHelper.deleteDBRepoChunkDatas((RepoServiceCallType)METHOD_DESC, (GaiDBRepoDelChunkParams)params);
            resp = MserviceResultHelper.buildOk((String)requestId, (Object)success);
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    public Map<String, Object> search(String paramsJson) {
        Map resp;
        String requestId = MserviceResultHelper.buildRequestId();
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRagSearchParams searchParams = (GaiRagSearchParams)JsonUtil.fromJson((String)paramsJson, GaiRagSearchParams.class);
            List datas = RagService.search((RepoServiceCallType)METHOD_DESC, (GaiRagSearchParams)searchParams);
            if (datas == null || datas.size() <= 0) {
                resp = MserviceResultHelper.buildOk((String)requestId, (Object)datas, (String)"\u672c\u6b21\u68c0\u7d22\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u679c");
            } else {
                Object convertResult = GaiMServiceUtils.pojoToObject(datas);
                resp = MserviceResultHelper.buildOk((String)requestId, (Object)convertResult);
            }
        }
        catch (Throwable e) {
            resp = this.buildErrorResult(requestId, e);
        }
        return resp;
    }

    private Map<String, Object> buildErrorResult(String requestId, Throwable e) {
        ErrorCode errorCode;
        Map resp = e instanceof KDException ? (Objects.nonNull(errorCode = ((KDException)e).getErrorCode()) ? MserviceResultHelper.buildErr((String)requestId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR)) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR);
        logger.error("\u3010GPT-\u5fae\u670d\u52a1\u63a5\u53e3\u3011\u5f02\u5e38\uff0crequestId:{},errMsg:{}", new Object[]{requestId, JSON.toJSONString((Object)resp), e});
        return resp;
    }
}

