/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import kd.ai.gai.core.domain.mservice.GaiSKVectorSearchParam;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.repo.SearchType;
import kd.ai.gai.core.search.dto.CreateRepoResDTO;
import kd.ai.gai.core.search.dto.RepoSchemaDTO;
import kd.ai.gai.core.search.helper.KnowledgeRepoServiceHelper;
import kd.ai.gai.core.search.helper.StructuredRepoServiceHelper;
import kd.ai.gai.core.search.index.param.structured.SearchStructuredDataParam;
import kd.ai.gai.core.search.index.param.structured.SearchTargetDataParam;
import kd.ai.gai.core.search.index.param.structured.StructuredRowData;
import kd.ai.gai.core.search.param.schema.AddFieldParam;
import kd.ai.gai.core.search.param.schema.DelKnoSchemaParam;
import kd.ai.gai.core.search.param.schema.SaveKnoSchemaParam;
import kd.ai.gai.mservice.GaiSKService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiSKServiceImpl
implements GaiSKService {
    private static final Log logger = LogFactory.getLog(GaiSKServiceImpl.class);

    public String saveSchema(String s) {
        SaveKnoSchemaParam saveKnoSchemaParam = (SaveKnoSchemaParam)JSON.parseObject((String)s, SaveKnoSchemaParam.class);
        CreateRepoResDTO createRepoResDTO = KnowledgeRepoServiceHelper.getRepoService().saveSchema(saveKnoSchemaParam);
        if (createRepoResDTO == null) {
            return null;
        }
        return createRepoResDTO.getSchemaNumber();
    }

    public boolean schemaExist(String schemaNumber) {
        return KnowledgeRepoServiceHelper.getRepoService().schemaExist(schemaNumber);
    }

    public void delSchema(String schemaNumber) {
        DelKnoSchemaParam delKnoSchemaParam = new DelKnoSchemaParam();
        delKnoSchemaParam.setSchemaNumber(schemaNumber);
        KnowledgeRepoServiceHelper.getRepoService().delSchema(delKnoSchemaParam);
    }

    public void addFieldToSchema(String s) {
        AddFieldParam addFieldParam = (AddFieldParam)JSON.parseObject((String)s, AddFieldParam.class);
        KnowledgeRepoServiceHelper.getRepoService().addFieldToRepo(addFieldParam);
    }

    public String getSchemaBySchemaNumber(String schemaNumber) {
        RepoSchemaDTO repoSchemaDTO = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaNumber(schemaNumber);
        return GaiSKServiceImpl.transToJsonStr(repoSchemaDTO);
    }

    public String getSchemaByRepoId(Long repoId) {
        RepoSchemaDTO repoSchemaDTO = KnowledgeRepoServiceHelper.getRepoService().getSchemaByRepoId(repoId);
        return GaiSKServiceImpl.transToJsonStr(repoSchemaDTO);
    }

    public String getSchemaByRepoNumber(String repoNumber) {
        RepoSchemaDTO repoSchemaDTO = KnowledgeRepoServiceHelper.getRepoService().getSchemaByRepoNum(repoNumber);
        return GaiSKServiceImpl.transToJsonStr(repoSchemaDTO);
    }

    private static String transToJsonStr(RepoSchemaDTO repoSchemaDTO) {
        if (repoSchemaDTO == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("vectorModel", repoSchemaDTO.getVectorModel());
        result.put("schemaNumber", repoSchemaDTO.getSchemaNumber());
        result.put("schemaName", repoSchemaDTO.getSchemaName());
        result.put("repoType", repoSchemaDTO.getRepoType());
        result.put("repoNumber", repoSchemaDTO.getRepoNumber());
        result.put("repoName", repoSchemaDTO.getRepoName());
        result.put("repoId", repoSchemaDTO.getRepoId());
        result.put("fields", repoSchemaDTO.getFields());
        result.put("dataSrcNumber", repoSchemaDTO.getDataSrcNumber());
        result.put("tokenizerType", repoSchemaDTO.getTokenizerType());
        result.put("external", repoSchemaDTO.getExternal());
        return JSON.toJSONString(result);
    }

    public String search(String s) {
        String repoSchemaNumber = JSON.parseObject((String)s).getString("repoSchemaNumber");
        RepoSchemaDTO repoSchemaDTO = KnowledgeRepoServiceHelper.getRepoService().getSchemaBySchemaNumber(repoSchemaNumber);
        SearchStructuredDataParam searchStructuredDataParam = (SearchStructuredDataParam)JSON.parseObject((String)s, SearchStructuredDataParam.class);
        searchStructuredDataParam.setRepoSchemaId(repoSchemaDTO.getSchemaId());
        StructuredRowData search = StructuredRepoServiceHelper.search((SearchStructuredDataParam)searchStructuredDataParam);
        return JSON.toJSONString((Object)search);
    }

    public String vectorSearch(String param) {
        GaiSKVectorSearchParam vectorSearchParam = (GaiSKVectorSearchParam)JsonUtil.fromJson((String)param, GaiSKVectorSearchParam.class);
        SearchTargetDataParam searchTargetDataParam = new SearchTargetDataParam(vectorSearchParam.getRepoSchemaNumber(), vectorSearchParam.getQuery(), vectorSearchParam.getTopK(), vectorSearchParam.getSimilarity(), SearchType.VECTOR);
        List searchTargetDataResults = StructuredRepoServiceHelper.vectorSearch((SearchTargetDataParam)searchTargetDataParam);
        return JsonUtil.toJson((Object)searchTargetDataResults);
    }

    public String keywordSearch(String param) {
        GaiSKVectorSearchParam vectorSearchParam = (GaiSKVectorSearchParam)JsonUtil.fromJson((String)param, GaiSKVectorSearchParam.class);
        SearchTargetDataParam searchTargetDataParam = new SearchTargetDataParam(vectorSearchParam.getRepoSchemaNumber(), vectorSearchParam.getQuery(), vectorSearchParam.getTopK(), vectorSearchParam.getSimilarity(), SearchType.KEYWORD);
        List searchTargetDataResults = StructuredRepoServiceHelper.keywordSearch((SearchTargetDataParam)searchTargetDataParam);
        return JsonUtil.toJson((Object)searchTargetDataResults);
    }

    public String hybridSearch(String param) {
        GaiSKVectorSearchParam vectorSearchParam = (GaiSKVectorSearchParam)JsonUtil.fromJson((String)param, GaiSKVectorSearchParam.class);
        SearchTargetDataParam searchTargetDataParam = new SearchTargetDataParam(vectorSearchParam.getRepoSchemaNumber(), vectorSearchParam.getQuery(), vectorSearchParam.getTopK(), vectorSearchParam.getSimilarity(), SearchType.KEYWORD);
        List searchTargetDataResults = StructuredRepoServiceHelper.hybridSearch((SearchTargetDataParam)searchTargetDataParam);
        return JsonUtil.toJson((Object)searchTargetDataResults);
    }
}

