/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.ChatParams;
import kd.ai.gai.core.domain.dto.FeedParams;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.NewSessionParams;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.StopParams;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.service.GaiCosmicAppService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.mservice.GaiService;
import kd.ai.gai.util.GaiMServiceUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiServiceImpl
implements GaiService {
    private static final Log logger = LogFactory.getLog(GaiServiceImpl.class);
    private static final Random random = new SecureRandom();

    public void selectProcessInSideBar(long processId, String rootPageId, String assistant) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 selectProcessInSideBar : processId: {},rootPageId: {},assistant: {}", new Object[]{processId, rootPageId, assistant});
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        if (StringUtils.isNotEmpty((CharSequence)assistant)) {
            String taskId = random.nextLong() + "";
            PushMsgService.pushChat((Context)context, (String)taskId, (String)assistant, null);
        }
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        gaiInitConfig.setSelectedProcessId(processId + "");
        gaiInitConfig.setSwitchSide(Boolean.TRUE);
        gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        logger.info("user {} GAIAGTREE:{}", (Object)context.getUserId(), (Object)GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        PushMsgService.pushChangeConfig((Context)context, (GaiInitConfig)gaiInitConfig);
    }

    public void startProcessInSideBar(long processId, String rootPageId, Map<String, String> paramMap) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 startProcessInSideBar : processId: {},rootPageId: {}", (Object)processId, (Object)rootPageId);
        this.startProcess(processId, rootPageId, paramMap, null);
    }

    public void startProcessInSideBar(long processId, String rootPageId, Map<String, String> paramMap, String userInput) {
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 startProcessInSideBar : processId: {},rootPageId: {}", (Object)processId, (Object)rootPageId);
        this.startProcess(processId, rootPageId, paramMap, userInput);
    }

    public void sideBarInit(String rootPageId, String gaiInitConfigJson) {
        Process process;
        logger.info("Gai\u5fae\u670d\u52a1\u8c03\u7528 sideBarInit : gaiInitConfigJson: {},rootPageId: {}", (Object)gaiInitConfigJson, (Object)rootPageId);
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)gaiInitConfigJson)) {
            throw new KDBizException(Errors.M_SERVICE_ERROR, new Object[0]);
        }
        FlowCacheData.restoreRequestContext((String)rootPageIdContext.getChatSessionId());
        GaiInitConfig gaiInitConfig = (GaiInitConfig)JSON.parseObject((String)gaiInitConfigJson, GaiInitConfig.class);
        String startProcessNumber = gaiInitConfig.getStartProcessNumber();
        if (!StringUtils.isEmpty((CharSequence)startProcessNumber)) {
            this.startProcess(startProcessNumber, rootPageId, (Map<String, String>)gaiInitConfig.getStartParams(), gaiInitConfig.getUserInput());
        } else {
            String startProcessId = gaiInitConfig.getStartProcessId();
            if (!StringUtils.isEmpty((CharSequence)startProcessId)) {
                this.startProcess(Long.parseLong(startProcessId), rootPageId, (Map<String, String>)gaiInitConfig.getStartParams(), gaiInitConfig.getUserInput());
            }
        }
        String selectProcessNumber = gaiInitConfig.getSelectedProcessNumber();
        if (!StringUtils.isEmpty((CharSequence)selectProcessNumber) && (process = ProcessService.getProcessByNumber((String)selectProcessNumber)) != null) {
            gaiInitConfig.setStartProcessId(process.getId() + "");
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        logger.info("user2 {} GAIAGTREE:{}", (Object)context.getUserId(), (Object)GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
        PushMsgService.pushChangeConfig((Context)context, (GaiInitConfig)gaiInitConfig);
    }

    private void startProcess(String processNumber, String rootPageId, Map<String, String> paramMap, String userInput) {
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        ThreadUtils.execute(() -> GaiUtils.startProcess((String)processNumber, (Context)context, (Map)paramMap, (String)userInput));
    }

    private void startProcess(long processId, String rootPageId, Map<String, String> paramMap, String userInput) {
        if (StringUtils.isEmpty((CharSequence)rootPageId)) {
            throw new KDBizException(Errors.MSERVICE_NO_ROOT_PAGE_ID, new Object[0]);
        }
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
        if (null == rootPageIdContext) {
            throw new KDBizException(Errors.MSERVICE_NO_CHAT_SESSION_ID, new Object[0]);
        }
        Context context = FlowCacheData.getContext((String)rootPageIdContext.getChatSessionId());
        ThreadUtils.execute(() -> GaiUtils.startProcess((long)processId, (Context)context, (Map)paramMap, (String)userInput));
    }

    public String getAssistants(String s) {
        List assistantList = GaiCosmicAppService.getAssistants();
        ArrayList<HashMap<String, Object>> assMap = new ArrayList<HashMap<String, Object>>(10);
        long userId = RequestContext.get().getCurrUserId();
        List blgs = GaiLicenseUtils.getUserBLG((Long)userId);
        for (Assistant assistant : assistantList) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("type", assistant.getId() == 10000L ? "web" : "app");
            item.put("id", assistant.getId());
            item.put("name", assistant.getName());
            item.put("picture", assistant.getPicture());
            item.put("introduce", assistant.getIntroduce());
            item.put("openingSpeech", assistant.getOpeningSpeech());
            item.put("persona", assistant.getPersona());
            item.put("IsAllStaffAssistant", assistant.getAllStaff());
            List skillList = SkillService.getList((long)assistant.getId(), null, (List)blgs);
            if (skillList != null && !skillList.isEmpty()) {
                Skill skill = (Skill)skillList.get(0);
                this.fillSkillSuggestedAsk(item, skill);
                item.put("desc", skill.getServiceDes());
            }
            assMap.add(item);
        }
        return GaiMServiceUtils.buildOKRs(assMap, "\u83b7\u53d6\u6210\u529f");
    }

    private void fillSkillSuggestedAsk(Map<String, Object> item, Skill skill) {
        List suggestedAskDataList = skill.getSuggestedAsks();
        if (suggestedAskDataList != null && !suggestedAskDataList.isEmpty()) {
            List suggestedStringArr = suggestedAskDataList.stream().map(SuggestedAskData::getName).collect(Collectors.toList());
            item.put("suggestedask", suggestedStringArr);
            JSONArray suggestedaskJa = new JSONArray();
            for (SuggestedAskData suggestedAskData : suggestedAskDataList) {
                JSONObject suggestedaskJo = new JSONObject();
                List attachmentList = new ArrayList();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)suggestedAskData.getFileIds())) {
                    List<String> fileIdList = Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)suggestedAskData.getFileIds(), (String)","));
                    attachmentList = FileService.queryAttachmentList(fileIdList);
                }
                suggestedaskJo.put("question", (Object)suggestedAskData.getName());
                suggestedaskJo.put("attachmentList", attachmentList);
                suggestedaskJa.add((Object)suggestedaskJo);
            }
            item.put("suggestedaskList", suggestedaskJa);
        }
    }

    public String newSession(String s) {
        NewSessionParams newSessionParams = (NewSessionParams)JSON.parseObject((String)s, NewSessionParams.class);
        Map rs = GaiCosmicAppService.newSession((NewSessionParams)newSessionParams);
        return GaiMServiceUtils.buildOKRs(rs, "\u83b7\u53d6\u6210\u529f");
    }

    public String chat(String s) {
        ChatParams chatParams = (ChatParams)JSON.parseObject((String)s, ChatParams.class);
        try {
            Map rs = GaiCosmicAppService.chat((ChatParams)chatParams);
            return GaiMServiceUtils.buildOKRs(rs, "\u83b7\u53d6\u6210\u529f");
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            ErrorCode errorCode = e.getErrorCode();
            return GaiMServiceUtils.buildErrRs(errorCode.getCode(), errorCode.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return GaiMServiceUtils.buildErrRs("-202", "\u83b7\u53d6\u5f02\u5e38");
        }
    }

    public void feedBack(String s) {
        FeedParams feedParams = (FeedParams)JSON.parseObject((String)s, FeedParams.class);
        GaiCosmicAppService.feedBack((FeedParams)feedParams);
    }

    public String stopChat(String s) {
        StopParams stopParams = (StopParams)JSON.parseObject((String)s, StopParams.class);
        String rs = GaiCosmicAppService.stopChat((StopParams)stopParams);
        return GaiMServiceUtils.buildOKRs(rs, "\u83b7\u53d6\u6210\u529f");
    }
}

