/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.domain.dto.agent.CosmicAction;
import kd.ai.gai.core.domain.dto.agent.RestfulAPI;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.service.agent.CosmicActionService;
import kd.ai.gai.core.service.agent.OpenAPIService;
import kd.ai.gai.core.service.agent.RestfulAPIService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.mservice.GaiToolService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiToolServiceImpl
implements GaiToolService {
    private static final Log logger = LogFactory.getLog(GaiToolServiceImpl.class);

    public String call(String paramsJson) {
        logger.info(String.format("\u3010Agent \u5e73\u53f0-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5de5\u5177\u8c03\u7528\uff0cparamsJson\uff1a%s", paramsJson));
        DynamicObject tool = this.validateParams(paramsJson);
        try {
            String toolType = tool.getString("tool_type");
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType())) {
                JSONObject paramObj = JSONObject.parseObject((String)paramsJson);
                ThirdOpenAPI api = (ThirdOpenAPI)paramObj.toJavaObject(ThirdOpenAPI.class);
                api.setChatSessionId(paramObj.getString("chatSessionId"));
                api.setRunId(paramObj.getLong("runId"));
                BaseResult br = OpenAPIService.getService().call(api);
                return JSONObject.toJSONString((Object)br);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.COSMIC_ACTION.getType())) {
                JSONObject paramObj = JSONObject.parseObject((String)paramsJson);
                CosmicAction ca = (CosmicAction)paramObj.toJavaObject(CosmicAction.class);
                ca.setChatSessionId(paramObj.getString("chatSessionId"));
                ca.setRunId(paramObj.getLong("runId"));
                BaseResult br = CosmicActionService.call((CosmicAction)ca);
                return JSONObject.toJSONString((Object)br);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.RESTFUL_API.getType())) {
                JSONObject paramObj = JSONObject.parseObject((String)paramsJson);
                RestfulAPI api = (RestfulAPI)paramObj.toJavaObject(RestfulAPI.class);
                api.setChatSessionId(paramObj.getString("chatSessionId"));
                api.setRunId(paramObj.getLong("runId"));
                BaseResult br = RestfulAPIService.getService().call(api);
                return JSONObject.toJSONString((Object)br);
            }
            return JSONObject.toJSONString((Object)new BaseResult());
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private DynamicObject validateParams(String paramsJson) {
        String operationId;
        if (StringUtils.isEmpty((CharSequence)paramsJson)) {
            throw new KDBizException("request parameter empty\uff0cplease check and try again\u3002");
        }
        JSONObject paramObj = JSONObject.parseObject((String)paramsJson);
        Long toolId = paramObj.getLong("toolId");
        if (toolId == null || toolId == 0L) {
            throw new KDBizException("request parameter toolId error\uff0cplease check and try again\u3002");
        }
        JSONObject toolParams = paramObj.getJSONObject("toolParams");
        if (toolParams == null) {
            throw new KDBizException("request parameter toolParams error\uff0cplease check and try again\u3002");
        }
        DynamicObject tool = BusinessDataServiceHelper.loadSingle((Object)toolId, (String)"gai_tool");
        if (tool == null) {
            throw new KDBizException("tool is not exist\uff0cplease check and try again\u3002");
        }
        String toolType = tool.getString("tool_type");
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
            throw new KDBizException("don't support call agent preset tool\uff0cplease check and try again\u3002");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.THIRD_OPENAPI.getType()) && StringUtils.isEmpty((CharSequence)(operationId = toolParams.getString("operationId")))) {
            throw new KDBizException("request parameter operationId error\uff0cplease check and try again\u3002");
        }
        return tool;
    }
}

