/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.openapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.ChatParams;
import kd.ai.gai.core.domain.dto.FeedParams;
import kd.ai.gai.core.domain.dto.NewSessionParams;
import kd.ai.gai.core.domain.dto.StopParams;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.service.APIDetailService;
import kd.ai.gai.core.service.GaiCosmicAppService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;

@ApiController(value="gai", desc="\u83b7\u53d6\u52a9\u624b\u5217\u8868")
@ApiHeaders(value={@ApiHeader(name="clientType", desc="\u8bf7\u6c42\u6765\u6e90", example="COSMIC_APP")})
@ApiMapping(value="")
public class GaiCosmicAppController
implements Serializable {
    private Log log = LogFactory.getLog(GaiCosmicAppController.class);

    @ApiPostMapping(value="/assistants")
    public CustomApiResult<List<Map<String, Object>>> getAssistants() {
        long startTime = System.currentTimeMillis();
        List assistantList = GaiCosmicAppService.getAssistants();
        ArrayList<HashMap<String, Object>> assMap = new ArrayList<HashMap<String, Object>>(10);
        long userId = RequestContext.get().getCurrUserId();
        List blgs = GaiLicenseUtils.getUserBLG((Long)userId);
        for (Assistant assistant : assistantList) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("type", assistant.getId() == 10000L ? "web" : "app");
            item.put("id", assistant.getId());
            item.put("name", assistant.getName());
            item.put("number", assistant.getNumber());
            item.put("picture", assistant.getPicture());
            item.put("introduce", assistant.getIntroduce());
            item.put("openingSpeech", assistant.getOpeningSpeech());
            item.put("persona", assistant.getPersona());
            item.put("IsAllStaffAssistant", assistant.getAllStaff());
            List skillList = SkillService.getList((long)assistant.getId(), null, (List)blgs);
            if (!skillList.isEmpty()) {
                Skill skill = (Skill)skillList.get(0);
                this.fillSkillSuggestedAsk(item, skill);
                item.put("desc", skill.getServiceDes());
            }
            assMap.add(item);
        }
        APIDetailService.insert((String)"012", (long)(System.currentTimeMillis() - startTime), (String)"0", (String)"");
        return CustomApiResult.success(assMap);
    }

    private void fillSkillSuggestedAsk(Map<String, Object> item, Skill skill) {
        List suggestedAskDataList = skill.getSuggestedAsks();
        if (suggestedAskDataList != null && !suggestedAskDataList.isEmpty()) {
            List suggestedStringArr = suggestedAskDataList.stream().map(SuggestedAskData::getName).collect(Collectors.toList());
            item.put("suggestedask", suggestedStringArr);
            JSONArray suggestedaskJa = new JSONArray();
            for (SuggestedAskData suggestedAskData : suggestedAskDataList) {
                JSONObject suggestedaskJo = new JSONObject();
                List attachmentList = new ArrayList();
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)suggestedAskData.getFileIds())) {
                    List<String> fileIdList = Arrays.asList(org.apache.commons.lang3.StringUtils.split((String)suggestedAskData.getFileIds(), (String)","));
                    attachmentList = FileService.queryAttachmentList(fileIdList);
                }
                suggestedaskJo.put("question", (Object)suggestedAskData.getName());
                suggestedaskJo.put("attachmentList", attachmentList);
                suggestedaskJa.add((Object)suggestedaskJo);
            }
            item.put("suggestedaskList", suggestedaskJa);
        }
    }

    @ApiPostMapping(value="/newsession")
    public CustomApiResult<Map<String, Object>> newSession(@ApiRequestBody(value="\u65b0\u4f1a\u8bdd\u53c2\u6570") NewSessionParams newSessionParams) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isEmpty((CharSequence)newSessionParams.getClientType())) {
            Map reqHeader = ServiceApiContext.getRequest().getRequestHeaders();
            String clientType = reqHeader.getOrDefault("clientType", "cosmicPC");
            newSessionParams.setClientType(clientType);
        }
        Map rs = GaiCosmicAppService.newSession((NewSessionParams)newSessionParams);
        APIDetailService.insert((String)"013", (long)(System.currentTimeMillis() - startTime), (String)"0", (String)rs.get("sessionId").toString());
        return CustomApiResult.success((Object)rs);
    }

    @ApiPostMapping(value="/feedback")
    public CustomApiResult<String> feedback(@ApiRequestBody(value="\u4f1a\u8bdd\u53c2\u6570") FeedParams feedParams) {
        return CustomApiResult.success((Object)GaiCosmicAppService.feedBack((FeedParams)feedParams));
    }

    @ApiPostMapping(value="/chat")
    public CustomApiResult<Map<String, Object>> chat(@ApiRequestBody(value="\u4f1a\u8bdd\u53c2\u6570") ChatParams chatParams) {
        long startTime = System.currentTimeMillis();
        Map rs = GaiCosmicAppService.chat((ChatParams)chatParams);
        APIDetailService.insert((String)"014", (long)(System.currentTimeMillis() - startTime), (String)"0", (String)chatParams.getSessionId());
        return CustomApiResult.success((Object)rs);
    }

    @ApiPostMapping(value="/chat/stop")
    public CustomApiResult<String> stopChat(@ApiRequestBody(value="\u505c\u6b62\u4f1a\u8bdd") StopParams stopParams) {
        long startTime = System.currentTimeMillis();
        String rs = GaiCosmicAppService.stopChat((StopParams)stopParams);
        APIDetailService.insert((String)"015", (long)(System.currentTimeMillis() - startTime), (String)"0", (String)stopParams.getSessionId());
        return CustomApiResult.success((Object)rs);
    }
}

