/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.openapi;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.domain.dto.repo.GaiEmbeddingData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoData;
import kd.ai.gai.core.domain.dto.repo.GaiRepoFileData;
import kd.ai.gai.core.domain.mservice.GaiRagSearchParams;
import kd.ai.gai.core.domain.mservice.GaiRepoAddFileParams;
import kd.ai.gai.core.domain.mservice.GaiRepoCreateParams;
import kd.ai.gai.core.domain.mservice.GaiRepoDelFileParams;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.enuz.repo.RepoServiceCallType;
import kd.ai.gai.core.helper.RagHelper;
import kd.ai.gai.core.rag.service.RagService;
import kd.ai.gai.core.service.APIDetailService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.core.trace.util.PermUtils;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiHeader;
import kd.bos.openapi.common.custom.annotation.ApiHeaders;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.util.StringUtils;

@ApiController(value="gai", desc="RAG-\u77e5\u8bc6\u5e93\u63a5\u53e3")
@ApiMapping(value="/rag/repo")
public class RagRepoServiceController
implements Serializable {
    private static final Log logger = LogFactory.getLog(RagRepoServiceController.class);
    private static final RepoServiceCallType METHOD_DESC = RepoServiceCallType.OPENAPI;
    public static final String PERM_QUERY = "QXX0001";
    public static final String PERM_ADD = "QXX0002";
    public static final String PERM_DEL = "QXX0004";

    @ApiPostMapping(value="/queryIndexMethod", desc="\u67e5\u8be2\u53ef\u7528\u7d22\u5f15\u65b9\u5f0f\uff08embedding \u6a21\u578b\uff09\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody List<GaiEmbeddingData>> queryIndexMethod() {
        CustomApiResult result;
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List gaiEmbeddings = RagHelper.queryIndexMethod((RepoServiceCallType)METHOD_DESC);
            result = CustomApiResult.success((Object)gaiEmbeddings);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"009", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/createRepo", desc="\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody RepoDataInfo> createRepo(@ApiRequestBody GaiRepoCreateParams createParams) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_ADD);
        logger.info("OpenAPI \u8c03\u7528\uff0ccreateRepo\uff0c\u662f\u5426\u6709\u65b0\u589e\u77e5\u8bc6\u5e93\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u65b0\u589e\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RepoDataInfo repoDataInfo = RagHelper.createRepo((RepoServiceCallType)METHOD_DESC, (GaiRepoCreateParams)createParams);
            result = CustomApiResult.success((Object)repoDataInfo);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"003", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/queryRepoInfo", desc="\u67e5\u8be2\u77e5\u8bc6\u5e93\u4fe1\u606f\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody GaiRepoData> queryRepoInfo(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_QUERY);
        logger.info("OpenAPI \u8c03\u7528\uff0cqueryRepoInfo\uff0c\u662f\u5426\u6709\u67e5\u8be2\u77e5\u8bc6\u5e93\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u67e5\u8be2\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            GaiRepoData repoDTO = RagHelper.queryRepoInfo((RepoServiceCallType)METHOD_DESC, (long)repoId);
            result = CustomApiResult.success((Object)repoDTO);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"005", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/queryRepoFilesInfo", desc="\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u5217\u8868\u4fe1\u606f\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody List<GaiRepoFileData>> queryRepoFilesInfo(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_QUERY);
        logger.info("OpenAPI \u8c03\u7528\uff0cqueryRepoFilesInfo\uff0c\u662f\u5426\u6709\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u4fe1\u606f\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u67e5\u8be2\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List repoFilesInfos = RagHelper.queryRepoFilesInfo((RepoServiceCallType)METHOD_DESC, (long)repoId);
            result = CustomApiResult.success((Object)repoFilesInfos);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"004", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/addRepoFiles", desc="\u65b0\u589e\u77e5\u8bc6\u5e93\u6587\u4ef6")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> addRepoFiles(@ApiRequestBody GaiRepoAddFileParams params) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_ADD);
        logger.info("OpenAPI \u8c03\u7528\uff0caddRepoFiles\uff0c\u662f\u5426\u6709\u65b0\u589e\u77e5\u8bc6\u5e93\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u65b0\u589e\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            boolean success = RagHelper.addRepoFiles((RepoServiceCallType)METHOD_DESC, (GaiRepoAddFileParams)params);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"008", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/deleteRepoById", desc="\u5220\u9664\u6587\u672c\u95ee\u7b54\u77e5\u8bc6\u5e93\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> deleteRepoById(@ApiParam(value="\u77e5\u8bc6\u5e93ID") @ApiParam(value="\u77e5\u8bc6\u5e93ID") long repoId) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_DEL);
        logger.info("OpenAPI \u8c03\u7528\uff0cdeleteRepoById\uff0c\u662f\u5426\u6709\u5220\u9664\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u5220\u9664\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoById((RepoServiceCallType)METHOD_DESC, (long)repoId);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"006", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/deleteRepoFiles", desc="\u5220\u9664\u77e5\u8bc6\u5e93\u6587\u672c\u5217\u8868\u6587\u4ef6\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> deleteRepoFiles(@ApiRequestBody GaiRepoDelFileParams params) {
        CustomApiResult result;
        boolean flag = RagRepoServiceController.hasPermission(PERM_DEL);
        logger.info("OpenAPI \u8c03\u7528\uff0cdeleteRepoFiles\uff0c\u662f\u5426\u6709\u5220\u9664\u6743\u9650\uff1a{}", (Object)flag);
        if (!flag) {
            return CustomApiResult.fail((String)BaseResult.FAILED, (String)"\u65e0\u5220\u9664\u6743\u9650");
        }
        long startTime = System.currentTimeMillis();
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            boolean success = RagHelper.deleteRepoFiles((RepoServiceCallType)METHOD_DESC, (GaiRepoDelFileParams)params);
            result = CustomApiResult.success((Object)success);
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        String errCode = StringUtils.isEmpty((String)result.getErrorCode()) ? "0" : result.getErrorCode();
        APIDetailService.insert((String)"007", (long)(System.currentTimeMillis() - startTime), (String)errCode, (String)"");
        return result;
    }

    @ApiPostMapping(value="/search", desc="\u77e5\u8bc6\u5e93\u68c0\u7d22\u63a5\u53e3")
    @ApiHeaders(value={@ApiHeader(name="X-Request-Id", desc="\u4e1a\u52a1\u8bf7\u6c42ID")})
    public CustomApiResult<@ApiResponseBody Boolean> search(@ApiRequestBody GaiRagSearchParams params) {
        CustomApiResult result;
        Map headers = ServiceApiContext.getRequest().getRequestHeaders();
        String requestId = (String)headers.get("X-Request-Id");
        try {
            RequestContext.get().setRequestId(requestId);
            List dataList = RagService.search((RepoServiceCallType)METHOD_DESC, (GaiRagSearchParams)params);
            result = CustomApiResult.success((Object)dataList);
            if (dataList == null || dataList.size() <= 0) {
                result.setMessage("\u672c\u6b21\u68c0\u7d22\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = this.buildErrorResult(requestId, e);
        }
        return result;
    }

    private CustomApiResult buildErrorResult(String requestId, Exception e) {
        ErrorCode errorCode;
        CustomApiResult result = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)e).getErrorCode()) ? CustomApiResult.fail((String)errorCode.getCode(), (String)errorCode.getMessage()) : CustomApiResult.fail((String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getCode(), (String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getMsg())) : CustomApiResult.fail((String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getCode(), (String)GaiErrorCode.OPENAPI_RAG_REPO_PARAMS_ERR.getMsg());
        logger.error("\u3010GPT-OpenAPI\u63a5\u53e3\u3011\u5f02\u5e38\uff0crequestId:{},errMsg:{}", new Object[]{requestId, JSON.toJSONString((Object)result), e});
        return result;
    }

    private static boolean hasPermission(String permKey) {
        return PermUtils.hasPermission((String)permKey, (String)"gai_repo_info");
    }
}

