/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.sse.chatservice;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.ChatParams;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.service.GaiCosmicAppService;
import kd.ai.gai.core.sse.cache.SSEIteratorCache;
import kd.ai.gai.core.sse.iterator.AbstractSSEIterator;
import kd.ai.gai.core.sse.iterator.ChatIterator;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.sse.chatservice.AbstractSSEService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Chat
extends AbstractSSEService {
    private static final Log logger = LogFactory.getLog(Chat.class);

    private void verifyParams(ChatParams chatParams) {
        List collect;
        List skillList;
        if (StringUtils.isEmpty((CharSequence)chatParams.getSessionId())) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_LESS);
            return;
        }
        Context context = FlowCacheData.getContext((String)chatParams.getSessionId());
        if (StringUtils.isBlank((CharSequence)context.getChatSessionId())) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_SESSIONID_EXPIRE);
            return;
        }
        if (context.getUserId() != RequestContext.get().getCurrUserId()) {
            throw new KDBizException(Errors.ASSISTANT_USER_ERROR, new Object[0]);
        }
        ChatParams.Message message = chatParams.getMessage();
        if (message == null) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_LESS);
            return;
        }
        String skillId = message.getSkillId();
        if (!StringUtils.isEmpty((CharSequence)skillId) && (skillList = context.getSkillList()) != null && !skillList.isEmpty() && (collect = skillList.stream().filter(v -> skillId.equals(v.getId())).collect(Collectors.toList())).isEmpty()) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_PERMISSION);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)message.getQuery())) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_LESS);
        }
    }

    @Override
    public void run(String requestJson, AbstractSSEIterator blockingIterator) {
        ChatParams chatParams = (ChatParams)JSON.parseObject((String)requestJson, ChatParams.class);
        String chatSessionID = chatParams.getSessionId();
        try {
            if (!StrUtils.isValidJSONObject((String)requestJson)) {
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_INVALID);
                return;
            }
            this.verifyParams(chatParams);
            SSEIteratorCache.put((String)chatParams.getSessionId(), (String)RequestContext.get().getTraceId(), (AbstractSSEIterator)blockingIterator);
            GaiCosmicAppService.chat((ChatParams)chatParams);
        }
        catch (Exception ex) {
            Map errResult;
            logger.error("sse.chatservice.chat:", (Throwable)ex);
            Context context = FlowCacheData.getContext((String)chatSessionID);
            if (context == null) {
                context = new Context();
            }
            if (ex instanceof KDException) {
                errResult = ResultVoHelper.buildErrMsg((ErrorCode)((KDException)((Object)ex)).getErrorCode(), (String)chatSessionID, (Context)context);
            } else {
                String sErrMessage = ex.getMessage();
                if (StringUtils.isEmpty((CharSequence)sErrMessage)) {
                    sErrMessage = ex.toString();
                }
                ErrorCode errorCode = new ErrorCode(GaiErrorCode.SSE_ERROR_UNKHNOW.getCode(), String.format(GaiErrorCode.SSE_ERROR_UNKHNOW.getMsg(), sErrMessage));
                errResult = ResultVoHelper.buildErrMsg((ErrorCode)errorCode, (String)chatSessionID, (Context)context);
            }
            blockingIterator.put((Object)JSON.toJSONString((Object)errResult));
            blockingIterator.finish();
            SSEIteratorCache.finish((String)chatSessionID, (String)RequestContext.get().getTraceId());
        }
    }

    @Override
    protected AbstractSSEIterator newSSEIterator() {
        return new ChatIterator(300000);
    }
}

