/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.sse.chatservice;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.PromptParams;
import kd.ai.gai.core.engine.APILLMData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.sse.cache.SSEIteratorCache;
import kd.ai.gai.core.sse.iterator.AbstractSSEIterator;
import kd.ai.gai.core.sse.iterator.PromptIterator;
import kd.ai.gai.mservice.GaiPromptOpenAPIServiceImpl;
import kd.ai.gai.sse.chatservice.AbstractSSEService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Prompt
extends AbstractSSEService {
    private static final Log logger = LogFactory.getLog(Prompt.class);

    @Override
    public void run(String requestJson, AbstractSSEIterator blockingIterator) {
        String chatSessionID = "";
        APILLMData apillmData = new APILLMData();
        try {
            PromptParams promptParams = (PromptParams)JSON.toJavaObject((JSON)JSON.parseObject((String)requestJson), PromptParams.class);
            this.verifyParams(promptParams);
            apillmData.setStream(promptParams.isStream());
            chatSessionID = promptParams.getSessionId();
            apillmData.setSessionId(chatSessionID);
            SSEIteratorCache.put((String)promptParams.getSessionId(), (String)RequestContext.get().getTraceId(), (AbstractSSEIterator)blockingIterator);
            GaiPromptOpenAPIServiceImpl promptOpenAPIService = new GaiPromptOpenAPIServiceImpl();
            Map<String, Object> result = promptOpenAPIService.syncCallUseDynamicRepoTopK(chatSessionID, promptParams.isStream(), promptParams.getPromptNumber(), promptParams.getInput(), promptParams.getVarParams(), promptParams.getRepoIds(), promptParams.getUseKnowledgeTopK());
            if (result.containsKey("data") && ((Map)result.get("data")).containsKey("task_id")) {
                apillmData.setTaskId((String)((Map)result.get("data")).get("task_id"));
            }
            if (result.get("errCode") != null && StringUtils.isNotEmpty((CharSequence)result.get("errCode").toString()) && !result.get("errCode").toString().equals("0")) {
                apillmData.setEnd(true);
                apillmData.setErrCode(result.get("errCode").toString());
                apillmData.setErrMsg(result.get("errMsg").toString());
                blockingIterator.put((Object)JSON.toJSONString((Object)apillmData));
                SSEIteratorCache.finish((String)chatSessionID, (String)RequestContext.get().getTraceId());
            }
        }
        catch (Exception ex) {
            ErrorCode errorCode;
            logger.error("sse.chatservice.Prompt:", (Throwable)ex);
            if (ex instanceof KDException) {
                errorCode = ((KDException)((Object)ex)).getErrorCode();
            } else {
                String sErrMessage = ex.getMessage();
                if (StringUtils.isEmpty((CharSequence)sErrMessage)) {
                    sErrMessage = ex.toString();
                }
                errorCode = new ErrorCode(GaiErrorCode.SSE_ERROR_UNKHNOW.getCode(), String.format(GaiErrorCode.SSE_ERROR_UNKHNOW.getMsg(), sErrMessage));
            }
            apillmData.setErrCode(errorCode.getCode());
            apillmData.setErrMsg(errorCode.getMessage());
            apillmData.setEnd(true);
            blockingIterator.put((Object)JSON.toJSONString((Object)apillmData));
            blockingIterator.finish();
            SSEIteratorCache.finish((String)chatSessionID, (String)RequestContext.get().getTraceId());
        }
    }

    @Override
    protected AbstractSSEIterator newSSEIterator() {
        return new PromptIterator(300000);
    }

    private void verifyParams(PromptParams promptParams) {
        if (StringUtils.isEmpty((CharSequence)promptParams.getPromptNumber())) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_LESS);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)promptParams.getInput())) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.COSMIC_APP_PARAMS_LESS);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)promptParams.getSessionId())) {
            Context context = Context.create((SLIDEENV)SLIDEENV.HTTP_API, (Assistant)new Assistant(), (String)"");
            FlowCacheData.putContext((String)context.getChatSessionId(), (Context)context);
            promptParams.setSessionId(context.getChatSessionId());
        }
        if (promptParams.getVarParams() == null) {
            promptParams.setVarParams(new HashMap());
        }
    }
}

