/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.audio.AudioParam;
import kd.ai.gai.core.audio.AudioServiceHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.FilePreviewParams;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.agent.Feedback;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.domain.dto.agent.FileMetadata;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.dto.agent.annotations.FormAnnotation;
import kd.ai.gai.core.domain.vo.ContextData;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.ActionCallbackMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.message.ChatMessage;
import kd.ai.gai.core.engine.message.ForwardMessage;
import kd.ai.gai.core.enuz.ForwardType;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.PurposeEnum;
import kd.ai.gai.core.enuz.agent.TipsTypeEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.PushMsgService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.service.agent.AgentServiceService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.FileService;
import kd.ai.gai.core.util.FlowUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.ProductUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.ShowCloseCallBack;
import kd.ai.gai.plugin.h5.DeepSeekChatHelper;
import kd.ai.gai.vipknowledge.KnowledgeService;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class AbstractGaiAssistantPlugin
extends AbstractFormPlugin {
    protected static final String CONTROL_VISIBLE_STATUS = "control_visible_status";
    private static final Log log = LogFactory.getLog(AbstractGaiAssistantPlugin.class);
    public static final String TEMP_SKILL_LIST = "skill_id_list_cache";
    private static final String GAI_APP_ID = "3ACHGCGWU9MJ";

    public void preOpenForm(PreOpenFormEventArgs e) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (disabledAppIds.contains(GAI_APP_ID)) {
            e.setCancel(true);
        }
    }

    public void assistantFormInit(IFormView formView, String chatSessionId, long assId) {
        Long userId = RequestContext.get().getCurrUserId();
        boolean permissionShow = GaiUtils.canOpenSide((Long)userId);
        CustomControl ctrl = (CustomControl)this.getControl("gpt_gai");
        if (!ProductUtil.isGalaxyProduct() && !permissionShow) {
            if (AbstractGaiAssistantPlugin.isFormDev(formView)) {
                log.info("GAI TEMP show tips");
                formView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u529f\u80fd\u4f9d\u8d56Agent \u5e73\u53f0\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"gai.plugin.000011", (String)"ai-gai-core", (Object[])new Object[0]));
            }
            SLIDEENV slideenv = this.getSlideenv();
            GaiInitConfig gaiInitConfig = new GaiInitConfig(Boolean.FALSE.booleanValue(), Boolean.FALSE.booleanValue(), slideenv);
            FlowCacheData.putCache((String)RequestContext.get().getGlobalSessionId(), (String)"pageId", (String)this.getView().getPageId());
            ctrl.setData((Object)ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig));
            return;
        }
        RootPageIdContext rootPageIdContext = GaiUtils.newContextInSlide((IFormView)formView, (String)chatSessionId, (long)assId);
        Map crossPageData = rootPageIdContext.getData();
        GaiInitConfig gaiInitConfig = GaiUtils.getInitGaiConfig((Map)crossPageData, (IFormView)formView, (String)rootPageIdContext.getChatSessionId(), (long)assId);
        if (ctrl != null) {
            ctrl.setData((Object)ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig));
        }
        formView.getPageCache().put(CONTROL_VISIBLE_STATUS, String.valueOf(gaiInitConfig.getSwitchSide()));
        this.cacheAssistantInfo(gaiInitConfig);
    }

    public static boolean isFormDev(IFormView formView) {
        String formId = (String)formView.getFormShowParameter().getCustomParam("formId");
        return kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)formId) && formId.equals("bos_devpn_formdesign");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getChatSessionId() != null) {
            Context context = FlowCacheData.getContext((String)this.getChatSessionId());
            GaiUtils.startProcessIfHas((Context)context, (IFormView)this.getView());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if (key.equals("gpt_gai") || key.equals("gpt_skill") || key.equals("gai_optimization_stream")) {
            try {
                this.invokeCustomEvent(eventName, eventArgs, key);
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                String message = e1.getMessage();
                this.getView().showErrorNotification(message);
                String chatSessionId = this.getChatSessionId();
                Map resultMap = ResultVoHelper.buildErrMsg((ErrorCode)GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.ERR_ASSISTANT, (String)message), (String)chatSessionId, (Context)FlowCacheData.getContext((String)chatSessionId));
                CustomControl customControl = (CustomControl)this.getControl(key);
                customControl.setData((Object)resultMap);
            }
        }
    }

    private void invokeCustomEvent(String eventName, String eventArgs, String controlKey) {
        log.info("customEventTime:{} {}", (Object)eventName, (Object)System.currentTimeMillis());
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName);
        JSONObject requestData = JSON.parseObject((String)eventArgs);
        CustomControl customControl = (CustomControl)this.getControl(controlKey);
        Map resultMap = new HashMap();
        String chatSessionId = requestData.getString("id");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)chatSessionId) && !kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)requestActionType.name(), (CharSequence)RequestActionType.newChat.name())) {
            chatSessionId = this.getChatSessionId();
        }
        Context context = null;
        String pageId = this.getView().getPageId();
        switch (requestActionType) {
            case initial: {
                SLIDEENV slideenv = this.getSlideenv();
                if (slideenv != SLIDEENV.ASSISTANT) {
                    return;
                }
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)chatSessionId)) {
                    Object pk = this.getModel().getValue("id");
                    GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId, (long)((Long)pk));
                }
                context = FlowCacheData.getContext((String)chatSessionId);
                GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
                gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)context.getUserId()));
                if (!GptPrivacyHelper.isTenantAgree((String)RequestContext.get().getTenantId())) {
                    gaiInitConfig.setShowIcon(Boolean.FALSE);
                }
                resultMap = ResultVoHelper.buildInitial((GaiInitConfig)gaiInitConfig);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                GaiUtils.startProcessIfHas((Context)context, (IFormView)this.getView());
                break;
            }
            case newChat: {
                GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId, (long)this.getAssId());
                chatSessionId = this.getChatSessionId();
                context = FlowCacheData.getContext((String)chatSessionId);
                JSONObject dataJo = new JSONObject();
                dataJo.put("id", (Object)chatSessionId);
                String timestamp = requestData.getString("timestamp");
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)timestamp)) {
                    dataJo.put("timestamp", (Object)timestamp);
                }
                resultMap = ResultVoHelper.buildResult((String)ResultActionType.newChat.name(), (Object)dataJo, (Context)context);
                break;
            }
            case chat: {
                Long skillId;
                context = FlowCacheData.getContext((String)chatSessionId);
                context.setChatTraceId(RequestContext.get().getTraceId());
                context.setEnableDeepSeek(requestData.getBooleanValue("enableDeepSeek"));
                Result result = null;
                String controlIds = (String)requestData.getOrDefault((Object)"controlIds", (Object)"");
                String skillIdString = (String)requestData.getOrDefault((Object)"skillId", (Object)"");
                String skillTypeString = (String)requestData.getOrDefault((Object)"skillType", null);
                String input = (String)requestData.getOrDefault((Object)"input", (Object)"");
                this.cacheSkillInfo(chatSessionId, skillIdString, skillTypeString);
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skillIdString)) {
                    Process process;
                    String processNumber;
                    String processId = (String)requestData.getOrDefault((Object)"processId", (Object)"");
                    if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)processId) && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)(processNumber = (String)requestData.getOrDefault((Object)"processNumber", (Object)""))) && (process = ProcessService.getProcessByNumber((String)processNumber)) != null) {
                        processId = process.getId() + "";
                    }
                    skillIdString = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)processId) ? null : processId;
                    skillTypeString = Skill.Type.PROCESS.toString();
                    log.info("processNumber skillIdString  {}", (Object)skillIdString);
                }
                Skill.Type skillType = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skillTypeString) ? null : Skill.Type.valueOf((String)skillTypeString);
                Long l = skillId = kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skillIdString) ? null : Long.valueOf(Long.parseLong(skillIdString));
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)skillIdString) && context.getAssistant() != null && context.getAssistant().getPromptId() == 0L) {
                    Assistant assistant = AssistantService.getDefault();
                    assistant = assistant == null ? new Assistant() : assistant;
                    context.setAssistant(assistant);
                }
                ChatMessage chatMessage = new ChatMessage();
                chatMessage.setSkillId(skillId == null ? 0L : skillId);
                chatMessage.setSkillType(skillType);
                chatMessage.setUserInput(input);
                chatMessage.setChatSessionId(chatSessionId);
                HashMap<String, String> inParaMap = new HashMap<String, String>();
                inParaMap.put("controlIds", controlIds);
                if (requestData.getJSONObject("paramMap") != null) {
                    Map paramMap = (Map)requestData.getJSONObject("paramMap").toJavaObject((TypeReference)new TypeReference<Map<String, String>>(){});
                    inParaMap.putAll(paramMap);
                }
                chatMessage.setInParaMap(inParaMap);
                GaiUtils.refreshBizPageId((Context)context, (IFormView)this.getView(), (Long)this.getAssId());
                try {
                    result = HandlerFactory.runHandler((Context)context, (Message)chatMessage);
                    if (result.getErrorCode().equals((Object)Errors.FAKE_OK)) {
                        resultMap = ResultVoHelper.buildFakeErrMsg((String)Errors.LLM_ERROR.getCode(), (String)result.getErrorCode().getMessage(), (String)chatSessionId);
                        PushMsgService.pushWaitingDone((Context)context);
                        break;
                    }
                    if (result.getErrorCode().equals((Object)Errors.OK)) break;
                    PushMsgService.pushWaitingDone((Context)context);
                }
                catch (KDBizException e) {
                    log.info("\u8c03\u7528\u51fa\u73b0\u5f02\u5e38({})\uff1a{}", (Object)e.getErrorCode().getCode(), (Object)e.getMessage());
                    resultMap = ResultVoHelper.buildErrMsg((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage(), (String)chatSessionId, (Context)context);
                    PushMsgService.pushWaitingDone((Context)context);
                }
                catch (Exception e) {
                    log.info("\u8c03\u7528 \u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    resultMap = ResultVoHelper.buildErrMsg((String)Errors.internalError((String)e.getMessage()).getCode(), (String)e.getMessage(), (String)chatSessionId, (Context)context);
                    PushMsgService.pushWaitingDone((Context)context);
                }
                break;
            }
            case openWorkFlow: {
                String crossPageData = requestData.getString("crossPageData");
                String appNumber = (String)requestData.get((Object)"appNumber");
                String source = (String)requestData.get((Object)"source");
                String entityNumber = (String)requestData.get((Object)"entityNumber");
                String caption = (String)requestData.get((Object)"caption");
                GaiUtils.openApp((IFormView)this.getView(), (String)caption, (String)appNumber, (String)source, (String)entityNumber, (String)crossPageData);
                break;
            }
            case getSkillList: 
            case getProcessList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                Object groupIds = requestData.get((Object)"groupIds");
                if (groupIds == null) {
                    long assId = this.getAssId();
                    GaiUtils.refreshBizPageId((Context)context, (IFormView)this.getView(), (Long)this.getAssId());
                    List<Skill> processDataList = context.getSkillList();
                    log.info("processDataIDList: {}", (Object)processDataList.stream().map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet()).toString());
                    processDataList = AbstractGaiAssistantPlugin.getSkillListByCheckLic(context, processDataList);
                    processDataList.addAll(this.getInitSkill(assId, processDataList));
                    resultMap = ResultVoHelper.buildProcessList(processDataList);
                    break;
                }
                JSONArray arr = (JSONArray)groupIds;
                ArrayList<Long> groupIdList = new ArrayList<Long>(arr.size());
                for (Object item : arr) {
                    groupIdList.add(Long.parseLong((String)item));
                }
                List<Skill> processDataList = ProcessService.getProcessListDataByGroupIds((Long[])groupIdList.toArray(new Long[0]));
                log.info("processDataIDList: {}", (Object)processDataList.stream().map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet()).toString());
                processDataList = AbstractGaiAssistantPlugin.getSkillListByCheckLic(context, processDataList);
                resultMap = ResultVoHelper.buildProcessList(processDataList);
                break;
            }
            case getTempSkillList: {
                List skillList;
                Object pkId = this.getModel().getValue("id");
                String temList = this.getView().getPageCache().get(TEMP_SKILL_LIST + (Long)pkId);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)temList)) {
                    List tempskillList = (List)JSON.parseObject((String)temList, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]);
                    skillList = GaiUtils.buildSkillList((List)tempskillList);
                } else {
                    skillList = SkillService.getList((long)Long.parseLong(pkId + ""), null, null, (boolean)true, (boolean)false);
                }
                resultMap = ResultVoHelper.buildProcessList((List)skillList);
                break;
            }
            case stopStream: {
                ChatService.agentCancel((String)chatSessionId, (long)0L);
                context = FlowCacheData.getContext((String)chatSessionId);
                String taskId = requestData.getString("taskId");
                String flowId = requestData.getString("flowId");
                FlowUtils.stopChat((Context)context, (String)taskId, (String)flowId);
                return;
            }
            case showBillForm: {
                String appId = requestData.getString("appId");
                String billFormId = requestData.getString("billFormId");
                String billPkId = requestData.getString("billPkId");
                String type = requestData.getString("type");
                String crossPageData = requestData.getString("crossPageData");
                String menuId = requestData.getString("menuId");
                context = FlowCacheData.getContext((String)chatSessionId);
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)appId) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billFormId) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)billPkId)) {
                    ResultVoHelper.buildErrMsg((ErrorCode)Errors.INPUT_NOT_EMPTY_ERROR, (String)chatSessionId, (Context)context);
                }
                Map gaiParams = (Map)requestData.toJavaObject(Map.class);
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)menuId)) {
                    GaiUtils.showBillForm((IFormView)this.getView(), (String)appId, (String)billFormId, (String)billPkId, (String)crossPageData, (Map)gaiParams, (String)type);
                    break;
                }
                if (menuId.equals("home")) {
                    OpenPageUtils.openApp((String)appId, null, null, (IFormView)this.getView());
                    break;
                }
                if (menuId.equals("openwf")) {
                    OpenStyle openStyle = new OpenStyle();
                    String rootPageId = requestData.getString("rootPageId");
                    openStyle.setShowType(ShowType.MainNewTabPage);
                    FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                    this.getView().getParentView().getFormShowParameter().getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().getParentView().getFormShowParameter().setParentPageId(null);
                    formShowParameter.setAppId(appId);
                    formShowParameter.setRootPageId(rootPageId);
                    OpenPageUtils.openApp((String)appId, null, null, (IFormView)this.getView());
                    WorkflowServiceHelper.viewFlowchart((String)pageId, (Object)billPkId, (OpenStyle)openStyle);
                    break;
                }
                IAppCache appCache = EngineCache.getAppCache((String)"menu_search");
                String cacheMenuId = (String)appCache.get(menuId, String.class);
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cacheMenuId)) {
                    menuId = cacheMenuId;
                }
                OpenPageUtils.openMenu((IFormView)this.getView(), (String)menuId, (String)AppMetadataCache.getAppInfo((String)appId).getId());
                break;
            }
            case forward: {
                context = FlowCacheData.getContext((String)chatSessionId);
                ForwardType forwardType = ForwardType.valueOf((String)requestData.getString("type"));
                if (ForwardType.javaAction != forwardType) break;
                String actionString = this.getView().getPageCache().get(requestData.getString("actionKey"));
                String forwardMsgString = this.getView().getPageCache().get(requestData.getString("forwardMsgKey"));
                String bizPageId = GaiUtils.getCurrentBizPageId((IFormView)this.getView());
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)actionString)) {
                    List actionResult = (List)SerializationUtils.fromJsonString((String)actionString, List.class);
                    HashMap<String, Object> arg = new HashMap<String, Object>(3);
                    arg.put("pageId", bizPageId);
                    arg.put("actions", actionResult);
                    IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    proxy.addAction("sendDynamicFormAction", arg);
                }
                ForwardMessage forwardMessage = (ForwardMessage)JSON.parseObject((String)forwardMsgString, ForwardMessage.class);
                if (AgentServiceService.isNewFlowEngine()) {
                    FlowUtils.resume((String)forwardMessage.getChatSessionId(), (long)forwardMessage.getFlowId());
                    break;
                }
                HandlerFactory.callback((ActionCallbackMessage)forwardMessage);
                break;
            }
            case preview: {
                ContextData.Item item = (ContextData.Item)JSON.parseObject((String)String.valueOf(requestData), ContextData.Item.class);
                AbstractGaiAssistantPlugin.preview(this.getView(), item);
                return;
            }
            case statusChanged: {
                this.getView().getPageCache().put(CONTROL_VISIBLE_STATUS, requestData.getString("gaiShowStatus"));
                break;
            }
            case showAgreement: {
                this.showUserAgreement(requestData);
                break;
            }
            case showTenantAgreement: {
                this.showTenantAgreement();
                break;
            }
            case showAboutCosmic: {
                this.showAboutCosmic();
                break;
            }
            case getAgentList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult getAgentPage = AgentService.getAgentSamplePage((PageQuery)pageQuery);
                PushMsgService.pushResult((Context)context, (String)ResultActionType.getAgentList.name(), (Object)getAgentPage);
                break;
            }
            case getChatInfoList: {
                context = FlowCacheData.getContext((String)chatSessionId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult chatInfoPage = ChatService.getChatSessionPage((PageQuery)pageQuery);
                PushMsgService.pushResult((Context)context, (String)ResultActionType.getChatInfoList.name(), (Object)chatInfoPage);
                break;
            }
            case getChatItemList: {
                GaiUtils.newContextInSlide((IFormView)this.getView(), (String)chatSessionId, (long)this.getAssId());
                context = FlowCacheData.getContext((String)chatSessionId);
                context.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
                context.setAssistantPageId(pageId);
                PageQuery pageQuery = this.parsePageQuery(requestData);
                PageResult chatMessagePage = ChatService.getChatMessagePage((String)chatSessionId, (PageQuery)pageQuery);
                PushMsgService.pushResult((Context)context, (String)ResultActionType.getChatItemList.name(), (Object)chatMessagePage);
                break;
            }
            case renameChat: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.renameChat(requestData, context);
                break;
            }
            case deleteChat: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.deleteChat(requestData, context);
                break;
            }
            case saveMsgFeedback: {
                context = FlowCacheData.getContext((String)chatSessionId);
                this.saveMsgFeedback(requestData, context);
                break;
            }
            case agentCancel: {
                long runId = Long.parseLong(requestData.getString("runId"));
                ChatService.agentCancel((String)chatSessionId, (long)runId);
                break;
            }
            case saveFile: {
                this.saveFile(requestData);
                break;
            }
            case showForm: {
                FormAnnotation formAnnotation = (FormAnnotation)requestData.toJavaObject(FormAnnotation.class);
                AnnotationService.showFormByAnnotation((IFormView)this.getView(), (FormAnnotation)formAnnotation);
                break;
            }
            case showNotification: {
                this.showNotification(requestData);
                break;
            }
            case keepAlive: {
                context = FlowCacheData.getContext((String)chatSessionId);
                context.setTime(System.currentTimeMillis());
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                String rootPageId = context.getRootPageId();
                RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId((String)rootPageId);
                rootPageIdContext.setTime(System.currentTimeMillis());
                FlowCacheData.putRootPageId2ChatSessionId((String)rootPageId, (RootPageIdContext)rootPageIdContext);
                break;
            }
            case openAudio: {
                AudioParam audioParam;
                context = FlowCacheData.getContext((String)chatSessionId);
                String audioModelId = requestData.getString("audioModelId");
                if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)audioModelId)) {
                    resultMap = ResultVoHelper.buildErrMsg((String)"audio.002", (String)"audioModelId is empty", (String)chatSessionId, (Context)context);
                }
                if ((audioParam = AudioServiceHelper.openAudio((String)audioModelId)) == null) {
                    resultMap = ResultVoHelper.buildErrMsg((String)"audio.001", (String)"Audio Param empty", (String)chatSessionId, (Context)context);
                    break;
                }
                PushMsgService.pushResult((Context)context, (String)ResultActionType.openAudio.name(), (Object)audioParam);
                break;
            }
            default: {
                resultMap = new HashMap();
            }
        }
        if (!resultMap.isEmpty()) {
            customControl.setData(resultMap);
        }
    }

    private SLIDEENV getSlideenv() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object slide = parameter.getCustomParam("slideEnv");
        SLIDEENV slideenv = null;
        try {
            slideenv = (SLIDEENV)slide;
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return slideenv;
    }

    private List<Skill> getInitSkill(long assId, List<Skill> processDataList) {
        ArrayList<Skill> skills = new ArrayList<Skill>();
        if (assId == 10000L && ProductUtil.isGalaxyProduct()) {
            String vipKnowledgeSkillId = KnowledgeService.getVipKnowledgeSkillIdStr();
            Optional<Skill> find = processDataList.stream().filter(skill -> skill.getId().equals(vipKnowledgeSkillId)).findFirst();
            if (find.isPresent()) {
                Skill skill2 = find.get();
                skill2.setSupportDs(true);
                List suggestedAskData = KnowledgeService.getSuggestedAskData();
                if (suggestedAskData != null && !suggestedAskData.isEmpty()) {
                    skill2.setSuggestedAsks(suggestedAskData);
                }
                return skills;
            }
            Skill vipKnowledgeSkill = KnowledgeService.getVipKnowledgeSkill((String)vipKnowledgeSkillId);
            if (vipKnowledgeSkill != null) {
                vipKnowledgeSkill.setSupportDs(true);
                skills.add(vipKnowledgeSkill);
            }
        }
        return skills;
    }

    public static List<Skill> getSkillListByCheckLic(Context context, List<Skill> processDataList) {
        if (Context.needCheckLicense((Context)context)) {
            Set processIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.PROCESS).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
            Set agentIdList = processDataList.stream().filter(skill -> skill.getType() == Skill.Type.AGENT).map(skill -> Long.valueOf(skill.getId())).collect(Collectors.toSet());
            Set usedSkillIdList = GPTLicenseHelper.getUseBizIds((String)GaiFormIdEnum.GAI_AGENT.getId(), agentIdList);
            usedSkillIdList.addAll(GPTLicenseHelper.getUseBizIds((String)GaiFormIdEnum.GAI_PROCESS.getId(), processIdList));
            log.info("usedSkillIdList: {}", (Object)usedSkillIdList.toString());
            processDataList = processDataList.stream().filter(skill -> usedSkillIdList.contains(Long.valueOf(skill.getId()))).collect(Collectors.toList());
        }
        return processDataList;
    }

    public long getAssId() {
        if (this.getView().getControl("gpt_skill") == null) {
            Long assistantId = this.getAssistantId(this.getView().getFormShowParameter());
            if (assistantId != null && assistantId > 0L) {
                return assistantId;
            }
            return 10000L;
        }
        Object pkIdO = this.getModel().getValue("id");
        return (Long)pkIdO;
    }

    public Long getAssistantId(FormShowParameter formShowParameter) {
        String assistant = (String)formShowParameter.getCustomParam("assistant");
        String chatType = (String)formShowParameter.getCustomParam("chatType");
        try {
            if ("ds".equals(chatType)) {
                return DeepSeekChatHelper.getAssId();
            }
            if (StringUtils.isNotEmpty((CharSequence)assistant)) {
                return Long.parseLong(assistant);
            }
        }
        catch (NumberFormatException exp) {
            log.error((Throwable)exp);
        }
        return null;
    }

    public static void preview(IFormView view, ContextData.Item item) {
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)item.getFileId())) {
            log.error("\u8f93\u5165\u9700\u8981fileId");
            throw new KDBizException("\u9700\u8981fileId");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", "success");
        map.put("uid", System.currentTimeMillis());
        RequestContext rc = RequestContext.get();
        String previewPath = FilePreviewService.getPreviewUrl((String)item.getContent());
        String downloadPath = FilePreviewService.getDownloadUrl((String)item.getContent());
        previewPath = String.format("%s%s%s", previewPath, previewPath.contains("?") ? "&kdcdc=" : "?kdcdc=", rc.getAccountId());
        downloadPath = String.format("%s%s%s", downloadPath, downloadPath.contains("?") ? "&kdcdc=" : "?kdcdc=", rc.getAccountId());
        map.put("previewurl", previewPath);
        map.put("url", downloadPath);
        String cachedFileParam = (String)EngineCache.getAppCacheForFile().get("filePreview" + item.getFileId(), String.class);
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cachedFileParam)) {
            FilePreviewParams filePreviewParams = (FilePreviewParams)JSON.parseObject((String)cachedFileParam, FilePreviewParams.class);
            map.put("name", filePreviewParams.getFileName());
            map.put("size", filePreviewParams.getSize());
            map.put("type", filePreviewParams.getFileType());
        } else {
            StringBuilder sqlBuild = new StringBuilder();
            sqlBuild.append("SELECT A.fid,A.ffilename, A.ffilesize,A.ffiletype,A.ffilepath");
            sqlBuild.append(" FROM t_gai_repo_doc_manage A");
            sqlBuild.append(" WHERE A.fentryid = ");
            sqlBuild.append(item.getFileId());
            DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sqlBuild.toString(), (Object[])new Object[0], resultSet -> {
                while (resultSet.next()) {
                    map.put("name", resultSet.getString("ffilename"));
                    map.put("size", resultSet.getString("ffilesize"));
                    map.put("type", resultSet.getString("ffiletype").equals("text") ? "txt" : resultSet.getString("ffiletype"));
                }
                return null;
            });
        }
        GaiUtils.preViewFile((IFormView)view, map);
    }

    protected String getChatSessionId() {
        return this.getView().getPageCache().get("chatSessionId");
    }

    private void showNotification(JSONObject requestData) {
        String method = (String)requestData.getOrDefault((Object)"method", (Object)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId());
        int duration = (Integer)requestData.getOrDefault((Object)"duration", (Object)"3500");
        String msg = requestData.getString("msg");
        if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_TIP_NOTIFICATION.getId())) {
            this.getView().showTipNotification(msg, Integer.valueOf(duration));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_SUCCESS_NOTIFICATION.getId())) {
            this.getView().showSuccessNotification(msg, Integer.valueOf(duration));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)method, (CharSequence)TipsTypeEnum.SHOW_ERROR_NOTIFICATION.getId())) {
            this.getView().showErrorNotification(msg);
        }
    }

    private void saveFile(JSONObject requestData) {
        FileMetadata fileMetadata = (FileMetadata)requestData.toJavaObject(FileMetadata.class);
        fileMetadata.setPurpose(PurposeEnum.USER.getId());
        String name = fileMetadata.getName();
        if ((name.toLowerCase().endsWith("jpg") || name.toLowerCase().endsWith("png") || name.toLowerCase().endsWith("jpeg")) && fileMetadata.getFileSize() > 0xA00000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56fe\u7247\u6587\u4ef6\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc710M\u3002", (String)"GaiAgentFormPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        if (fileMetadata.getFileSize() > 0x9600000L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u666e\u901a\u6587\u4ef6\u5927\u5c0f\u4e0d\u5141\u8bb8\u8d85\u8fc7150M\u3002", (String)"GaiAgentFormPlugin_4", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName(fileMetadata.getName());
        fileInfo.setFileSize(fileMetadata.getFileSize());
        fileInfo.setFileType(fileMetadata.getFileType());
        fileInfo.setFileUrl(fileMetadata.getFileUrl());
        fileInfo = FileService.save((FileInfo)fileInfo);
        fileMetadata.setFileId(StrUtils.longAsString((Long)fileInfo.getId()));
        fileMetadata.setFileUrl(fileInfo.getFileUrl());
        fileMetadata.setPreviewUrl(fileInfo.getPreviewUrl());
        String chatSessionId = this.getChatSessionId();
        Context context = FlowCacheData.getContext((String)chatSessionId);
        PushMsgService.pushResult((Context)context, (String)ResultActionType.saveFileResult.name(), (Object)fileMetadata);
    }

    private void deleteChat(JSONObject requestData, Context context) {
        long sessionId = Long.parseLong(requestData.getString("sessionId"));
        DynamicObject chatInfoDo = BusinessDataServiceHelper.loadSingle((Object)sessionId, (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        if (chatInfoDo != null) {
            chatInfoDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatInfoDo});
            if (saveObjs != null && saveObjs.length > 0) {
                requestData.put("id", (Object)context.getChatSessionId());
                log.info("delete success size: {}", (Object)saveObjs.length);
                PushMsgService.pushResult((Context)context, (String)ResultActionType.deleteChat.name(), (Object)requestData);
            }
        }
    }

    private void renameChat(JSONObject requestData, Context context) {
        long sessionId = Long.parseLong(requestData.getString("sessionId"));
        String title = requestData.getString("title");
        DynamicObject chatInfoDo = BusinessDataServiceHelper.loadSingle((Object)sessionId, (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        if (chatInfoDo != null) {
            chatInfoDo.set("name", (Object)title);
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatInfoDo});
            if (saveObjs != null && saveObjs.length > 0) {
                requestData.put("id", (Object)context.getChatSessionId());
                log.info("save success size: {}", (Object)saveObjs.length);
                PushMsgService.pushResult((Context)context, (String)ResultActionType.renameChat.name(), (Object)requestData);
            }
        }
    }

    private void saveMsgFeedback(JSONObject requestData, Context context) {
        Feedback feedback = (Feedback)JSONObject.parseObject((String)requestData.toJSONString(), Feedback.class);
        if (kd.bos.dataentity.utils.StringUtils.length((CharSequence)feedback.getContent()) > 255) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)String.format("\u5185\u5bb9\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u3002", 255), (String)"AbstractGaiAssistantPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]));
            return;
        }
        feedback = ChatService.reportUserFeedback((Context)context, (Feedback)feedback);
        PushMsgService.pushResult((Context)context, (String)ResultActionType.saveMsgFeedback.name(), (Object)feedback);
    }

    private PageQuery parsePageQuery(JSONObject requestData) {
        PageQuery pageQuery = new PageQuery();
        long lastId = Long.parseLong(requestData.getOrDefault((Object)"lastId", (Object)"0") + "");
        int pageSize = (Integer)requestData.getOrDefault((Object)"pageSize", (Object)20);
        String searchKey = requestData.getString("searchKey");
        pageQuery.setPageSize(Integer.valueOf(pageSize));
        pageQuery.setSearchKey(searchKey);
        pageQuery.setLasId(lastId);
        return pageQuery;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        this.getView().getPageCache().remove("showAgreement");
        if ("agreementClose".equals(actionId)) {
            CustomControl customControl = (CustomControl)this.getControl("gpt_gai");
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String chatSessionId = this.getView().getPageCache().get("chatSessionId");
            GaiInitConfig gaiInitConfig = new GaiInitConfig(chatSessionId);
            if ("userAgree".equals(returnData)) {
                gaiInitConfig.setUserAgree(true);
            } else if ("userDisagree".equals(returnData)) {
                gaiInitConfig.setUserAgree(false);
            }
            Map resultMap = ResultVoHelper.buildUserAgree((GaiInitConfig)gaiInitConfig);
            customControl.setData((Object)resultMap);
        }
    }

    private void showTenantAgreement() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_privacy_agreement");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("agreementType", (Object)PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT.getKey());
        showParameter.setStatus(OperationStatus.VIEW);
        IFormView baseView = this.getView().getParentView();
        baseView.showForm(showParameter);
        this.getView().sendFormAction(baseView);
    }

    private void showUserAgreement(JSONObject requestData) {
        IFormView baseView;
        String pageId = this.getView().getPageCache().get("showAgreement");
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)pageId)) {
            return;
        }
        this.getView().getPageCache().put("showAgreement", "true");
        String formId = "gai_privacy_agreement";
        String agreementType = PrivacyAgreementType.USER_PRIVACY_POLICY.getKey();
        FormShowParameter fsp = new FormShowParameter();
        if (this.isMobile(requestData)) {
            formId = "gai_privacy_agreement_m";
            agreementType = PrivacyAgreementType.USER_PRIVACY_POLICY_M.getKey();
        }
        fsp.setFormId(formId);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("agreementType", (Object)agreementType);
        Context context = FlowCacheData.getContext((String)this.getChatSessionId());
        if (context.getSlideenv().toString().startsWith("BOS")) {
            fsp.setCloseCallBack(new CloseCallBack(ShowCloseCallBack.class.getName(), this.getView().getPageId()));
            baseView = this.getView().getParentView();
        } else {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "agreementClose"));
            baseView = this.getView();
        }
        baseView.showForm(fsp);
        this.getView().sendFormAction(baseView);
    }

    private boolean isMobile(JSONObject requestData) {
        Object mobile = requestData.get((Object)"isMobile");
        if (mobile != null) {
            return (Boolean)mobile;
        }
        return false;
    }

    private void showAboutCosmic() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gai_about_cosmic");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView baseView = this.getView().getParentView();
        baseView.showForm(showParameter);
        this.getView().sendFormAction(baseView);
    }

    public void cacheAssistantInfo(GaiInitConfig gaiInitConfig) {
        IAppCache appCache;
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)gaiInitConfig.getChatSessionId()) && (appCache = EngineCache.getAppCache((String)gaiInitConfig.getChatSessionId())) != null) {
            String assistantId = gaiInitConfig.getAssistantId();
            appCache.put("_chat_session_assistant_cache_", (Object)assistantId);
        }
    }

    private void cacheSkillInfo(String chatSessionId, String skillId, String skillType) {
        IAppCache appCache;
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)chatSessionId) && (appCache = EngineCache.getAppCache((String)chatSessionId)) != null && kd.bos.dataentity.utils.StringUtils.equalsIgnoreCase((CharSequence)skillType, (CharSequence)"AGENT")) {
            appCache.put("_chat_session_agent_cache_", (Object)skillId);
        }
    }
}

