/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.plugin.common.NodeConfigData;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.NodePropertyDesigner;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AbstractGaiProcessSetPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(AbstractGaiProcessSetPlugin.class);
    protected static final String KEY_NAME = "name";
    private NodePropertyDesigner nodePropertyDesigner;
    protected static Set<String> systemVarList = new HashSet<String>();

    protected NodePropertyDesigner getNodePropertyDesigner() {
        if (this.nodePropertyDesigner == null) {
            this.nodePropertyDesigner = new NodePropertyDesigner(this.getView());
        }
        return this.nodePropertyDesigner;
    }

    protected int getNodeId() {
        return this.getNodePropertyDesigner().getNodeId();
    }

    protected ProcessNodeType getNodeType() {
        return this.getNodePropertyDesigner().getNodeType();
    }

    protected Flow getFlow() {
        return this.getNodePropertyDesigner().getFlow();
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject objCacheEntity = this.getNodePropertyDesigner().loadEntityFromCache();
        if (objCacheEntity != null) {
            e.setDataEntity((Object)objCacheEntity);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setComboItem();
        this.getNodePropertyDesigner().initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getNodePropertyDesigner().isDataLoadedFromCache() || this.getNodePropertyDesigner().isAddNew()) {
            this.getModel().setDataChanged(true);
        }
    }

    public void destory() {
        super.destory();
        if (this.nodePropertyDesigner != null) {
            this.nodePropertyDesigner.release();
        }
    }

    protected void setComboItem() {
    }

    protected List<ComboItem> getComboItem(RefrenceDataConfig config) {
        List<RefrenceParam> refrenceParamList = this.getNodePropertyDesigner().getRefrenceParamManager().getCanRefrenceParamList(this.getNodePropertyDesigner().getNodeId(), config);
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(refrenceParamList.size());
        for (RefrenceParam refrenceParam : refrenceParamList) {
            ComboItem comboItem = new ComboItem(new LocaleString(refrenceParam.getParamDisplayName()), refrenceParam.getParamValue());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)refrenceParam.getParamImageKey())) {
                comboItem.setImageKey(refrenceParam.getParamImageKey());
            }
            comboItemList.add(comboItem);
        }
        return comboItemList;
    }

    protected List<ComboItem> getComboItem() {
        return this.getComboItem(new RefrenceDataConfig());
    }

    protected void loadRefrenceParams(Action action, String entryKey, String nameKey, String refrenceParamKey) {
        List inputVar = action.getInParamMap();
        if (inputVar != null) {
            int count = this.getModel().getEntryRowCount(entryKey);
            for (int i = 0; i < count; ++i) {
                String name = (String)this.getModel().getValue(nameKey, i);
                VarMapper var = this.getVarMapper(name, inputVar);
                if (var == null) continue;
                String param = RefrenceParam.getParamValue(var.getOutNodeId(), var.getOutVarName());
                this.getModel().setValue(refrenceParamKey, (Object)param, i);
            }
        }
    }

    protected VarMapper getVarMapper(String name, List<VarMapper> inputVar) {
        if (inputVar == null) {
            return null;
        }
        for (VarMapper var : inputVar) {
            if (!var.getInVarName().equals(name)) continue;
            return var;
        }
        return null;
    }

    protected void sendNodeNameToCustomControl(String name) {
        this.getNodePropertyDesigner().sendModifyNameAction(name);
    }

    protected void validateNodeVarName(String propertyName, String entityName, ChangeData data) {
        DynamicObjectCollection rows;
        if (data.getNewValue() == null || StringUtils.isEmpty((CharSequence)data.getNewValue().toString())) {
            return;
        }
        String newValue = data.getNewValue().toString();
        if (StringUtils.isNotBlank((CharSequence)newValue) && systemVarList.contains(newValue.toLowerCase())) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u4e3a\u9884\u7f6e\u53d8\u91cf\uff0c\u4e0d\u5141\u8bb8\u8f93\u5165\u3002", (String)"AbstractGaiProcessSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]), newValue));
            this.getModel().setValue(propertyName, data.getOldValue());
        }
        if (!(rows = this.getModel().getEntryEntity(entityName)).isEmpty()) {
            for (int i = 0; i < rows.size(); ++i) {
                if (data.getRowIndex() == i || !((DynamicObject)rows.get(i)).getString(propertyName).equals(newValue)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u8282\u70b9\u7684\u53c2\u6570\u540d\u4e0d\u53ef\u91cd\u590d\u3002", (String)"AbstractGaiProcessSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.getModel().setValue(propertyName, data.getOldValue());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(KEY_NAME)) {
            ChangeData data = e.getChangeSet()[0];
            if (data.getNewValue() == null || StringUtils.isEmpty((CharSequence)data.getNewValue().toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractGaiProcessSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]));
                this.getModel().setValue(propertyName, data.getOldValue());
            } else {
                this.sendNodeNameToCustomControl(data.getNewValue().toString());
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.getModel().setDataChanged(true);
    }

    public abstract NodeValidateInfo nodeValidate(ProcessNodeType var1, int var2);

    public abstract void saveDataToFlow(Flow var1);

    public abstract void initData();

    public void cacheData(NodeConfigData nodeData) {
    }

    static {
        systemVarList.add("system.user_input");
        systemVarList.add("system.chat_history");
        systemVarList.add("user_input");
        systemVarList.add("system.chat_sessionid");
        systemVarList.add("system.skill_id");
        systemVarList.add("system.user_chat_history");
        systemVarList.add("system.chat_environment");
        systemVarList.add("system.files");
        systemVarList.add("system.execute_date");
    }
}

