/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.PageQuery;
import kd.ai.gai.core.domain.dto.agent.PageResult;
import kd.ai.gai.core.domain.vo.ActionVO;
import kd.ai.gai.core.domain.vo.ResultVoHelper;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.enuz.RequestActionType;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.ai.gai.plugin.AbstractGaiAssistantPlugin;
import kd.ai.gai.plugin.ass.GaiAssistantSharePlugin;
import kd.ai.gai.plugin.ass.ReleaseChannel;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;

public class GaiAssistantConfigPlugin
extends AbstractGaiAssistantPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(GaiAssistantConfigPlugin.class);
    public static final String AI_H5_CHAT_DO = "ai/h5/chat.do";
    public static final String KEY_PROMPT = "flexpanel_prompt";
    public static final String GAI_GPT_CONTROL = "gpt_gai";
    public static final String SKILL_ID_LIST = "skillIdList";
    public static final String DO_SAVE_SKILL_LIST = "do_save_skill_mark";
    public static final String ASSISTANT_MSG = "assistantMsg";
    private static final String H5_URL_LABEL = "h5url_label";
    private static final String VECTOR_COPY_URL = "vectorcopyurl";
    private static final String[] H5FLEX = new String[]{"flexpanel_h5url", "flexpanel_guest"};
    private static final String[] CUSTOM_FLEX = new String[]{"flexpanelap14", "flexpanelap142"};
    private static final String GAI_ASSISTANT_CONFIG_PLUGIN_3 = "GaiAssistantConfigPlugin_3";
    private static final String GAI_ASSISTANT_CONFIG_PLUGIN_4 = "GaiAssistantConfigPlugin_4";
    private static final String MSG_DESCRIPTION_3 = "\u8bf7\u5148\u5b8c\u6210\u914d\u7f6e\u5e76\u4fdd\u5b58\u6570\u636e\u3002";
    private static final String MSG_DESCRIPTION_4 = "\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e\u3002";
    private static final String AI_GAI_PLUGIN = "ai-gai-plugin";
    private static final String[] COPY_NAME = new String[]{"copyflexpanelap", "copyvectorap", "copylabelap", "vectorcopyurl"};
    private static final String GAI_H5_SHARE_URL = "gai_h5_share_url";
    private static final String TYPE = "type";
    private static final String H5 = "C";
    private static final String DEFAULT_TYPE = "A";
    public static final String CUSTOM = "B";

    public void initialize() {
        this.addClickListeners(COPY_NAME);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        this.getView().getFormShowParameter().setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        super.beforeBindData(e);
        Object pkId = this.getModel().getValue("id");
        if (pkId != null && !(pkId + "").equals("0")) {
            IBillModel model = (IBillModel)this.getModel();
            model.load(pkId);
            this.getView().getFormShowParameter().setCaption(this.getStringValue(model.getValue("name")));
            this.getModel().setDataChanged(false);
        }
        if (pkId != null && (Long)pkId == 10000L) {
            this.getModel().setValue(TYPE, (Object)DEFAULT_TYPE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap141", "flex_tips"});
        }
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)value).getLocaleValue();
        }
        return value.toString();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView formView = this.getView();
        FormShowParameter parameter = formView.getFormShowParameter();
        parameter.setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        Long pkId = (Long)this.getModel().getValue("id");
        this.setReleaseChannel(pkId);
        this.assistantFormInit(formView, null, pkId);
        Object type = this.getModel().getValue(TYPE);
        if (type != null && !"".equals(type)) {
            this.getModel().setValue("asstype", type);
            this.getPageCache().put("chooseType", (String)type);
            if (type.equals(H5)) {
                this.h5EditPage();
            } else {
                this.customEditPage();
            }
        }
        this.getModel().setDataChanged(false);
    }

    private void setReleaseChannel(Long pkId) {
        if (pkId == 10000L) {
            Object picture = this.getModel().getValue("picture");
            if (null == picture || "".equals(picture)) {
                this.getModel().setValue("picture", (Object)(this.getHost() + "/kingdee/gai/images/pc/icon/Cosmic_48_48.png"));
            }
            return;
        }
        if (pkId == 0L) {
            this.getModel().setValue("picture", (Object)(this.getHost() + "/kingdee/gai/images/pc/tool/avatar.png"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("asstype".equals(name) && (changeSet = e.getChangeSet()) != null && changeSet.length > 0 && (newValue = changeSet[0].getNewValue()) != null && !"".equals(newValue)) {
            String type = newValue + "";
            this.getPageCache().put("chooseType", type);
            if (type.equals(H5)) {
                this.h5EditPage();
            } else {
                this.customEditPage();
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView formView = this.getView();
        FormShowParameter parameter = formView.getFormShowParameter();
        parameter.setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        this.assistantFormInit(formView, null, (Long)this.getModel().getValue("id"));
    }

    private void customEditPage() {
        this.getView().setVisible(Boolean.valueOf(false), H5FLEX);
        this.getView().setVisible(Boolean.valueOf(true), CUSTOM_FLEX);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_PROMPT});
    }

    private void h5EditPage() {
        this.getView().setVisible(Boolean.valueOf(true), H5FLEX);
        this.getView().setVisible(Boolean.valueOf(false), CUSTOM_FLEX);
        this.buildUrl();
    }

    private void buildUrl() {
        boolean isGuest;
        StringBuilder builder = new StringBuilder();
        builder.append(this.addEndString(UrlService.getDomainContextUrl())).append(AI_H5_CHAT_DO);
        Long value = (Long)this.getModel().getValue("id");
        builder.append("?accountId=").append(RequestContext.get().getAccountId());
        if (value > 0L) {
            builder.append("&assistant=").append(value);
        }
        if (isGuest = ((Boolean)this.getModel().getValue("isguest")).booleanValue()) {
            builder.append("&userId=guest");
        }
        Label label = (Label)this.getControl("h5url");
        label.setText(builder.toString());
        this.getPageCache().put(H5_URL_LABEL, builder.toString());
    }

    private String addEndString(String domainContextUrl) {
        if (domainContextUrl.endsWith("/")) {
            return domainContextUrl;
        }
        return domainContextUrl + "/";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            String choose = this.getPageCache().get("chooseType");
            this.getModel().setValue(TYPE, (Object)choose);
            String picture = (String)this.getModel().getValue("picture");
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)picture)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u5934\u50cf\u3002", (String)"RelChannelPlugin_4", (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String doSave = this.getView().getPageCache().get(DO_SAVE_SKILL_LIST);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doSave)) {
                Map resultMap = ResultVoHelper.buildPreSaveSkillList();
                CustomControl customControl = (CustomControl)this.getControl("gpt_skill");
                customControl.setData((Object)resultMap);
                args.setCancel(true);
            }
            this.getView().getPageCache().put(DO_SAVE_SKILL_LIST, null);
        }
    }

    private String getHost() {
        String host = RequestContext.get().getClientFullContextPath();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)host) && host.endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        this.getView().getFormShowParameter().setCustomParam("slideEnv", (Object)SLIDEENV.ASSISTANT);
        String key = e.getKey();
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        if (key.equals("gpt_skill")) {
            this.invokeCustomEvent(eventName, eventArgs, key);
            return;
        }
        super.customEvent(e);
    }

    private void invokeCustomEvent(String eventName, String eventArgs, String controlKey) {
        RequestActionType requestActionType = RequestActionType.valueOf((String)eventName.trim());
        JSONObject requestData = JSON.parseObject((String)eventArgs);
        CustomControl customControl = (CustomControl)this.getControl(controlKey);
        Map<Object, Object> resultMap = new HashMap();
        switch (requestActionType) {
            case doAddAgent: {
                JSONArray skillIdArr = requestData.getJSONArray(SKILL_ID_LIST);
                this.showSkillF7("gai_agent", skillIdArr);
                break;
            }
            case doAddProcess: {
                JSONArray processIdArr = requestData.getJSONArray(SKILL_ID_LIST);
                this.showSkillF7("gai_process", processIdArr);
                break;
            }
            case preSaveSkillList: {
                break;
            }
            case doSaveSkillList: {
                OperationResult result;
                String number;
                this.getView().getPageCache().put(DO_SAVE_SKILL_LIST, "true");
                String skillJsonArrString = requestData.getString("skillList");
                this.getView().getPageCache().put("skill_id_list_cache" + (Long)this.getModel().getValue("id"), skillJsonArrString);
                List skillList = (List)JSON.parseObject((String)skillJsonArrString, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]);
                String introduce = this.getStringValue(this.getModel().getValue("introduce"));
                if (introduce != null) {
                    this.getModel().setValue("introduce", (Object)GaiUtils.removeExtraNewLines((String)introduce));
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)(number = (String)this.getModel().getValue("number")))) {
                    this.getModel().setValue("number", (Object)ReleaseChannel.createNumber());
                }
                if (!(result = this.getView().invokeOperation("save")).isSuccess()) break;
                long pkId = (Long)result.getSuccessPkIds().get(0);
                resultMap = this.saveSkillAndSendMsg(skillList, pkId);
                break;
            }
            case saveTempSkillList: {
                Object pkId = this.getModel().getValue("id");
                String skillJsonArrString = requestData.getString("skillList");
                List skillList = (List)JSON.parseObject((String)skillJsonArrString, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]);
                this.getView().setVisible(Boolean.valueOf(skillList != null && !skillList.isEmpty() && skillList.size() != 1), new String[]{KEY_PROMPT});
                this.getView().getPageCache().put("skill_id_list_cache" + (Long)pkId, skillJsonArrString);
                CustomControl gptGaiControl = (CustomControl)this.getControl(GAI_GPT_CONTROL);
                gptGaiControl.setData((Object)ResultVoHelper.buildProcessList((List)skillList));
                break;
            }
            case getTempSkillList: {
                Object pkId = this.getModel().getValue("id");
                List<Skill> skillList = this.getTemList((Long)pkId);
                this.getView().setVisible(Boolean.valueOf(skillList != null && !skillList.isEmpty() && skillList.size() != 1), new String[]{KEY_PROMPT});
                resultMap = ResultVoHelper.buildProcessList(skillList);
                break;
            }
            case doNotSaveSkillList: {
                String errMsg = requestData.getString("msg");
                this.getView().showErrorNotification(errMsg);
                break;
            }
            default: {
                resultMap = new HashMap();
            }
        }
        if (!resultMap.isEmpty()) {
            customControl.setData(resultMap);
        }
    }

    public List<Skill> getTemList(Long assId) {
        String temList = this.getView().getPageCache().get("skill_id_list_cache" + assId);
        List skillList = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)temList) ? (List)JSON.parseObject((String)temList, (TypeReference)new TypeReference<List<Skill>>(){}, (Feature[])new Feature[0]) : SkillService.getList((long)assId, null, null, (boolean)true, (boolean)false);
        return skillList;
    }

    public Map<String, Object> saveSkillAndSendMsg(List<Skill> skillList, long pkId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        SkillService.clearAndSaveList((long)pkId, skillList);
        GaiUtils.newContextInSlide((IFormView)this.getView(), (String)this.getChatSessionId(), (long)pkId);
        this.getView().getPageCache().put("skill_id_list_cache" + Long.valueOf(pkId), "");
        GaiInitConfig gaiInitConfig = new GaiInitConfig();
        Assistant assistant = AssistantService.getOne((long)pkId);
        if (null != assistant) {
            String picture = assistant.getPicture();
            if (StringUtils.isNotEmpty((String)picture)) {
                String avatar = AgentService.assemblyPictureWebUrl((String)picture);
                gaiInitConfig.setAvatar(avatar);
            }
            gaiInitConfig.setAssistantId(StrUtils.longAsString((Long)assistant.getId()));
            gaiInitConfig.setAssistantName(assistant.getName());
            gaiInitConfig.setIntroduce(assistant.getIntroduce());
            gaiInitConfig.setOpeningSpeech(assistant.getOpeningSpeech());
            gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree((Long)RequestContext.get().getCurrUserId()));
        }
        ActionVO actionVO1 = new ActionVO();
        actionVO1.setType(ResultActionType.initial);
        actionVO1.setData((Object)gaiInitConfig);
        ActionVO actionVO2 = new ActionVO();
        actionVO2.setType(ResultActionType.processList);
        actionVO2.setData(skillList);
        resultMap.put("time", System.currentTimeMillis() + "");
        ArrayList<ActionVO> list = new ArrayList<ActionVO>();
        list.add(actionVO1);
        list.add(actionVO2);
        resultMap.put("actionList", list);
        CustomControl gptGaiControl = (CustomControl)this.getControl(GAI_GPT_CONTROL);
        if (!resultMap.isEmpty()) {
            gptGaiControl.setData(resultMap);
        }
        this.buildUrl();
        return resultMap;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection listSelectedRowCollection;
        super.closedCallBack(event);
        if ((event.getActionId().equals(GaiFormIdEnum.GAI_AGENT.getId()) || event.getActionId().equals(GaiFormIdEnum.GAI_PROCESS.getId())) && (listSelectedRowCollection = (ListSelectedRowCollection)event.getReturnData()) != null && !listSelectedRowCollection.isEmpty()) {
            List<Skill> temList = this.getTemList((Long)this.getModel().getValue("id"));
            ArrayList skillIds = new ArrayList();
            if (!temList.isEmpty()) {
                List collect = temList.stream().map(v -> Long.parseLong(v.getId())).collect(Collectors.toList());
                skillIds.addAll(collect);
            }
            ArrayList<Long> selectedIdList = new ArrayList<Long>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                Long primaryKeyValue = (Long)listSelectedRow.getPrimaryKeyValue();
                if (skillIds.contains(primaryKeyValue)) continue;
                selectedIdList.add(primaryKeyValue);
            }
            PageQuery pageQuery = new PageQuery();
            pageQuery.setPageSize(Integer.valueOf(100));
            pageQuery.setIdList(selectedIdList);
            PageResult agentPage = AgentService.getAgentPage((PageQuery)pageQuery);
            List agentList = agentPage.getList();
            CustomControl customControl = (CustomControl)this.getControl("gpt_skill");
            CustomControl customControl2 = (CustomControl)this.getControl(GAI_GPT_CONTROL);
            List<Skill> skills = new ArrayList(10);
            if ("gai_agent".equals(event.getActionId())) {
                for (Agent agent : agentList) {
                    Skill skill = GaiAssistantConfigPlugin.getSkill(agent);
                    skills.add(skill);
                }
            } else {
                skills = ProcessService.getProcessByIds(selectedIdList);
            }
            if (skills != null) {
                temList.addAll(skills);
            }
            customControl.setData((Object)ResultVoHelper.buildProcessList(temList));
            customControl2.setData((Object)ResultVoHelper.buildProcessList(temList));
        }
    }

    private static Skill getSkill(Agent agent) {
        Skill skill = new Skill();
        skill.setId(agent.getAgentId() + "");
        skill.setName(agent.getName());
        skill.setNumber(agent.getNumber());
        skill.setType(Skill.Type.AGENT);
        skill.setPicture(agent.getPicture());
        skill.setBgColor(agent.getBgColor());
        skill.setPrologue(agent.getPrologue());
        skill.setServiceDes(agent.getDescription());
        return skill;
    }

    private void showSkillF7(String formId, JSONArray selectedIdJsonArr) {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setShowApproved(true);
        lsp.setBillFormId(formId);
        lsp.setFormId("bos_listf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700px");
        inlineStyleCss.setWidth("1200px");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        lsp.setLookUp(true);
        QFilter qFilter = new QFilter("enable", "=", (Object)EnableEnum.YES.getKeyStr());
        long userId = RequestContext.get().getCurrUserId();
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)formId);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)met.getAppId());
        List<QFilter> qFilters = Collections.singletonList(qFilter);
        lsp.getListFilterParameter().setQFilters(qFilters);
        lsp.setLookUp(true);
        Object[] idList = new Long[selectedIdJsonArr.size()];
        for (int i = 0; i < selectedIdJsonArr.size(); ++i) {
            idList[i] = selectedIdJsonArr.getLong(i);
        }
        lsp.setSelectedRows(idList);
        lsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), formId));
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        List<String> list = Arrays.asList(COPY_NAME);
        if (list.contains(source.getKey())) {
            boolean dataChanged = this.getModel().getDataChanged();
            if (dataChanged) {
                this.getView().showTipNotification(ResManager.loadKDString((String)MSG_DESCRIPTION_4, (String)GAI_ASSISTANT_CONFIG_PLUGIN_4, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
                return;
            }
            if (VECTOR_COPY_URL.equals(source.getKey())) {
                GaiAssistantSharePlugin.copy(this.getPageCache().get(H5_URL_LABEL), this.getView());
                return;
            }
            Long value = (Long)this.getModel().getValue("id");
            if (value > 0L) {
                this.showShareForm(value);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)MSG_DESCRIPTION_3, (String)GAI_ASSISTANT_CONFIG_PLUGIN_3, (String)AI_GAI_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void showShareForm(Long value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object name = this.getModel().getValue("name");
        Object openingspeech = this.getModel().getValue("openingspeech");
        map.put("name", this.getStringValue(name));
        map.put("openingspeech", this.getStringValue(openingspeech));
        map.put("url", this.getPageCache().get(H5_URL_LABEL));
        map.put("skillList", this.getTemList(value));
        FormShowParameter bsp = new FormShowParameter();
        bsp.setFormId(GAI_H5_SHARE_URL);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setCustomParam(ASSISTANT_MSG, map);
        this.getView().showForm(bsp);
    }
}

