/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.Date;
import java.util.EventObject;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.privacy.PrivacyAgreementService;
import kd.ai.gai.core.privacy.model.PrivacyAgreement;
import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.ai.gai.core.util.AgentAppParamsUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiPrivacyAgreementPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_TENANT_AGREEMENT = "gai_tenant_agreement";
    private static final String ENTITY_USER_AGREEMENT = "gai_user_agreement";
    private static final String BTN_AGREE = "btnok";
    private static final String BTN_DISAGREE = "btncancel";
    private static final String BTN_AGREEMENT_CANCEL = "btnagreementcancel";
    private static final String BTN_CLOSE = "btnclose";
    private static final String AGREEMENT_TYPE = "agreementType";
    private static final String TENANT_AGREEMENT = "tenantAgreement";
    private static final String USER_AGREEMENT = "userAgreement";
    private static final String USER_AGREEMENT_M = "userAgreementMobile";
    private static final String AGREEMENT_CONTENT = "agreement";
    private static final String AGREEMENT_VERSION = "version";
    private static final String PRIVACY_AGREEMENT_VERSION = "privacy_version";
    private static final String PARAM_AGREEMENT_TYPE = "agreementType";
    private static final String AGREE_OR_NO_FLEX = "agree_or_no_flex";
    private static final String AGREE_OR_NO_LABEL = "agree_or_no_label";
    private static final String LABEL_AP_MOBILE = "labelap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_AGREE, BTN_AGREEMENT_CANCEL, AGREE_OR_NO_FLEX, AGREE_OR_NO_LABEL});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String agreementType = (String)fsp.getCustomParam("agreementType");
        boolean fillAgreementResult = this.fillAgreementContent(agreementType);
        if (StringUtils.isEmpty((CharSequence)agreementType) || !fillAgreementResult) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_AGREE, BTN_DISAGREE, BTN_AGREEMENT_CANCEL});
        }
        this.pageProviderByType(agreementType);
        OperationStatus status = fsp.getStatus();
        if (status == OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CLOSE});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_AGREE, BTN_DISAGREE, BTN_AGREEMENT_CANCEL});
        }
    }

    private void pageProviderByType(String agreementType) {
        long currUserId = RequestContext.get().getCurrUserId();
        switch (agreementType) {
            case "tenantAgreement": {
                this.getView().setFormTitle(new LocaleString("\u670d\u52a1\u534f\u8bae"));
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_AGREE, BTN_DISAGREE});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_CLOSE, BTN_AGREEMENT_CANCEL});
                break;
            }
            case "userAgreement": {
                this.getView().setFormTitle(new LocaleString("\u9690\u79c1\u653f\u7b56"));
                boolean isUserAgree = GptPrivacyHelper.isUserAgree((Long)currUserId);
                this.getView().setVisible(Boolean.valueOf(isUserAgree), new String[]{BTN_AGREEMENT_CANCEL, BTN_CLOSE});
                this.getView().setVisible(Boolean.valueOf(!isUserAgree), new String[]{BTN_AGREE, BTN_DISAGREE});
                break;
            }
            case "userAgreementMobile": {
                boolean isUserAgreeM = GptPrivacyHelper.isUserAgree((Long)currUserId);
                Label label = (Label)this.getControl(AGREE_OR_NO_LABEL);
                label.setText(isUserAgreeM ? new LocaleString("\u89e3\u9664\u534f\u8bae").toString() : new LocaleString("\u540c\u610f\u534f\u8bae").toString());
                Label labelAp = (Label)this.getControl(LABEL_AP_MOBILE);
                labelAp.setText(isUserAgreeM ? new LocaleString("\u53d6\u6d88").toString() : new LocaleString("\u6682\u4e0d\u7b7e\u7f72").toString());
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String agreementType = (String)fsp.getCustomParam("agreementType");
        switch (key) {
            case "btnok": {
                this.saveAgreementStatus(agreementType, true);
                break;
            }
            case "btnagreementcancel": {
                if (!USER_AGREEMENT.equals(agreementType)) break;
                this.saveAgreementStatus(USER_AGREEMENT, false);
                break;
            }
            case "agree_or_no_flex": 
            case "agree_or_no_label": {
                boolean isUserAgreeM = GptPrivacyHelper.isUserAgree((Long)RequestContext.get().getCurrUserId());
                this.saveAgreementStatus(USER_AGREEMENT, !isUserAgreeM);
                break;
            }
        }
        this.getView().close();
    }

    private void saveAgreementStatus(String agreementType, boolean isAgree) {
        if (TENANT_AGREEMENT.equals(agreementType)) {
            DynamicObject tenantAgreement = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_TENANT_AGREEMENT);
            tenantAgreement.set("tenantid", (Object)RequestContext.get().getTenantId());
            tenantAgreement.set("user", (Object)RequestContext.get().getCurrUserId());
            tenantAgreement.set("isagree", (Object)isAgree);
            Date agreetime = new Date();
            tenantAgreement.set("agreetime", (Object)agreetime);
            tenantAgreement.set("agreetimestamp", (Object)agreetime.getTime());
            String customParam = this.getView().getPageCache().get(PRIVACY_AGREEMENT_VERSION);
            tenantAgreement.set(AGREEMENT_VERSION, (Object)customParam);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenantAgreement});
            this.getView().returnDataToParent((Object)(isAgree ? "tenantAgree" : null));
        } else if (USER_AGREEMENT.equals(agreementType)) {
            if (AgentAppParamsUtils.privacyAgreementNotSign()) {
                return;
            }
            long currUserId = RequestContext.get().getCurrUserId();
            if (!isAgree) {
                DeleteServiceHelper.delete((String)ENTITY_USER_AGREEMENT, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)currUserId)});
                this.getView().returnDataToParent((Object)"userDisagree");
                return;
            }
            DynamicObject userAgreement = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_USER_AGREEMENT);
            userAgreement.set("user", (Object)currUserId);
            userAgreement.set("isagree", (Object)Boolean.TRUE);
            Date agreetime = new Date();
            userAgreement.set("agreetime", (Object)agreetime);
            userAgreement.set("agreetimestamp", (Object)agreetime.getTime());
            String customParam = this.getView().getPageCache().get(PRIVACY_AGREEMENT_VERSION);
            userAgreement.set(AGREEMENT_VERSION, (Object)customParam);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userAgreement});
            this.getView().returnDataToParent((Object)"userAgree");
        }
    }

    private boolean fillAgreementContent(String agreementType) {
        if (StringUtils.isEmpty((CharSequence)agreementType)) {
            return false;
        }
        PrivacyAgreement agreement = PrivacyAgreementService.getPrivacyAgreement((PrivacyAgreementType)PrivacyAgreementType.fromKey((String)agreementType));
        if (agreement == null) {
            return false;
        }
        Html agreementHtml = (Html)this.getControl(AGREEMENT_CONTENT);
        agreementHtml.setConent(agreement.getContent());
        this.getView().getPageCache().put(PRIVACY_AGREEMENT_VERSION, agreement.getVersion());
        return true;
    }
}

