/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.process.ImportTypeEnum;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.param.legacy.LegacyMigrationHelper;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.agent.FileService;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.New;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class GaiProcessListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(GaiProcessListPlugin.class);
    private static final String KEY_IMPORT_PROCESS = "importprocess";
    private static final String KEY_EXPORT_PROCESS = "exportprocess";
    private static final String PAGE_ID = "pageId";
    private static final String ACTION_ID = "gai_upload_file";
    private static final String KEY_IMPORT_TYPE = "importtype";
    private static final String KEY_FILES = "files";
    private static final String OPERATE_KEY_NEW_OLD = "new_old";
    public static final String CACHE_KEY_NEW_OLD_FLOW = "new_old_flow";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        Flow flow;
        String flowStr;
        DynamicObject originData;
        Object primaryKeyValue;
        ListSelectedRowCollection selectedRows;
        super.itemClick(evt);
        if ("update".equals(evt.getItemKey())) {
            selectedRows = this.getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification("\u8bf7\u9009\u4e2d\u4e00\u884c\u4efb\u52a1\u6d41\u6267\u884c\u5347\u7ea7");
                return;
            }
            primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            originData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gai_process");
            flowStr = originData.getString("flow");
            flow = JsonUtil.fromBase64String((String)flowStr);
            if (ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
                this.getView().showTipNotification("\u5df2\u662f\u65b0\u7248\u4efb\u52a1\u6d41\uff0c \u65e0\u9700\u5347\u7ea7");
                return;
            }
            this.backupFlow(originData, flowStr);
            this.updateNewFlow(originData, flow);
            this.getView().showSuccessNotification("\u5347\u7ea7\u6210\u529f");
        }
        if ("rollback".equals(evt.getItemKey())) {
            selectedRows = this.getSelectedRows();
            if (selectedRows.size() != 1) {
                this.getView().showTipNotification("\u8bf7\u9009\u4e2d\u4e00\u884c\u4efb\u52a1\u6d41\u6267\u884c\u5347\u7ea7");
                return;
            }
            primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            originData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"gai_process");
            flowStr = originData.getString("flow");
            flow = JsonUtil.fromBase64String((String)flowStr);
            if (!ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
                this.getView().showTipNotification("\u975e\u65b0\u7248\u4efb\u52a1\u6d41\uff0c \u65e0\u9700\u6062\u590d");
                return;
            }
            DynamicObject backupData = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"gai_process_backup");
            if (backupData == null) {
                this.getView().showTipNotification("\u65e0\u5347\u7ea7\u8fc7\u7a0b\u6570\u636e\uff0c \u65e0\u6cd5\u6062\u590d\uff0c \u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u5347\u7ea7\u4efb\u52a1\u6d41");
                return;
            }
            this.rollbackFlow(originData, backupData);
            this.getView().showSuccessNotification("\u6062\u590d\u6210\u529f");
        }
    }

    private void backupFlow(DynamicObject originData, String flowStr) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gai_process_backup");
        DynamicObject backupData = new DynamicObject((DynamicObjectType)dataEntityType);
        backupData.set("id", originData.getPkValue());
        backupData.set("billno", (Object)originData.getString("number"));
        backupData.set("flow_tag", (Object)flowStr);
        boolean exists = QueryServiceHelper.exists((String)"gai_process_backup", (Object)originData.getPkValue());
        if (exists) {
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{backupData});
            return;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{backupData});
    }

    private void updateNewFlow(DynamicObject originData, Flow flow) {
        Start start = flow.getStart();
        End end = flow.getEnd();
        List actions = flow.getActions();
        LegacyMigrationHelper.migrateNode((Action)start);
        LegacyMigrationHelper.migrateNode((Action)end);
        for (Action action : actions) {
            LegacyMigrationHelper.migrateNode((Action)action);
        }
        flow.setParamMode(ParamMode.VARIABLE.name());
        String flowStr = JsonUtil.toBase64String((Flow)flow);
        originData.set("flow", (Object)flowStr);
        SaveServiceHelper.update((DynamicObject)originData);
    }

    private void rollbackFlow(DynamicObject originData, DynamicObject backupData) {
        String flowStr = backupData.getString("flow_tag");
        originData.set("flow", (Object)flowStr);
        SaveServiceHelper.update((DynamicObject)originData);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String filedName = args.getFieldName();
        boolean isSkill = QueryServiceHelper.exists((String)"gai_skill", (QFilter[])new QFilter[]{new QFilter("skillid", "=", this.getFocusRowPkId())});
        if (isSkill && (filedName.equals("name") || filedName.equals("number"))) {
            args.setCancel(true);
            this.getView().invokeOperation("view");
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        FormOperate formOperate = (FormOperate)source;
        String operateKey = formOperate.getOperateKey();
        if (source instanceof Delete) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] processIdArr = selectedRows.getPrimaryKeyValues();
            ProcessService.deleteProcessRefOperation((Object[])processIdArr);
        } else if (formOperate instanceof New && operateKey.equals(OPERATE_KEY_NEW_OLD)) {
            this.getView().getPageCache().put(CACHE_KEY_NEW_OLD_FLOW, "true");
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String newOldFlow = this.getView().getPageCache().get(CACHE_KEY_NEW_OLD_FLOW);
        if (StringUtils.isNotEmpty((CharSequence)newOldFlow)) {
            e.getParameter().setCustomParam(CACHE_KEY_NEW_OLD_FLOW, (Object)true);
            this.getView().getPageCache().remove(CACHE_KEY_NEW_OLD_FLOW);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (ACTION_ID.equals(actionId)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            try (TXHandle h = TX.required((String)"gai_process_import");){
                try {
                    this.execImport(returnData);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("gai_process_import exception:{}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        }
    }

    private void execImport(Map<String, Object> returnData) {
        List uploadFiles;
        String importType = (String)returnData.getOrDefault(KEY_IMPORT_TYPE, ImportTypeEnum.INCREMENT.getId());
        boolean increment = StringUtils.equalsIgnoreCase((CharSequence)importType, (CharSequence)ImportTypeEnum.INCREMENT.getId());
        log.info("importType:{} userName:{}", (Object)importType, (Object)RequestContext.get().getUserName());
        int successCount = 0;
        int ingoreCount = 0;
        long createOrg = RequestContext.get().getOrgId();
        String createOrgCache = this.getView().getPageCache().get("createOrg");
        if (StringUtils.isNotEmpty((CharSequence)createOrgCache)) {
            createOrg = Long.parseLong(createOrgCache);
        }
        if (Objects.nonNull(uploadFiles = (List)returnData.get(KEY_FILES)) && !uploadFiles.isEmpty()) {
            for (int i = 0; i < uploadFiles.size(); ++i) {
                Map f = (Map)uploadFiles.get(i);
                String url = (String)f.get("url");
                InputStream inputStream = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(url);
                String content = null;
                try {
                    content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    Map importResultMap = ProcessService.importProcessWithResult((String)content, (String)importType, (boolean)increment, (long)createOrg);
                    successCount = importResultMap.getOrDefault("successCount", 0);
                    ingoreCount = importResultMap.getOrDefault("ingoreCount", 0);
                    continue;
                }
                catch (IOException e) {
                    log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (ingoreCount > 0) {
                String message = ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\uff0c\u5ffd\u7565%s\u6761", (String)"GaiProcessListPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(message, successCount, ingoreCount));
            } else {
                String message = ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\uff0c\u5ffd\u7565%s\u6761", (String)"GaiProcessListPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(String.format(message, successCount, ingoreCount));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_IMPORT_PROCESS)) {
            RequestContext rc = RequestContext.get();
            boolean hasPermmission = PermissionServiceHelper.checkPermission((Long)rc.getCurrUserId(), (String)"gai", (String)"gai_process", (String)"4730fc9f000003ae");
            if (hasPermmission) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(GaiFormIdEnum.GAI_PROCESS_IMPORT_DLG.getId());
                showParameter.setCustomParam(PAGE_ID, (Object)this.getView().getPageId());
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_ID));
                this.getView().showForm(showParameter);
            } else {
                String message = ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u6d41\u201d\u7684\u201c\u5f15\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GaiProcessListPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(message);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)KEY_EXPORT_PROCESS)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] processIdArr = selectedRows.getPrimaryKeyValues();
            JSONArray processJa = ProcessService.assemblyExportProcess((Object[])processIdArr);
            Map tempFileMap = FileService.uploadStringToCacheFile((String)String.format("process_export_%s.json", DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMddHHmmss")), (String)processJa.toJSONString());
            Object url = tempFileMap.get("url");
            log.info("export url : {}", url);
            this.getView().openUrl((String)url);
        }
    }
}

