/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.End;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.RecommendAction;
import kd.ai.gai.core.engine.flow.Start;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.flow.application.RecommendNodeApplication;
import kd.ai.gai.core.flow.param.execution.ParamMode;
import kd.ai.gai.core.flow.template.FlowTemplate;
import kd.ai.gai.core.flow.template.FlowTemplateFactory;
import kd.ai.gai.core.util.DynamicObjectUtils;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.core.util.OperationResultUtil;
import kd.ai.gai.core.util.RecommendNodeUtil;
import kd.ai.gai.plugin.common.CustomControlAction;
import kd.ai.gai.plugin.flow.FlowDesigner;
import kd.ai.gai.plugin.flow.services.FlowActionService;
import kd.ai.gai.plugin.flow.services.ValidateService;
import kd.ai.gai.plugin.flow.services.ViewService;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaiProcessPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(GaiProcessPlugin.class);
    private static final String KEY_SPLITCONTAINERAP = "splitcontainerap";
    private static final String KEY_SPLITPANELAP_RIGHT = "splitpanelap_right";
    private static final String KEY_ADVCONTOOLBARAP = "advcontoolbarap";
    private static final String KEY_TBMAIN = "tbmain";
    private static final String KEY_COLLAPSE = "vectorapcollapse";
    private static final String OP_SAVE = "saveprocess";
    private static final String OP_ENGINE_TOOL = "enginetool";
    private static final String OPERATION_KEY_ENABLE = "enable";
    private static final String OPERATION_KEY_DISABLE = "disable";
    private static final String OPERATION_KEY_MODIFY = "modify";
    private static final Logger log = LoggerFactory.getLogger(GaiProcessPlugin.class);
    private static final String PROCESS_FLOW = "flow";
    private static final String ENTITY_OPERATION = "gai_operation";
    private static final String ENTITY_PROCESS_TEMPLATE = "gai_process_template";
    private static final String CACHE_KEY_COPY_OPERATION_IDS = "copy_operation_ids";
    private static final String KEY_ENGINE_TOOL = "enginetool";
    private static final String BAR_SAVE_AS_TEMPLATE = "bar_save_as_template";
    private static final String BAR_ITEM_UPDATE = "update";
    private static final String OP_SAVE_AS_TEMPLATE = "saveastemplate";
    private static final String CREATOR_ID = "creator_id";
    private static final String MODIFIER_ID = "modifier_id";
    private static final String CREATEORG_ID = "createorg_id";
    private static final String ORG_ID = "org_id";
    private static final String USEORG_ID = "useorg_id";
    private static final String ENTRY_SUGGESTED_ASK = "entryentity_suggestedask";
    private static final String ENTRY_PROP_QUESTION = "question";
    private static final String EVENT_LOAD_TEMPLATE = "loadFlowTemplate";
    public static final String DEFAULT_RECOMMEND_WAY = RecommendAction.GenerateWay.QA.getValue();
    public static final String DEFAULT_RECOMMEND_USER_PROMPT = "- \u751f\u6210\u95ee\u9898\u5e94\u8be5\u77e5\u8bc6\u7d27\u5bc6\u76f8\u5173\uff0c\u53ef\u4ee5\u5f15\u53d1\u8fdb\u4e00\u6b65\u7684\u8ba8\u8bba\u3002\n - \u751f\u6210\u95ee\u9898\u4e0d\u8981\u4e0e\u539f\u59cb\u95ee\u9898\u91cd\u590d\n - \u6bcf\u53e5\u8bdd\u53ea\u5305\u542b\u4e00\u4e2a\u95ee\u9898\uff0c\u4f46\u4e5f\u53ef\u4ee5\u4e0d\u662f\u95ee\u53e5\u800c\u662f\u4e00\u53e5\u6307\u4ee4\n -\u6bcf\u4e2a\u95ee\u9898\u63a7\u5236\u572830\u4e2a\u5b57\u4ee5\u5185\uff0c\u751f\u6210\u95ee\u9898\u4e0d\u8981\u8fc7\u4e8e\u76f8\u4f3c\n - \u6839\u636e\u5f53\u524d\u77e5\u8bc6\uff0c\u63a8\u8350\u4f60\u4e00\u5b9a\u53ef\u4ee5\u56de\u7b54\u7684\u95ee\u9898\u3002";
    public static final Integer DEFAULT_RECOMMEND_NUM = 3;
    public static final String KEY_ID = "ID";
    public static final String KEY_RECOMMEND_ENABLE = "recommend_question_enable";
    public static final String KEY_RECOMMEND_GENERATE_WAY = "question_generate_way";
    public static final String KEY_RECOMMEND_QA_REPO = "qa_repo";
    public static final String KEY_RECOMMEND_SIMILARITY = "similarity";
    public static final String KEY_RECOMMEND_LLM = "large_model";
    public static final String KEY_RECOMMEND_USER_PROMPT = "recommend_question_prompt";
    public static final String KEY_RECOMMEND_USER_PROMPT_TAG = "recommend_question_prompt_tag";
    public static final String KEY_RECOMMEND_NUM = "recommend_question_num";
    private static final List<String> SYSTEM_PARAMS = Arrays.asList("system.user_input", "system.chat_sessionid", "system.chat_history", "system.chat_environment");
    private FlowDesigner flowDesigner;

    private FlowDesigner getFlowDesigner() {
        if (this.flowDesigner == null) {
            this.flowDesigner = new FlowDesigner(this.getView());
        }
        return this.flowDesigner;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_ADVCONTOOLBARAP, KEY_TBMAIN});
        this.addClickListeners(new String[]{KEY_COLLAPSE});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadTemplate();
        this.getFlowDesigner().initFlow();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getFlowDesigner().lockFlow();
        this.getFlowDesigner().getEditingContext().getService(ViewService.class).setCurrentEditFlow();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (dataEntity != null && (Long)dataEntity.getPkValue() > 0L) {
            this.resetFormTitle(dataEntity);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"enginetool"});
        }
        this.setSaveAsTemplateBar();
        this.initRecommendData();
        this.initLlmList();
    }

    private void loadTemplate() {
        String templateId = (String)this.getView().getFormShowParameter().getCustomParam("templateId");
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            try {
                Optional flowTemplateOptional = FlowTemplateFactory.getTemplateById((Long)Long.valueOf(templateId));
                flowTemplateOptional.ifPresent(flowTemplate -> this.getModel().setValue(PROCESS_FLOW, (Object)JsonUtil.toBase64String((Flow)flowTemplate.getFlow())));
            }
            catch (Exception e) {
                log.error("load template error", (Throwable)e);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject processDo = this.getModel().getDataEntity(true);
        String fflow = processDo.getString(PROCESS_FLOW);
        Flow flow = JsonUtil.fromBase64String((String)fflow);
        Boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (isPreset.booleanValue()) {
            this.getModel().setValue("ispreset", (Object)false);
        }
        if (flow != null && !ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
            ArrayList<Action> copyActionList = new ArrayList<Action>();
            List actionList = flow.getActions();
            if (actionList != null && !actionList.isEmpty()) {
                List operationActionList = actionList.stream().filter(Node::isCusOptionNode).collect(Collectors.toList());
                DynamicObject[] saveObjs = new DynamicObject[operationActionList.size()];
                int j = 0;
                ArrayList<Long> copyOperationIdList = new ArrayList<Long>();
                for (int i = 0; i < actionList.size(); ++i) {
                    Action action = (Action)actionList.get(i);
                    if (action.isCusOptionNode()) {
                        JavaPluginAction javaPluginAction = (JavaPluginAction)actionList.get(i);
                        long actionId = javaPluginAction.getActionId();
                        DynamicObject operationDo = BusinessDataServiceHelper.loadSingle((Object)actionId, (String)ENTITY_OPERATION);
                        CloneUtils cloneUtils = new CloneUtils(false, true);
                        DynamicObject newOperationDo = (DynamicObject)cloneUtils.clone((IDataEntityBase)operationDo);
                        long id = ID.genLongId();
                        newOperationDo.set("id", (Object)id);
                        newOperationDo.set("masterid", (Object)id);
                        saveObjs[j++] = newOperationDo;
                        javaPluginAction.setActionId(id);
                        action = javaPluginAction;
                        copyOperationIdList.add(id);
                    }
                    copyActionList.add(action);
                }
                if (saveObjs.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])saveObjs);
                    flow.setActions(copyActionList);
                    this.getModel().setValue(PROCESS_FLOW, (Object)JsonUtil.toBase64String((Flow)flow));
                    this.getView().updateView();
                    this.getPageCache().put(CACHE_KEY_COPY_OPERATION_IDS, StringUtils.join(copyOperationIdList, (String)","));
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String operationIds;
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(false);
        Object pkValue = dataEntity.getPkValue();
        if ((pkValue == null || (Long)pkValue == 0L) && StringUtils.isNotEmpty((CharSequence)(operationIds = this.getPageCache().get(CACHE_KEY_COPY_OPERATION_IDS)))) {
            long[] operationIdArr = Arrays.stream(operationIds.split(",")).mapToLong(Long::parseLong).toArray();
            DeleteServiceHelper.delete((String)ENTITY_OPERATION, (QFilter[])new QFilter("id", "in", (Object)operationIdArr).toArray());
        }
    }

    private void resetFormTitle(DynamicObject dataEntity) {
        OrmLocaleValue name = (OrmLocaleValue)dataEntity.getLocaleString("name");
        if (name != null) {
            String nameLocaleValue = name.getLocaleValue();
            String title = ResManager.loadKDString((String)"\u4efb\u52a1\u6d41", (String)"GaiProcessPlugin_23", (String)"ai-gai-plugin", (Object[])new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)nameLocaleValue)) {
                if (StringUtils.length((CharSequence)nameLocaleValue) > 10) {
                    nameLocaleValue = nameLocaleValue.substring(0, 10) + "...";
                }
                title = String.format("%s-%s", title, nameLocaleValue);
            }
            this.getView().setFormTitle(new LocaleString(title));
        }
    }

    public void destory() {
        super.destory();
        if (this.flowDesigner != null) {
            this.flowDesigner.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (key.equals("ai_gai_gpt_flow")) {
            DLock mylock;
            block4: {
                logger.info(String.format("traceid=%s,customEvent-beforelock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                mylock = DLock.createReentrant((String)this.getView().getPageId());
                mylock.lock();
                try {
                    logger.info(String.format("traceid=%s,customEvent-before-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                    this.getView().addService(IPageCache.class, (Object)new PageCache(this.getView().getPageId()));
                    if (!EVENT_LOAD_TEMPLATE.equals(eventName)) break block4;
                    this.handleTemplateParamAddition(eventArgs);
                }
                catch (Throwable throwable) {
                    mylock.unlock();
                    mylock.close();
                    logger.info(String.format("traceid=%s,customEvent-afterunlock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                    throw throwable;
                }
                mylock.unlock();
                mylock.close();
                logger.info(String.format("traceid=%s,customEvent-afterunlock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
                return;
            }
            eventArgs = RecommendNodeUtil.insertRecommendNode((String)eventArgs, (RecommendAction)this.buildRecommendNode());
            this.getFlowDesigner().handleFlowEvent(eventName, eventArgs);
            logger.info(String.format("traceid=%s,customEvent-after-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
            mylock.unlock();
            mylock.close();
            logger.info(String.format("traceid=%s,customEvent-afterunlock,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        String itemKey = evt.getItemKey();
        if (OP_SAVE.equals(operationKey)) {
            boolean iscancel = this.getFlowDesigner().getEditingContext().getService(ValidateService.class).validateFlow();
            if (iscancel) {
                evt.setCancel(true);
                return;
            }
            this.deleteEmptyRows();
            CustomControlAction action = new CustomControlAction("saveFlow");
            this.getFlowDesigner().getEditingContext().getService(FlowActionService.class).sendAction(action);
            this.getView().setEnable(Boolean.TRUE, new String[]{"enginetool"});
            if (this.isOldProcess()) {
                return;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SAVE_AS_TEMPLATE});
        } else if ("enginetool".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (dataEntity != null) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(GaiFormIdEnum.GAI_PROCESS_ENGINE_TOOL.getId());
                fsp.setCustomParam("id", dataEntity.getPkValue());
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(fsp);
            } else {
                String message = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58", (String)"GaiProcessPlugin_25", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
            }
        }
    }

    public void setSaveAsTemplateBar() {
        if (this.isOldProcess()) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (dataEntity == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE_AS_TEMPLATE});
                return;
            }
            Object pkValue = dataEntity.getPkValue();
            if (pkValue == null || (Long)pkValue <= 0L) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE_AS_TEMPLATE});
                return;
            }
            DynamicObject savedDO = BusinessDataServiceHelper.loadSingle((Object)pkValue, (DynamicObjectType)dataEntity.getDynamicObjectType());
            if (savedDO == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SAVE_AS_TEMPLATE});
                return;
            }
        }
    }

    private boolean isOldProcess() {
        DynamicObject processDo = this.getModel().getDataEntity(true);
        String fflow = processDo.getString(PROCESS_FLOW);
        Flow flow = JsonUtil.fromBase64String((String)fflow);
        if (!ParamMode.VARIABLE.name().equals(flow.getParamMode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE_AS_TEMPLATE});
            return true;
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(KEY_COLLAPSE)) {
            SplitContainer splitContainer = (SplitContainer)this.getControl(KEY_SPLITCONTAINERAP);
            splitContainer.setCollapse(KEY_SPLITPANELAP_RIGHT, true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        switch (opKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "enable": 
            case "disable": {
                if (!this.getModel().getDataChanged()) break;
                String message = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6d41\u6570\u636e\u5df2\u4fee\u6539\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"GaiProcessPlugin_22", (String)"ai-gai-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                args.setCancelMessage(message);
                args.setCancel(true);
                break;
            }
            case "saveastemplate": {
                String appId = this.getView().getFormShowParameter().getAppId();
                boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)ENTITY_PROCESS_TEMPLATE, (String)"47156aff000000ac");
                if (hasPerm) break;
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4efb\u52a1\u6d41\u6a21\u677f\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GaiProcessPlugin_28", (String)"ai-gai-plugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey;
        switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
            case "enable": 
            case "disable": 
            case "modify": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getFlowDesigner().lockFlow();
            }
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)opKey, (CharSequence)OP_SAVE_AS_TEMPLATE)) {
            this.saveAsTemplate();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (EVENT_LOAD_TEMPLATE.equals(callBackId)) {
            Flow eventFlow;
            long templateFlowId;
            Optional templateFlowOptional;
            String eventArgs = this.getView().getPageCache().get("eventArgs");
            if (StringUtils.isBlank((CharSequence)eventArgs)) {
                return;
            }
            if (MessageBoxResult.Yes.equals((Object)result) && (templateFlowOptional = FlowTemplateFactory.getTemplateById((Long)(templateFlowId = (eventFlow = (Flow)JsonUtil.fromJson((String)eventArgs, Flow.class)).getId()))).isPresent()) {
                Flow templateFlow = ((FlowTemplate)templateFlowOptional.get()).getFlow();
                eventFlow.setStart(templateFlow.getStart());
                eventFlow.setEnd(templateFlow.getEnd());
                eventArgs = JsonUtil.toJson((Object)eventFlow);
            }
            this.getView().getPageCache().remove("eventArgs");
            this.getFlowDesigner().handleFlowEvent(EVENT_LOAD_TEMPLATE, eventArgs);
            logger.info(String.format("traceid=%s,customEvent-after-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
        }
    }

    private void initRecommendData() {
        boolean initFinishByFlow = this.initRecommendDataByFlow();
        if (!initFinishByFlow) {
            this.getModel().setValue(KEY_RECOMMEND_GENERATE_WAY, (Object)DEFAULT_RECOMMEND_WAY);
            this.getModel().setValue(KEY_RECOMMEND_NUM, (Object)DEFAULT_RECOMMEND_NUM);
            this.getModel().setValue(KEY_RECOMMEND_USER_PROMPT, (Object)DEFAULT_RECOMMEND_USER_PROMPT);
            this.getModel().setValue(KEY_RECOMMEND_USER_PROMPT_TAG, (Object)DEFAULT_RECOMMEND_USER_PROMPT);
            BigDecimal similarityValue = new BigDecimal(String.valueOf(RecommendNodeApplication.DEFAULT_SIMILARITY));
            this.getModel().setValue(KEY_RECOMMEND_SIMILARITY, (Object)similarityValue);
        }
    }

    private boolean initRecommendDataByFlow() {
        Object idObj = this.getModel().getValue(KEY_ID);
        if (idObj == null) {
            return false;
        }
        if (idObj instanceof Long) {
            Object flowObj;
            FormShowParameter formShowParameter;
            long id = (Long)idObj;
            if (id == 0L && (formShowParameter = this.getView().getFormShowParameter()) instanceof BaseShowParameter) {
                Object pkId = ((BaseShowParameter)formShowParameter).getPkId();
                if (pkId != null) {
                    id = (Long)pkId;
                } else {
                    return false;
                }
            }
            QFilter flowFilter = new QFilter(KEY_ID, "=", (Object)id);
            DynamicObject savedProcessDO = BusinessDataServiceHelper.loadSingle((String)this.getView().getEntityId(), (QFilter[])new QFilter[]{flowFilter});
            if (savedProcessDO != null && (flowObj = savedProcessDO.get(PROCESS_FLOW)) != null && StringUtils.isNotBlank((CharSequence)flowObj.toString())) {
                Flow flow = JsonUtil.fromBase64String((String)flowObj.toString());
                List actionList = flow.getActions();
                for (Action action : actionList) {
                    if (!(action instanceof RecommendAction)) continue;
                    RecommendAction recommendAction = (RecommendAction)action;
                    Boolean enable = recommendAction.getEnable();
                    String generateWay = recommendAction.getGenerateWay();
                    Integer generateNum = recommendAction.getGenerateNum();
                    Float similarity = recommendAction.getSimilarity();
                    similarity = similarity == null ? RecommendNodeApplication.DEFAULT_SIMILARITY : similarity;
                    BigDecimal similarityValue = new BigDecimal(String.valueOf(similarity));
                    List repoIdList = recommendAction.getRepoIdList();
                    String llmNumber = recommendAction.getLlmNumber();
                    String userPrompt = recommendAction.getUserPrompt();
                    this.getModel().setValue(KEY_RECOMMEND_ENABLE, (Object)enable);
                    this.getModel().setValue(KEY_RECOMMEND_GENERATE_WAY, (Object)generateWay);
                    this.getModel().setValue(KEY_RECOMMEND_NUM, (Object)generateNum);
                    this.getModel().setValue(KEY_RECOMMEND_QA_REPO, (Object)repoIdList.toArray());
                    this.getModel().setValue(KEY_RECOMMEND_SIMILARITY, (Object)similarityValue);
                    this.getModel().setValue(KEY_RECOMMEND_LLM, (Object)llmNumber);
                    this.getModel().setValue(KEY_RECOMMEND_USER_PROMPT, (Object)userPrompt);
                    this.getModel().setValue(KEY_RECOMMEND_USER_PROMPT_TAG, (Object)userPrompt);
                    return true;
                }
            }
        }
        return false;
    }

    private void initLlmList() {
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(KEY_RECOMMEND_LLM);
        String id = String.valueOf(this.getModel().getValue("id"));
        List llmComboItemList = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        if (!llmComboItemList.isEmpty()) {
            llmComboEdit.setComboItems(llmComboItemList);
            String llmNumber = (String)this.getModel().getValue(KEY_RECOMMEND_LLM);
            Set llmNumberSet = llmComboItemList.stream().map(ComboItem::getValue).collect(Collectors.toSet());
            if (StringUtils.isBlank((CharSequence)llmNumber) || !llmNumberSet.contains(llmNumber)) {
                for (ComboItem comboItem : llmComboItemList) {
                    LocaleString caption = comboItem.getCaption();
                    if (caption == null || !caption.getLocaleValue().contains("\u5b9e\u4f8b\u5df2\u914d\u7f6e")) continue;
                    this.getModel().setValue(KEY_RECOMMEND_LLM, (Object)comboItem.getValue());
                    break;
                }
            }
        } else {
            this.getModel().setValue(KEY_RECOMMEND_LLM, null);
            llmComboEdit.setComboItems(null);
        }
    }

    public RecommendAction buildRecommendNode() {
        Boolean recommendEnable = (Boolean)this.getModel().getValue(KEY_RECOMMEND_ENABLE);
        ArrayList<Long> repoIdList = new ArrayList<Long>();
        MulBasedataDynamicObjectCollection repoColl = (MulBasedataDynamicObjectCollection)this.getModel().getValue(KEY_RECOMMEND_QA_REPO);
        for (DynamicObject dynamicObject : repoColl) {
            DynamicObject repoDO = (DynamicObject)dynamicObject.get(1);
            long repoId = repoDO.getLong(KEY_ID);
            repoIdList.add(repoId);
        }
        String generateWay = (String)this.getModel().getValue(KEY_RECOMMEND_GENERATE_WAY);
        String llmNumber = (String)this.getModel().getValue(KEY_RECOMMEND_LLM);
        String userPrompt = (String)this.getModel().getValue(KEY_RECOMMEND_USER_PROMPT);
        String userPromptLongStr = (String)this.getModel().getValue(KEY_RECOMMEND_USER_PROMPT_TAG);
        userPrompt = StringUtils.isNotBlank((CharSequence)userPromptLongStr) ? userPromptLongStr : userPrompt;
        BigDecimal generateNum = (BigDecimal)this.getModel().getValue(KEY_RECOMMEND_NUM);
        BigDecimal similarity = (BigDecimal)this.getModel().getValue(KEY_RECOMMEND_SIMILARITY);
        RecommendAction recommendAction = new RecommendAction();
        recommendAction.setEnable(recommendEnable);
        recommendAction.setName(ProcessNodeType.RecommendQuestion.getName());
        recommendAction.setType(String.valueOf(ProcessNodeType.RecommendQuestion.getValue()));
        recommendAction.setGenerateWay(generateWay);
        recommendAction.setGenerateNum(Integer.valueOf(generateNum.intValue()));
        recommendAction.setRepoIdList(repoIdList);
        recommendAction.setSimilarity(Float.valueOf(similarity.floatValue()));
        recommendAction.setLlmNumber(llmNumber);
        recommendAction.setUserPrompt(userPrompt);
        return recommendAction;
    }

    private void saveAsTemplate() {
        String processFormId = GaiFormIdEnum.GAI_PROCESS.getId();
        String templateFormId = GaiFormIdEnum.GAI_PROCESS_TEMPLATE.getId();
        QFilter idFilter = new QFilter(KEY_ID, "=", this.getModel().getValue(KEY_ID));
        DynamicObject processDO = BusinessDataServiceHelper.loadSingle((String)processFormId, (QFilter[])new QFilter[]{idFilter});
        DynamicObject templateDO = BusinessDataServiceHelper.newDynamicObject((String)templateFormId);
        DynamicObjectType templateDoType = templateDO.getDynamicObjectType();
        RequestContext rc = RequestContext.get();
        long currUserId = rc.getCurrUserId();
        long currOrgId = rc.getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)currOrgId, (String)"bos_org", (String)String.format("%s,%s,%s", "id", "name", "number"));
        Date currDate = KDDateUtils.now();
        templateDO = DynamicObjectUtils.deepCopy((IDataEntityType)templateDoType, (DynamicObject)processDO, (boolean)true, (boolean)true);
        long genId = ID.genLongId();
        templateDO.set("id", (Object)genId);
        templateDO.set("number", null);
        templateDO.set("creator", (Object)currUserId);
        templateDO.set("modifier", (Object)currUserId);
        templateDO.set("createtime", (Object)currDate);
        templateDO.set("modifytime", (Object)currDate);
        templateDO.set("org", (Object)org);
        templateDO.set("createorg", (Object)org);
        templateDO.set("useorg", (Object)org);
        templateDO.set(OPERATION_KEY_ENABLE, (Object)EnableEnum.YES.getKey());
        templateDO.set("ispreset", (Object)EnableEnum.NO.getKey());
        OperationResult opResult = SaveServiceHelper.saveOperate((String)templateFormId, (DynamicObject[])new DynamicObject[]{templateDO}, (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getOperationResultMessage((OperationResult)opResult));
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)genId);
        billShowParameter.setFormId(templateFormId);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        billShowParameter.setOpenStyle(openStyle);
        billShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void deleteEmptyRows() {
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY_SUGGESTED_ASK);
        ArrayList<Integer> deleteRowIndexList = new ArrayList<Integer>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            Object ask = this.getModel().getValue(ENTRY_PROP_QUESTION, i);
            if (!kd.bos.dataentity.utils.StringUtils.isBlank((Object)ask)) continue;
            deleteRowIndexList.add(i);
        }
        if (deleteRowIndexList.isEmpty()) {
            return;
        }
        this.getModel().deleteEntryRows(ENTRY_SUGGESTED_ASK, deleteRowIndexList.stream().mapToInt(Integer::intValue).toArray());
    }

    private void handleTemplateParamAddition(String eventArgs) {
        Flow eventFlow = (Flow)JsonUtil.fromJson((String)eventArgs, Flow.class);
        long templateFlowId = eventFlow.getId();
        Optional flowTemplateOptional = FlowTemplateFactory.getTemplateById((Long)templateFlowId);
        if (!flowTemplateOptional.isPresent()) {
            return;
        }
        Flow templateFlow = ((FlowTemplate)flowTemplateOptional.get()).getFlow();
        Start templateStart = templateFlow.getStart();
        End templateEnd = templateFlow.getEnd();
        if ((templateStart == null || this.isStartParamEmpty(templateStart)) && (templateEnd == null || templateEnd.getOutputParams().isEmpty())) {
            this.getFlowDesigner().handleFlowEvent(EVENT_LOAD_TEMPLATE, eventArgs);
            return;
        }
        String currentFlowStr = (String)this.getModel().getValue(PROCESS_FLOW);
        Flow currentFlow = JsonUtil.fromBase64String((String)currentFlowStr);
        RecommendNodeUtil.removeRecommendNode((Flow)currentFlow);
        Start currentStart = currentFlow.getStart();
        End currentEnd = currentFlow.getEnd();
        if (currentStart != null && !this.isStartParamEmpty(currentStart) || currentEnd != null && !currentEnd.getOutputParams().isEmpty()) {
            this.getView().getPageCache().put("eventArgs", eventArgs);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u548c\u753b\u5e03\u7684\u8f93\u5165/\u8f93\u51fa\u8282\u70b9\u5747\u6709\u53c2\u6570\uff0c\u6a21\u677f\u7684\u53c2\u6570\u5c06\u8ffd\u52a0\u5230\u753b\u5e03\u4e2d\uff0c\u53c2\u6570\u91cd\u540d\u65f6\u820d\u5f03\u6a21\u677f\u7684\u53c2\u6570\u3002\r\n\u662f\u5426\u786e\u8ba4\u8ffd\u52a0\uff1f", (String)"GaiProcessPlugin_27", (String)"ai-gai-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(EVENT_LOAD_TEMPLATE));
            return;
        }
        eventFlow.setStart(templateStart);
        eventFlow.setEnd(templateEnd);
        this.getFlowDesigner().handleFlowEvent(EVENT_LOAD_TEMPLATE, JsonUtil.toJson((Object)eventFlow));
        logger.info(String.format("traceid=%s,customEvent-after-invokeEvent,time=%s", RequestContext.get().getTraceId(), new Date().getTime()));
    }

    private boolean isStartParamEmpty(Start start) {
        Map params = start.getParams();
        if (params == null || params.isEmpty()) {
            return true;
        }
        Map inputParams = (Map)params.get(start.getInputParamGroup());
        if (inputParams == null || inputParams.isEmpty()) {
            return true;
        }
        for (String paramName : inputParams.keySet()) {
            if (SYSTEM_PARAMS.contains(paramName)) continue;
            return false;
        }
        return true;
    }
}

