/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ParallelAction;
import kd.ai.gai.core.engine.flow.PromptTemplateContent;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.enuz.LLMTaskType;
import kd.ai.gai.core.enuz.ProcessNodeType;
import kd.ai.gai.core.enuz.PromptTemplateType;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.util.GaiFieldTypeInitUtils;
import kd.ai.gai.plugin.AbstractGaiProcessSetPlugin;
import kd.ai.gai.plugin.common.NodeValidateInfo;
import kd.ai.gai.plugin.flow.model.RefrenceDataConfig;
import kd.ai.gai.plugin.flow.model.RefrenceParam;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextOtherEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GaiProcessPromptSetPlugin
extends AbstractGaiProcessSetPlugin {
    private static final String KEY_PROMPTINFO = "promptinfo";
    private static final String KEY_USERINPUT_PARAM = "userinput";
    private static final String KEY_DY_REPO = "dyrepo";
    private static final String KEY_SHOWMESSAGE = "showmessage";
    private static final String KEY_MERGE_SHOW = "merge_show";
    private static final String KEY_ENTRYENTITY_INPUT = "input";
    private static final String KEY_INPUT_TYPE = "input_type";
    private static final String KEY_INPUT_NAME = "input_name";
    private static final String KEY_INPUT_DESC = "input_desc";
    private static final String KEY_INPUT_SOURCEPARAM = "input_sourceparam";
    private static final String KEY_CUR_TEMPLATE = "currenttemplate";
    private static final String TOOLBAR_PROMPT_CHOOSE = "toolbar_promptchoose";
    private static final String BARKEY_USE_TEMPLATE = "usetemplate";
    private static final String BARKEY_CHANGE_TEMPLATE = "changetemplate";
    private static final String BARKEY_USE_CUSTOMPROMPT = "usecustomprompt";
    private static final String TOOLBAR_INPUT = "toolbar_input";
    private static final String TOOLBAR_OUTPUT = "toolbar_output";
    private static final String KEY_LLM = "combofield_llm";
    private static final String KEY_USER_PROMPT = "user_prompt";
    private static final String KEY_USER_PROMPT_TAG = "user_prompt_tag";
    private static final String KEY_SYS_PROMPT = "sys_prompt";
    private static final String KEY_SYS_PROMPT_TAG = "sys_prompt_tag";
    private static final String KEY_OUTPUT_NAME = "output_name";
    private static final String KEY_OUTPUT_TYPE = "output_type";
    private static final String KEY_OUTPUT_DESC = "output_desc";
    private static final String KEY_ENTRYENTITY_OUTPUT = "output";
    private static final String KEY_ENTRYENTITY_VARCONFIG = "var_configs";
    private static final String KEY_ENTRYENTITY_OUTVARCONFIG = "out_var_configs";
    private static final String SEPERATOR = "#";
    private static final String SELECT_TEMPLATE_CALLBACK_ACTION_ID = "select_template_callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl(TOOLBAR_PROMPT_CHOOSE);
        toolbar.addItemClickListener((ItemClickListener)this);
        this.addClickListeners(new String[]{BARKEY_USE_TEMPLATE});
        this.addClickListeners(new String[]{BARKEY_CHANGE_TEMPLATE});
        this.addClickListeners(new String[]{BARKEY_USE_CUSTOMPROMPT});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)BARKEY_USE_CUSTOMPROMPT)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u540e\uff0c\u90e8\u5206\u6570\u636e\u4f1a\u88ab\u6e05\u7a7a", (String)"GaiProcessPromptSetPlugin_3", (String)"ai-gai-plugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (BARKEY_CHANGE_TEMPLATE.equals(itemKey) || BARKEY_USE_TEMPLATE.equals(itemKey)) {
            this.showPromptTemplateForm();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "usecustomprompt": {
                    this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.CUSTOM_PROMPT.getCode());
                    this.fillInputAndOutput();
                    this.getView().updateView();
                    break;
                }
                case "usetemplate": 
                case "changetemplate": {
                    this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.TEMPLATE_PROMPT.getCode());
                    this.showPromptTemplateForm();
                }
            }
        }
    }

    public void showPromptTemplateForm() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
        lsp.setFormId("bos_templatetreelistf7");
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setShowTitle(false);
        lsp.setMultiSelect(false);
        lsp.setCustomParam("enable", (Object)EnableEnum.YES.getKeyStr());
        lsp.setLookUp(true);
        StyleCss inlineStyleCss = new StyleCss();
        inlineStyleCss.setHeight("700");
        inlineStyleCss.setWidth("1080");
        lsp.getOpenStyle().setInlineStyleCss(inlineStyleCss);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_TEMPLATE_CALLBACK_ACTION_ID);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)SELECT_TEMPLATE_CALLBACK_ACTION_ID)) {
            Object returnData = event.getReturnData();
            if (returnData != null) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                if (selectedRows.isEmpty()) {
                    return;
                }
                this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)PromptTemplateType.TEMPLATE_PROMPT.getCode());
                Object[] selectPkArr = selectedRows.getPrimaryKeyValues();
                DynamicObject promptTemplateDo = BusinessDataServiceHelper.loadSingle((Object)selectPkArr[0], (String)GaiFormIdEnum.GAI_PROMPT_TEMPLATE.getId());
                String llm = promptTemplateDo.getString("language_model");
                this.getModel().setValue(KEY_LLM, (Object)llm);
                String prompt = promptTemplateDo.getString("prompt");
                String promptTag = promptTemplateDo.getString("prompt_tag");
                this.getModel().setValue(KEY_USER_PROMPT, null);
                this.getModel().setValue(KEY_USER_PROMPT_TAG, null);
                this.getModel().setValue(KEY_SYS_PROMPT, (Object)prompt);
                this.getModel().setValue(KEY_SYS_PROMPT_TAG, (Object)promptTag);
                DynamicObjectCollection inputVarDoColl = promptTemplateDo.getDynamicObjectCollection(KEY_ENTRYENTITY_VARCONFIG);
                ArrayList inputVarList = Lists.newArrayList();
                if (inputVarDoColl != null && !inputVarDoColl.isEmpty()) {
                    for (DynamicObject varDO : inputVarDoColl) {
                        String varName = varDO.getString("var");
                        String varDesc = varDO.getString("var_name");
                        String varType = varDO.getString("var_type");
                        Var var = new Var(varName, VarFieldType.parse((String)varType).getType(), ResManager.loadKDString((String)varDesc, (String)"DefaultPromptTemplate_0", (String)"ai-gai-core", (Object[])new Object[0]));
                        inputVarList.add(var);
                    }
                }
                this.changeInputTable(inputVarList);
                DynamicObjectCollection outputVarDoColl = promptTemplateDo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG);
                ArrayList outputVarList = Lists.newArrayList();
                if (outputVarDoColl != null && !outputVarDoColl.isEmpty()) {
                    for (DynamicObject varDO : outputVarDoColl) {
                        String varName = varDO.getString("out_var");
                        String varDesc = varDO.getString("out_var_name");
                        String varType = varDO.getString("out_var_type");
                        Var var = new Var(varName, VarFieldType.parse((String)varType).getType(), ResManager.loadKDString((String)varDesc, (String)"DefaultPromptTemplate_0", (String)"ai-gai-core", (Object[])new Object[0]));
                        outputVarList.add(var);
                    }
                }
                this.changeOutputTable(outputVarList);
            }
            this.getView().updateView();
        }
    }

    private void changeView(boolean isUseTemplate) {
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{BARKEY_USE_CUSTOMPROMPT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{BARKEY_CHANGE_TEMPLATE});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{BARKEY_USE_TEMPLATE});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{TOOLBAR_INPUT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{TOOLBAR_OUTPUT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_LLM});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_USER_PROMPT});
        this.getView().setVisible(Boolean.valueOf(isUseTemplate), new String[]{KEY_SYS_PROMPT});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_USERINPUT_PARAM});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_DY_REPO});
        this.getView().setVisible(Boolean.valueOf(!isUseTemplate), new String[]{KEY_PROMPTINFO});
    }

    @Override
    protected void setComboItem() {
        RefrenceDataConfig config = new RefrenceDataConfig();
        config.setAddUserInput(true);
        config.setAddUserChatHistory(true);
        List<ComboItem> paramItems = this.getComboItem(config);
        ComboEdit sourceParam = (ComboEdit)this.getControl(KEY_INPUT_SOURCEPARAM);
        sourceParam.setComboItems(paramItems);
        config.setAddUserInput(true);
        config.setAddUserChatHistory(true);
        paramItems = this.getComboItem(config);
        ComboEdit userInputEdit = (ComboEdit)this.getControl(KEY_USERINPUT_PARAM);
        userInputEdit.setComboItems(paramItems);
        ArrayList<ProcessNodeType> nodeTypeList = new ArrayList<ProcessNodeType>(2);
        nodeTypeList.add(ProcessNodeType.CusOption);
        nodeTypeList.add(ProcessNodeType.PresetOption);
        ArrayList<String> paramTypeList = new ArrayList<String>(1);
        paramTypeList.add("String");
        config.setAddUserChatHistory(false);
        config.setAddUserInput(false);
        config.setOnlyNodeTypeList(nodeTypeList);
        config.setOnlyParamTypeList(paramTypeList);
        paramItems = this.getComboItem(config);
        ComboEdit dyRepo = (ComboEdit)this.getControl(KEY_DY_REPO);
        dyRepo.setComboItems(paramItems);
        List itemList = GaiFieldTypeInitUtils.createVarTypeComboItem();
        ComboEdit inputEdit = (ComboEdit)this.getControl(KEY_INPUT_TYPE);
        inputEdit.setComboItems(itemList);
        ComboEdit outputEdit = (ComboEdit)this.getControl(KEY_OUTPUT_TYPE);
        outputEdit.setComboItems(itemList);
        String id = String.valueOf(this.getFlow().getId());
        List comboItems = GaiFieldTypeInitUtils.createLlmComboItem((String)LLMTaskType.PROCESS.getId(), (String)id);
        ComboEdit llmComboEdit = (ComboEdit)this.getView().getControl(KEY_LLM);
        llmComboEdit.setComboItems(comboItems);
    }

    @Override
    public void initData() {
        String userInputVal;
        Flow flow = this.getFlow();
        int nodeId = (Integer)this.getView().getFormShowParameter().getCustomParam("nodeId");
        LLMAction llmAction = (LLMAction)flow.findActionById(nodeId);
        long promptId = llmAction.getLlmPromptId();
        VarMapper userInputVarMap = llmAction.getUserInputMapper();
        VarMapper dyRepoVarMap = llmAction.getRepoMapper();
        if (userInputVarMap != null) {
            userInputVal = RefrenceParam.getParamValue(userInputVarMap.getOutNodeId(), userInputVarMap.getOutVarName());
            this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)userInputVal);
        } else {
            this.getModel().setValue(KEY_USERINPUT_PARAM, (Object)RefrenceParam.getParamValue(flow.getStart().getId(), "system.user_input"));
        }
        if (dyRepoVarMap != null) {
            userInputVal = RefrenceParam.getParamValue(dyRepoVarMap.getOutNodeId(), dyRepoVarMap.getOutVarName());
            this.getModel().setValue(KEY_DY_REPO, (Object)userInputVal);
        } else {
            this.getModel().setValue(KEY_DY_REPO, null);
        }
        if (promptId != 0L) {
            this.getModel().setValue(KEY_PROMPTINFO, (Object)promptId);
        }
        boolean isStream = llmAction.isStream();
        boolean merge = llmAction.isMergeLastMessageCard();
        this.getModel().setValue(KEY_SHOWMESSAGE, (Object)isStream);
        this.getModel().setValue(KEY_MERGE_SHOW, (Object)merge);
        int promptType = llmAction.getPromptType();
        this.getModel().setValue(KEY_CUR_TEMPLATE, (Object)promptType);
        String llm = llmAction.getLlm();
        if (StringUtils.isNotEmpty((CharSequence)llm)) {
            this.getModel().setValue(KEY_LLM, (Object)llmAction.getLlm());
        }
        PromptTemplateContent promptTemplateContent = llmAction.getPromptTemplateContent();
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        this.getModel().setValue(userTagFieldKey, (Object)promptTemplateContent.getUserPrompt());
        this.getModel().setValue(sysTagFieldKey, (Object)promptTemplateContent.getSysPrompt());
        if (llmAction.getPromptType() == 0) {
            this.fillInputAndOutput();
        } else {
            List inputVarList = promptTemplateContent.getInputVarList();
            this.changeInputTable(inputVarList);
            List outputVarList = promptTemplateContent.getOutputVarList();
            this.changeOutputTable(outputVarList);
        }
        this.loadRefrenceParams((Action)llmAction, KEY_ENTRYENTITY_INPUT, KEY_INPUT_NAME, KEY_INPUT_SOURCEPARAM);
        this.getView().updateView();
    }

    @Override
    public void afterBindData(EventObject e) {
        int promptType;
        Node parentNode;
        super.afterBindData(e);
        int nodeId = this.getNodeId();
        Flow flow = this.getFlow();
        Node node = flow.findNodeById(nodeId);
        int blockNodeId = node.getBlockNodeId();
        if (blockNodeId != -1 && (parentNode = flow.findNodeById(blockNodeId)) instanceof ParallelAction) {
            this.getModel().setValue(KEY_SHOWMESSAGE, (Object)false);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SHOWMESSAGE});
            this.getModel().setDataChanged(false);
            this.getModel().updateCache();
        }
        this.changeView((promptType = ((Integer)this.getModel().getValue(KEY_CUR_TEMPLATE)).intValue()) != PromptTemplateType.CUSTOM_PROMPT.getCode());
    }

    private void clickGPTPrompt(Flow flow, int nodeId) {
        LLMAction llmAction = (LLMAction)flow.findActionById(nodeId);
        int promptType = (Integer)this.getModel().getValue(KEY_CUR_TEMPLATE);
        llmAction.setPromptType(promptType);
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
            if (serviceInfo != null) {
                llmAction.setLlmPromptId(serviceInfo.getLong("id"));
            }
            String userInputParam = (String)this.getModel().getValue(KEY_USERINPUT_PARAM);
            VarMapper userInputMapper = this.buildVarMapper(userInputParam, "");
            llmAction.setUserInputMapper(userInputMapper);
            String dyRepo = (String)this.getModel().getValue(KEY_DY_REPO);
            VarMapper llmMapper = this.buildVarMapper(dyRepo, "");
            llmAction.setRepoMapper(llmMapper);
            DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
            ArrayList<VarMapper> varMapper = new ArrayList<VarMapper>(10);
            if (inputs != null) {
                for (DynamicObject input : inputs) {
                    String name = input.getString(KEY_INPUT_NAME);
                    String sourceParam = input.getString(KEY_INPUT_SOURCEPARAM);
                    VarMapper varM = this.buildVarMapper(sourceParam, name);
                    if (varM == null) continue;
                    varMapper.add(varM);
                }
            }
            llmAction.setInParamMap(varMapper);
        } else {
            Object LLMObject = this.getModel().getValue(KEY_LLM);
            if (LLMObject != null) {
                String llm = (String)LLMObject;
                llmAction.setLlm(llm);
            }
            this.savePromptContent(llmAction);
        }
        boolean showMessage = (Boolean)this.getModel().getValue(KEY_SHOWMESSAGE);
        llmAction.setStream(showMessage);
        boolean mergeShow = (Boolean)this.getModel().getValue(KEY_MERGE_SHOW);
        llmAction.setMergeLastMessageCard(mergeShow);
    }

    private void savePromptContent(LLMAction llmAction) {
        LargeTextOtherEdit sysLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_SYS_PROMPT);
        String sysTagFieldKey = sysLargeTextEdit.getTagFieldKey();
        LargeTextOtherEdit userLargeTextEdit = (LargeTextOtherEdit)this.getView().getControl(KEY_USER_PROMPT);
        String userTagFieldKey = userLargeTextEdit.getTagFieldKey();
        String userPrompt = (String)this.getModel().getValue(userTagFieldKey);
        String sysPrompt = (String)this.getModel().getValue(sysTagFieldKey);
        PromptTemplateContent promptTemplateContent = new PromptTemplateContent();
        promptTemplateContent.setUserPrompt(userPrompt);
        promptTemplateContent.setSysPrompt(sysPrompt);
        DynamicObjectCollection inputs = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        ArrayList<VarMapper> varMappers = new ArrayList<VarMapper>(10);
        if (inputs != null) {
            ArrayList<Var> inputVars = new ArrayList<Var>();
            for (DynamicObject row : inputs) {
                String name = row.getString(KEY_INPUT_NAME);
                String type = row.getString(KEY_INPUT_TYPE);
                String desc = row.getString(KEY_INPUT_DESC);
                Var var = new Var(name, type, desc);
                inputVars.add(var);
                VarMapper varM = new VarMapper();
                String sourceParam = row.getString(KEY_INPUT_SOURCEPARAM);
                if (!StringUtils.isNotBlank((CharSequence)sourceParam)) continue;
                String[] arr = sourceParam.split(SEPERATOR);
                int selNodeId = Integer.parseInt(arr[0]);
                String param = arr[1];
                varM.setInVarName(name);
                varM.setOutNodeId(selNodeId);
                varM.setOutVarName(param);
                varMappers.add(varM);
            }
            promptTemplateContent.setInputVarList(inputVars);
        }
        llmAction.setInParamMap(varMappers);
        ArrayList<Var> outputVars = new ArrayList<Var>();
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        if (outputDoc != null && outputDoc.size() > 0) {
            outputVars = new ArrayList();
            for (DynamicObject row : outputDoc) {
                String name = row.getString(KEY_OUTPUT_NAME);
                String type = row.getString(KEY_OUTPUT_TYPE);
                String desc = row.getString(KEY_OUTPUT_DESC);
                Var var = new Var(name, type, desc);
                outputVars.add(var);
            }
        }
        promptTemplateContent.setOutputVarList(outputVars);
        llmAction.setPromptTemplateContent(promptTemplateContent);
    }

    private VarMapper buildVarMapper(String sourceParam, String name) {
        if (StringUtils.isNotBlank((CharSequence)sourceParam)) {
            VarMapper varM = new VarMapper();
            String[] arr = sourceParam.split(SEPERATOR);
            int selNodeId = Integer.parseInt(arr[0]);
            String param = arr[1];
            varM.setInVarName(name);
            varM.setOutNodeId(selNodeId);
            varM.setOutVarName(param);
            return varM;
        }
        return null;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (KEY_PROMPTINFO.equals(propertyName)) {
            this.fillInputAndOutput();
        } else if (propertyName.equals(KEY_INPUT_NAME)) {
            ChangeData data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_INPUT_NAME, KEY_ENTRYENTITY_INPUT, data);
        } else if (propertyName.equals(KEY_OUTPUT_NAME)) {
            ChangeData data = e.getChangeSet()[0];
            this.validateNodeVarName(KEY_OUTPUT_NAME, KEY_ENTRYENTITY_OUTPUT, data);
        }
    }

    private void fillInputAndOutput() {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection input = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        input.clear();
        DynamicObjectCollection output = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        output.clear();
        DynamicObject serviceInfo = (DynamicObject)this.getModel().getValue(KEY_PROMPTINFO);
        if (serviceInfo != null) {
            EntryType inEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
            DynamicObjectCollection preRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_VARCONFIG);
            if (preRows != null && !preRows.isEmpty()) {
                int index = 0;
                for (DynamicObject row : preRows) {
                    DynamicObject inputRow = new DynamicObject((DynamicObjectType)inEntryType);
                    String name = row.getString("var");
                    String type = row.getString("var_type");
                    inputRow.set(KEY_INPUT_NAME, (Object)name);
                    inputRow.set(KEY_INPUT_TYPE, (Object)type);
                    input.add((Object)inputRow);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{KEY_INPUT_TYPE, KEY_INPUT_NAME});
                    ++index;
                }
            }
            EntryType outEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
            DynamicObjectCollection outRows = serviceInfo.getDynamicObjectCollection(KEY_ENTRYENTITY_OUTVARCONFIG);
            if (outRows != null && !outRows.isEmpty()) {
                int index = 0;
                for (DynamicObject row : outRows) {
                    DynamicObject outputRow = new DynamicObject((DynamicObjectType)outEntryType);
                    String name = row.getString("out_var");
                    String type = row.getString("out_var_type");
                    outputRow.set(KEY_OUTPUT_NAME, (Object)name);
                    outputRow.set(KEY_OUTPUT_TYPE, (Object)type);
                    output.add((Object)outputRow);
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{KEY_OUTPUT_TYPE, KEY_OUTPUT_NAME});
                    ++index;
                }
            }
        }
        this.getView().updateView(KEY_ENTRYENTITY_INPUT);
        this.getView().updateView(KEY_ENTRYENTITY_OUTPUT);
    }

    private void changeInputTable(List<Var> inputVarList) {
        if (inputVarList == null) {
            return;
        }
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_INPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection inputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_INPUT);
        inputDoc.clear();
        for (Var var : inputVarList) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set(KEY_INPUT_NAME, (Object)var.getName());
            row.set(KEY_INPUT_TYPE, (Object)var.getType());
            row.set(KEY_INPUT_DESC, (Object)var.getDesc());
            inputDoc.add((Object)row);
        }
    }

    private void changeOutputTable(List<Var> outputVarList) {
        if (outputVarList == null) {
            return;
        }
        EntryType outputEntryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY_OUTPUT);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection outputDoc = this.getModel().getEntryEntity(KEY_ENTRYENTITY_OUTPUT);
        outputDoc.clear();
        for (Var var : outputVarList) {
            DynamicObject row = new DynamicObject((DynamicObjectType)outputEntryType);
            row.set(KEY_OUTPUT_NAME, (Object)var.getName());
            row.set(KEY_OUTPUT_TYPE, (Object)var.getType());
            row.set(KEY_OUTPUT_DESC, (Object)var.getDesc());
            outputDoc.add((Object)row);
        }
    }

    @Override
    public NodeValidateInfo nodeValidate(ProcessNodeType noteType, int nodeId) {
        NodeValidateInfo validateInfo = new NodeValidateInfo();
        validateInfo.setNodeId(nodeId);
        validateInfo.setStatus(NodeValidateInfo.ValidateStatus.PASS.getValue());
        validateInfo.setValidMessage("");
        int promptType = (Integer)this.getModel().getValue(KEY_CUR_TEMPLATE);
        String sMessage = this.check(promptType);
        if (StringUtils.isNotEmpty((CharSequence)sMessage)) {
            validateInfo.setStatus(NodeValidateInfo.ValidateStatus.ERROR.getValue());
            validateInfo.setValidMessage(sMessage);
        }
        return validateInfo;
    }

    @Override
    public void saveDataToFlow(Flow flow) {
        this.clickGPTPrompt(flow, this.getNodeId());
    }

    private String check(int promptType) {
        if (promptType == PromptTemplateType.CUSTOM_PROMPT.getCode()) {
            if (this.getModel().getValue(KEY_PROMPTINFO) == null) {
                return ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
            if (this.getModel().getValue(KEY_USERINPUT_PARAM) == null) {
                return ResManager.loadKDString((String)"\u7528\u6237\u8f93\u5165\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_1", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
        } else {
            String llm = (String)this.getModel().getValue(KEY_LLM);
            if (StringUtils.isEmpty((CharSequence)llm)) {
                return ResManager.loadKDString((String)"\u8bed\u8a00\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GaiProcessPromptSetPlugin_2", (String)"ai-gai-plugin", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

