/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Optional;
import kd.ai.gai.core.agent.tool.model.ImageParam;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.util.DynamicObjectUtils;
import kd.ai.gai.core.util.GaiUtils;
import kd.ai.gai.core.util.OperationResultUtil;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class GaiProcessTemplateListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(GaiProcessTemplateListPlugin.class);
    public static final String KEY_ID = "ID";
    public static final String KINGDEE_AVATAR = "/kingdee/gai/images/pc/tool/gai_tool_kingdee_square.png";
    public static final String USE_TEMPLATE = "usetemplate";
    private static final String CONTROL_DISABLE = "lbl_dd_disable";
    private static final String CONTROL_DELETE = "lbl_dd_delete";
    private static final String CONTROL_ENABLE = "labelap2";
    private static final String BILL_LIST = "billlistap";
    private static final String CREATOR_ID = "creator_id";
    private static final String MODIFIER_ID = "modifier_id";
    private static final String CREATEORG_ID = "createorg_id";
    private static final String ORG_ID = "org_id";
    private static final String USEORG_ID = "useorg_id";

    private void addClickListener(String controlKey) {
        Label label = (Label)this.getView().getControl(controlKey);
        label.addClickListener((ClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListener(CONTROL_DISABLE);
        this.addClickListener(CONTROL_DELETE);
        this.addClickListener(CONTROL_ENABLE);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_DISABLE) || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)CONTROL_ENABLE)) {
            BillList list = (BillList)this.getControl(BILL_LIST);
            list.selectRows(new int[0]);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
        treeListModel.getQueryParas().put("order", "modifytime");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (USE_TEMPLATE.equals(evt.getItemKey())) {
            this.handleUseTemplate();
        }
    }

    private void handleUseTemplate() {
        BillList list = (BillList)this.getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = list.getSelectedRows();
        if (selectedRows.size() > 1) {
            this.showTip("\u8bf7\u52fe\u9009\u5355\u6761\u6570\u636e\u3002", "GaiProcessTemplateListPlugin_1");
            return;
        }
        if (selectedRows.size() == 0) {
            this.showTip("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", "GaiProcessTemplateListPlugin_2");
            return;
        }
        Object pkId = selectedRows.get(0).getPrimaryKeyValue();
        this.createProcessFromTemplate(pkId);
        list.selectRows(new int[0]);
    }

    private void showTip(String msg, String key) {
        this.getView().showTipNotification(ResManager.loadKDString((String)msg, (String)key, (String)"ai-gai-plugin", (Object[])new Object[0]));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new BillListDataProvider());
    }

    private void createProcessFromTemplate(Object id) {
        String processFormId = GaiFormIdEnum.GAI_PROCESS.getId();
        String templateFormId = GaiFormIdEnum.GAI_PROCESS_TEMPLATE.getId();
        QFilter idFilter = new QFilter(KEY_ID, "=", id);
        DynamicObject templateDO = BusinessDataServiceHelper.loadSingle((String)templateFormId, (QFilter[])new QFilter[]{idFilter});
        DynamicObject processDO = BusinessDataServiceHelper.newDynamicObject((String)processFormId);
        DynamicObjectType processDoType = processDO.getDynamicObjectType();
        RequestContext rc = RequestContext.get();
        long currUserId = rc.getCurrUserId();
        long currOrgId = rc.getOrgId();
        Date currDate = KDDateUtils.now();
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)currOrgId, (String)"bos_org", (String)String.format("%s,%s,%s", "id", "name", "number"));
        processDO = DynamicObjectUtils.deepCopy((IDataEntityType)processDoType, (DynamicObject)templateDO, (boolean)true, (boolean)true);
        long genId = ID.genLongId();
        processDO.set("id", (Object)genId);
        processDO.set("number", null);
        processDO.set("creator", (Object)currUserId);
        processDO.set("modifier", (Object)currUserId);
        processDO.set("createtime", (Object)currDate);
        processDO.set("modifytime", (Object)currDate);
        processDO.set("org", (Object)org);
        processDO.set("createorg", (Object)org);
        processDO.set("useorg", (Object)org);
        processDO.set("enable", (Object)EnableEnum.YES.getKeyStr());
        processDO.set("ispreset", (Object)EnableEnum.NO.getKeyStr());
        OperationResult opResult = SaveServiceHelper.saveOperate((String)"gai_process", (DynamicObject[])new DynamicObject[]{processDO}, (OperateOption)OperateOption.create());
        if (!opResult.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getOperationResultMessage((OperationResult)opResult));
            return;
        }
        BillShowParameter showParam = new BillShowParameter();
        showParam.setPkId((Object)genId);
        showParam.setFormId(processFormId);
        showParam.setStatus(OperationStatus.EDIT);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.MainNewTabPage);
        showParam.setOpenStyle(openStyle);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public static class BillListDataProvider
    extends ListDataProvider {
        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            HashMap mapAvatar = new HashMap();
            String kingdee_name = ResManager.loadKDString((String)"\u91d1\u8776\u5b98\u65b9", (String)"GaiProcessTemplateListPlugin_0", (String)"ai-gai-plugin", (Object[])new Object[0]);
            rows.forEach(dynamicObject -> {
                DynamicObject group;
                boolean ispreset = dynamicObject.getBoolean("ispreset");
                if (ispreset) {
                    String url = GaiUtils.getHost() + GaiProcessTemplateListPlugin.KINGDEE_AVATAR;
                    DynamicObject creator = dynamicObject.getDynamicObject("creator");
                    if (creator != null) {
                        CloneUtils cloneUtils = new CloneUtils(false, true);
                        DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)creator);
                        newCreator.set("picturefield", (Object)url);
                        newCreator.set("name", (Object)kingdee_name);
                        dynamicObject.set("creator", (Object)newCreator);
                    } else {
                        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"picturefield");
                        CloneUtils cloneUtils = new CloneUtils(false, true);
                        DynamicObject newCreator = (DynamicObject)cloneUtils.clone((IDataEntityBase)currentUser);
                        newCreator.set("picturefield", (Object)url);
                        newCreator.set("name", (Object)kingdee_name);
                        dynamicObject.set("creator", (Object)newCreator);
                    }
                    String avatar = dynamicObject.getString("avatar");
                    if (StringUtils.isBlank((CharSequence)avatar)) {
                        String name = dynamicObject.getString("name");
                        Optional images = ImageParam.createImages((String)name, (String)"processtemplate");
                        images.ifPresent(imagePath -> {
                            dynamicObject.set("avatar", imagePath);
                            Object pkId = dynamicObject.getPkValue();
                            mapAvatar.put(pkId, imagePath);
                        });
                    }
                }
                if ((group = dynamicObject.getDynamicObject("group")) == null) {
                    group = BusinessDataServiceHelper.newDynamicObject((String)"gai_process_tpl_group");
                    group.set("number", (Object)"none");
                }
                dynamicObject.set("group", (Object)group);
            });
            if (mapAvatar.size() > 0) {
                DynamicObject[] dynamicObjectArray;
                DynamicObjectType dynamicObjectType = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_PROCESS_TEMPLATE.getId()).getDynamicObjectType();
                Object[] pkValueArray = mapAvatar.keySet().toArray();
                for (DynamicObject dynamicObjectForUpdate : dynamicObjectArray = BusinessDataServiceHelper.load((Object[])pkValueArray, (DynamicObjectType)dynamicObjectType)) {
                    String avatarImagePath = (String)mapAvatar.get(dynamicObjectForUpdate.getPkValue());
                    dynamicObjectForUpdate.set("avatar", (Object)avatarImagePath);
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
            }
            return rows;
        }
    }
}

